/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.File;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReceiver;
import org.exoplatform.services.jcr.ext.replication.async.AsyncTransmitter;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportClient;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportError;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportResponce;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporter;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ItemStatesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.Member;
import org.exoplatform.services.jcr.ext.replication.async.storage.RandomChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.transport.MemberAddress;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteExporterImpl
implements RemoteExporter,
RemoteExportClient {
    public static final String FILE_PREFIX = "exporter";
    private static final Log LOG = ExoLogger.getLogger((String)"ext.RemoteExporterImpl");
    protected final AsyncTransmitter transmitter;
    protected final AsyncReceiver receiver;
    protected final ResourcesHolder resHolder = new ResourcesHolder();
    protected final File tempDir;
    protected MemberAddress remoteMember;
    protected Member changesOwner = null;
    private RandomChangesFile changesFile = null;
    private CountDownLatch latch;
    private RemoteExportException exception = null;

    RemoteExporterImpl(AsyncTransmitter transmitter, AsyncReceiver receiver, String tempDir) {
        this.transmitter = transmitter;
        this.receiver = receiver;
        this.tempDir = new File(tempDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangesStorage<ItemState> exportItem(String nodeId) throws RemoteExportException {
        LOG.info((Object)("Remote EXPORT from member " + this.remoteMember + ", node " + nodeId));
        this.receiver.setRemoteExportListener(this);
        try {
            this.transmitter.sendGetExport(nodeId, this.remoteMember);
        }
        catch (IOException e) {
            throw new RemoteExportException(e);
        }
        this.latch = new CountDownLatch(1);
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RemoteExportException(e);
        }
        finally {
            this.receiver.removeRemoteExportListener();
            if (this.exception != null) {
                try {
                    throw new RemoteExportException(this.exception);
                }
                catch (Throwable throwable) {
                    this.exception = null;
                    throw throwable;
                }
            }
        }
        LOG.info((Object)("Remote EXPORT DONE from member " + this.remoteMember + ", node " + nodeId));
        try {
            DigestInputStream dis = new DigestInputStream(this.changesFile.getInputStream(), MessageDigest.getInstance("MD5"));
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = dis.read(buf)) > 0) {
                }
                if (!MessageDigest.isEqual(dis.getMessageDigest().digest(), this.changesFile.getChecksum())) {
                    // empty if block
                }
            }
            finally {
                dis.close();
            }
            if (this.changesOwner == null) {
                throw new RemoteExportException("Changes owner (member) is not set");
            }
            ItemStatesStorage<ItemState> itemStatesStorage = new ItemStatesStorage<ItemState>(this.changesFile, this.changesOwner);
            return itemStatesStorage;
        }
        catch (IOException e) {
            throw new RemoteExportException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RemoteExportException(e);
        }
        finally {
            this.changesFile = null;
        }
    }

    @Override
    public void setRemoteMember(MemberAddress address) {
        this.remoteMember = address;
    }

    @Override
    public void onRemoteExport(RemoteExportResponce event) {
        try {
            switch (event.getType()) {
                case 0: {
                    this.initChangesFile(event.getCRC(), event.getTimeStamp());
                    this.changesOwner = event.getMember();
                    this.changesFile.writeData(event.getBuffer(), event.getOffset());
                    break;
                }
                case 1: {
                    this.initChangesFile(event.getCRC(), event.getTimeStamp());
                    this.changesFile.writeData(event.getBuffer(), event.getOffset());
                    break;
                }
                case 2: {
                    this.changesFile.finishWrite();
                    this.changesFile.validate();
                    this.latch.countDown();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Cannot save export changes", (Throwable)e);
            this.exception = new RemoteExportException(e);
            this.latch.countDown();
        }
    }

    @Override
    public void onRemoteError(RemoteExportError event) {
        this.exception = new RemoteExportException(event.getErrorMessage());
        this.latch.countDown();
    }

    private void initChangesFile(byte[] crc, long timeStamp) throws IOException {
        if (this.changesFile == null) {
            try {
                this.changesFile = new RandomChangesFile(File.createTempFile(FILE_PREFIX, "-" + timeStamp), crc, timeStamp, this.resHolder);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    @Override
    public void cleanup() {
        try {
            this.resHolder.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Error of data fiels close " + e), (Throwable)e);
        }
        for (File f : this.tempDir.listFiles()) {
            if (f.delete()) continue;
            LOG.warn((Object)("Cannot delete exporter temp file " + f.getAbsolutePath()));
        }
    }
}

