/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.merge;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporter;
import org.exoplatform.services.jcr.ext.replication.async.merge.AbstractMerger;
import org.exoplatform.services.jcr.ext.replication.async.storage.BufferedItemStatesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.CompositeItemStatesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.EditableChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.jcr.impl.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixinMerger
extends AbstractMerger {
    public MixinMerger(boolean localPriority, RemoteExporter exporter, DataManager dataManager, NodeTypeDataManager ntManager, ResourcesHolder resHolder) {
        super(localPriority, exporter, dataManager, ntManager, resHolder);
    }

    @Override
    public EditableChangesStorage<ItemState> merge(ItemState itemChange, ChangesStorage<ItemState> income, ChangesStorage<ItemState> local, String mergeTempDir, List<QPath> skippedList, List<QPath> restoredOrder) throws RepositoryException, RemoteExportException, IOException, ClassCastException, ClassNotFoundException, StorageRuntimeException {
        boolean itemChangeProcessed = false;
        ItemState incomeState = itemChange;
        CompositeItemStatesStorage<ItemState> resultState = new CompositeItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
        Iterator<ItemState> liter = local.getChanges();
        block14: while (liter.hasNext()) {
            List<ItemState> updateSeq;
            ItemState nextLocalState;
            ItemState localState = liter.next();
            ItemData localData = localState.getData();
            ItemData incomeData = incomeState.getData();
            if (!localData.isNode() && (localData.getQPath().getName().equals((Object)Constants.JCR_LOCKISDEEP) || localData.getQPath().getName().equals((Object)Constants.JCR_LOCKOWNER))) continue;
            if (this.isLocalPriority()) {
                switch (localState.getState()) {
                    case 1: {
                        break;
                    }
                    case 4: {
                        nextLocalState = local.findNextState(localState, localData.getIdentifier());
                        if (nextLocalState != null && nextLocalState.getState() == 2) {
                            updateSeq = local.getUpdateSequence(localState);
                            for (ItemState item : updateSeq) {
                                if (!incomeData.getQPath().equals((Object)item.getData().getQPath()) && !incomeData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                                this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                                return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                            }
                            continue block14;
                        }
                        if (nextLocalState != null && nextLocalState.getState() == 32) {
                            if (!localData.isNode() || !incomeData.getQPath().equals((Object)localData.getQPath())) break;
                            this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                            return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                        }
                        if (!localData.isNode() || !incomeData.getQPath().equals((Object)localData.getQPath())) break;
                        this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                        return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                    }
                    case 2: {
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 16: {
                        if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                        List<ItemState> mixinSequence = income.getMixinSequence(incomeState);
                        for (int i = 1; i < mixinSequence.size(); ++i) {
                            skippedList.add(mixinSequence.get(i).getData().getQPath());
                        }
                        return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                    }
                }
                continue;
            }
            switch (localState.getState()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    nextLocalState = local.findNextState(localState, localData.getIdentifier());
                    if (nextLocalState != null && nextLocalState.getState() == 2) {
                        updateSeq = local.getUpdateSequence(localState);
                        for (ItemState st : updateSeq) {
                            if (!incomeData.getQPath().isDescendantOf(st.getData().getQPath()) && !incomeData.getQPath().equals((Object)st.getData().getQPath()) || this.isOrderRestored(restoredOrder, localData.getQPath().makeParentPath())) continue;
                            restoredOrder.add(localData.getQPath().makeParentPath());
                            for (ItemState inSt : this.generateRestoreOrder(localState, local)) {
                                resultState.add(inSt);
                            }
                        }
                        continue block14;
                    }
                    if (nextLocalState != null && nextLocalState.getState() == 32) {
                        QPath incNodePath;
                        ItemState parentNodeState = income.findNextState(incomeState, incomeData.getParentIdentifier(), incomeData.getQPath().makeParentPath(), 4);
                        if (!incomeData.isNode() && parentNodeState == null) break;
                        QPath qPath = incNodePath = incomeData.isNode() ? incomeData.getQPath() : parentNodeState.getData().getQPath();
                        if (!localData.getQPath().equals((Object)incNodePath)) continue block14;
                        List<ItemState> renameSequence = local.getRenameSequence(localState);
                        for (int i = 0; i < renameSequence.size(); ++i) {
                            ItemState item = renameSequence.get(i);
                            if (!item.getData().isNode() || !incomeData.getQPath().isDescendantOf(item.getData().getQPath()) && !incomeData.getQPath().equals((Object)item.getData().getQPath())) continue;
                            for (int j = renameSequence.size() - 1; j >= 0; --j) {
                                item = renameSequence.get(j);
                                if (item.getState() == 32) {
                                    if (item.getData().isNode()) {
                                        for (ItemState st : this.generateDeleleLockProperties((NodeData)item.getData())) {
                                            resultState.add(st);
                                        }
                                    }
                                    resultState.add(new ItemState(item.getData(), 4, item.isEventFire(), item.getData().getQPath()));
                                    continue;
                                }
                                if (item.getState() != 4) continue;
                                resultState.add(this.generateRestoreRenamedItem(item, renameSequence.get(renameSequence.size() - j - 1)));
                            }
                            for (ItemState st : income.getMixinSequence(incomeState)) {
                                if (st.getData().isNode() && st.getState() == 4) {
                                    for (ItemState inSt : this.generateDeleleLockProperties((NodeData)st.getData())) {
                                        resultState.add(inSt);
                                    }
                                }
                                resultState.add(st);
                            }
                            return resultState;
                        }
                        continue block14;
                    }
                    if (!localData.isNode() || local.findNextState(localState, localData.getParentIdentifier(), localData.getQPath().makeParentPath(), 4) != null || !incomeData.getQPath().equals((Object)localData.getQPath()) && !incomeData.getQPath().isDescendantOf(localData.getQPath())) break;
                    this.accumulateSkippedList(incomeState, localData.getQPath(), income, skippedList);
                    resultState.addAll(this.exporter.exportItem(localData.getIdentifier()));
                    return resultState;
                }
                case 32: {
                    break;
                }
                case 16: {
                    if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                    for (ItemState item : this.generateRestoreMixinChanges(localState, local)) {
                        resultState.add(item);
                    }
                    for (ItemState st : income.getMixinSequence(incomeState)) {
                        if (st.getData().isNode() && st.getState() == 4) {
                            for (ItemState inSt : this.generateDeleleLockProperties((NodeData)st.getData())) {
                                resultState.add(inSt);
                            }
                        }
                        resultState.add(st);
                    }
                    break;
                }
            }
        }
        if (!itemChangeProcessed) {
            for (ItemState st : income.getMixinSequence(incomeState)) {
                if (st.getData().isNode() && st.getState() == 4) {
                    for (ItemState inSt : this.generateDeleleLockProperties((NodeData)st.getData())) {
                        resultState.add(inSt);
                    }
                }
                resultState.add(st);
            }
        }
        return resultState;
    }
}

