/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.impl.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChangesStorage<T extends ItemState>
implements ChangesStorage<T> {
    @Override
    public String dump() throws ClassCastException, IOException, ClassNotFoundException {
        StringBuilder str = new StringBuilder();
        str.append("\r\nState\tID\t\t\t\t\tPersist\tEvent\tInternl\tPath\r\n");
        Iterator iter = this.getChanges();
        while (iter.hasNext()) {
            ItemState state = (ItemState)iter.next();
            str.append(ItemState.nameFromValue((int)state.getState()));
            str.append("\t");
            str.append(state.getData().getIdentifier());
            str.append("\t");
            str.append(state.isPersisted());
            str.append("\t");
            str.append(state.isEventFire());
            str.append("\t");
            str.append(state.isInternallyCreated());
            str.append("\t");
            str.append(state.getData().getQPath().getAsString());
            str.append("\r\n");
        }
        return str.toString();
    }

    @Override
    public T getItemState(NodeData parentData, QPathEntry name) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public T getItemState(String itemIdentifier) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public T findNextState(ItemState fromState, String identifier) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            if (!((ItemState)it.next()).isSame(fromState)) continue;
            while (it.hasNext()) {
                ItemState inState = (ItemState)it.next();
                if (!inState.getData().getIdentifier().equals(identifier)) continue;
                return (T)inState;
            }
        }
        return null;
    }

    @Override
    public int findLastState(QPath itemPath) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        int result = -1;
        while (it.hasNext()) {
            ItemState state = (ItemState)it.next();
            if (!state.getData().getQPath().equals((Object)itemPath)) continue;
            result = state.getState();
        }
        return result;
    }

    @Override
    public boolean hasState(ItemState state) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            if (!((ItemState)it.next()).isSame(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasState(String identifier, QPath path, int state) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            if (!ItemState.isSame((ItemState)((ItemState)it.next()), (String)identifier, (QPath)path, (int)state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T findNextState(ItemState fromState, String identifier, QPath path, int state) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            if (!((ItemState)it.next()).isSame(fromState)) continue;
            while (it.hasNext()) {
                ItemState item = (ItemState)it.next();
                if (!ItemState.isSame((ItemState)item, (String)identifier, (QPath)path, (int)state)) continue;
                return (T)item;
            }
        }
        return null;
    }

    @Override
    public T findNextState(ItemState fromState, QPath path, int state) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            if (!((ItemState)it.next()).isSame(fromState)) continue;
            while (it.hasNext()) {
                ItemState item = (ItemState)it.next();
                if (item.getState() != state || !item.getData().getQPath().equals((Object)path)) continue;
                return (T)item;
            }
        }
        return null;
    }

    @Override
    public T findNextState(ItemState fromState, String identifier, QPath path) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            if (!((ItemState)it.next()).isSame(fromState)) continue;
            while (it.hasNext()) {
                ItemState item = (ItemState)it.next();
                if (!item.getData().getIdentifier().equals(identifier) || !item.getData().getQPath().equals((Object)path)) continue;
                return (T)item;
            }
        }
        return null;
    }

    @Override
    public T findPrevState(ItemState toState, String identifier, QPath path, int state) throws IOException, ClassCastException, ClassNotFoundException {
        ItemState item;
        ItemState result = null;
        Iterator it = this.getChanges();
        while (it.hasNext() && !(item = (ItemState)it.next()).isSame(toState)) {
            if (!ItemState.isSame((ItemState)item, (String)identifier, (QPath)path, (int)state)) continue;
            result = item;
        }
        return (T)result;
    }

    @Override
    public T findPrevState(ItemState toState, String identifier) throws IOException, ClassCastException, ClassNotFoundException {
        ItemState item;
        ItemState result = null;
        Iterator it = this.getChanges();
        while (it.hasNext() && !(item = (ItemState)it.next()).isSame(toState)) {
            if (!item.getData().getIdentifier().equals(identifier)) continue;
            result = item;
        }
        return (T)result;
    }

    @Override
    public T findPrevState(ItemState toState, QPath path, int state) throws IOException, ClassCastException, ClassNotFoundException {
        ItemState item;
        ItemState result = null;
        Iterator it = this.getChanges();
        while (it.hasNext() && !(item = (ItemState)it.next()).isSame(toState)) {
            if (item.getState() != state || !item.getData().getQPath().equals((Object)path)) continue;
            result = item;
        }
        return (T)result;
    }

    @Override
    public T getNextItemStateByIndexOnUpdate(ItemState fromState, int prevIndex) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        ItemState lastState = null;
        while (it.hasNext()) {
            ItemState state = (ItemState)it.next();
            if (!state.isSame(fromState)) continue;
            while (it.hasNext()) {
                ItemState instate = (ItemState)it.next();
                if (instate.getState() != 2) {
                    return (T)lastState;
                }
                if (fromState.getData().getQPath().getIndex() != prevIndex && instate.getData().getQPath().getIndex() == prevIndex + 1) {
                    return (T)instate;
                }
                lastState = instate;
            }
        }
        return (T)lastState;
    }

    @Override
    public T getNextItemStateByUUIDOnUpdate(ItemState fromState, String UUID) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            if (!((ItemState)it.next()).isSame(fromState)) continue;
            while (it.hasNext()) {
                ItemState inState = (ItemState)it.next();
                if (inState.getState() != 2) {
                    return null;
                }
                if (!inState.getData().getIdentifier().equals(UUID)) continue;
                return (T)inState;
            }
        }
        return null;
    }

    @Override
    public List<T> getDescendantsChanges(ItemState firstState, QPath rootPath, boolean unique) throws IOException, ClassCastException, ClassNotFoundException {
        LinkedHashMap<QPath, ItemState> index = new LinkedHashMap<QPath, ItemState>();
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            ItemState item = (ItemState)it.next();
            if (!item.isSame(firstState)) continue;
            boolean checkStartState = false;
            while (it.hasNext() || !checkStartState) {
                ItemState instate = checkStartState ? (ItemState)it.next() : item;
                checkStartState = true;
                if (!instate.getData().getQPath().isDescendantOf(rootPath) || unique && index.get(instate.getData().getQPath()) != null) continue;
                index.put(instate.getData().getQPath(), instate);
            }
        }
        return new ArrayList(index.values());
    }

    @Override
    public List<T> getChanges(ItemState firstState, QPath rootPath, boolean unique) throws IOException, ClassCastException, ClassNotFoundException {
        LinkedHashMap<QPath, ItemState> index = new LinkedHashMap<QPath, ItemState>();
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            ItemState item = (ItemState)it.next();
            if (!item.isSame(firstState)) continue;
            boolean checkStartState = false;
            while (it.hasNext() || !checkStartState) {
                ItemState instate = checkStartState ? (ItemState)it.next() : item;
                checkStartState = true;
                if (!instate.getData().getQPath().isDescendantOf(rootPath) && !instate.getData().getQPath().equals((Object)rootPath) || unique && index.get(instate.getData().getQPath()) != null) continue;
                index.put(instate.getData().getQPath(), instate);
            }
        }
        return new ArrayList(index.values());
    }

    @Override
    public List<T> getChanges(ItemState firstState, QPath rootPath) throws IOException, ClassCastException, ClassNotFoundException {
        ArrayList<ItemState> resultStates = new ArrayList<ItemState>();
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            ItemState item = (ItemState)it.next();
            if (!item.isSame(firstState)) continue;
            boolean checkStartState = false;
            while (it.hasNext() || !checkStartState) {
                ItemState instate = checkStartState ? (ItemState)it.next() : item;
                checkStartState = true;
                if (!instate.getData().getQPath().isDescendantOf(rootPath) && !instate.getData().getQPath().equals((Object)rootPath)) continue;
                resultStates.add(instate);
            }
        }
        return resultStates;
    }

    @Override
    public List<T> getUpdateSequence(ItemState firstState) throws IOException, ClassCastException, ClassNotFoundException {
        ArrayList<ItemState> resultStates = new ArrayList<ItemState>();
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            ItemState state = (ItemState)it.next();
            if (!state.isSame(firstState)) continue;
            resultStates.add(state);
            while (it.hasNext()) {
                ItemState inState = (ItemState)it.next();
                if (inState.getState() != 2 || !inState.getData().getQPath().getName().equals((Object)firstState.getData().getQPath().getName())) continue;
                resultStates.add(inState);
            }
        }
        return resultStates;
    }

    @Override
    public List<T> getRenameSequence(ItemState firstState) throws IOException, ClassCastException, ClassNotFoundException {
        ArrayList<ItemState> resultStates = new ArrayList<ItemState>();
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            ItemState state = (ItemState)it.next();
            if (!state.isSame(firstState)) continue;
            resultStates.add(state);
            while (it.hasNext()) {
                ItemState inState = (ItemState)it.next();
                resultStates.add(inState);
                if (inState.getState() != 32 || !inState.getData().getIdentifier().equals(firstState.getData().getIdentifier())) continue;
                return resultStates;
            }
        }
        return resultStates;
    }

    @Override
    public List<T> getMixinSequence(ItemState firstState) throws IOException, ClassCastException, ClassNotFoundException {
        ArrayList<ItemState> resultStates = new ArrayList<ItemState>();
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            ItemState state = (ItemState)it.next();
            if (!state.isSame(firstState)) continue;
            resultStates.add(state);
            while (it.hasNext()) {
                ItemState inState = (ItemState)it.next();
                if (!inState.isInternallyCreated()) continue;
                resultStates.add(inState);
            }
        }
        return resultStates;
    }

    @Override
    public List<T> getTreeChanges(ItemState firstState, QPath rootPath) throws IOException, ClassCastException, ClassNotFoundException {
        ArrayList<Object> resultStates = new ArrayList<Object>();
        Iterator itemStates = this.getChanges();
        while (itemStates.hasNext()) {
            ItemState item = (ItemState)itemStates.next();
            if (!item.isSame(firstState)) continue;
            boolean checkStartState = false;
            ItemState prevAddedState = null;
            while (itemStates.hasNext() || !checkStartState) {
                T nextState;
                ItemState instate = checkStartState ? (ItemState)itemStates.next() : item;
                checkStartState = true;
                if (prevAddedState != null && prevAddedState.getState() == 4 && instate.getState() == 32 && !instate.getData().getQPath().isDescendantOf(rootPath) && !instate.getData().getQPath().equals((Object)rootPath)) {
                    prevAddedState = null;
                    resultStates.addAll(this.getTreeChanges(instate, instate.getData().getQPath()));
                }
                if (instate.getData().getQPath().isDescendantOf(rootPath) || instate.getData().getQPath().equals((Object)rootPath)) {
                    resultStates.add(instate);
                    prevAddedState = instate;
                    continue;
                }
                if (instate.getState() != 4 || instate.isPersisted() || (nextState = this.findNextState(instate, instate.getData().getIdentifier())).getState() != 32 || !nextState.getData().getQPath().isDescendantOf(rootPath) && !nextState.getData().getQPath().equals((Object)rootPath)) continue;
                resultStates.add(instate);
            }
        }
        return resultStates;
    }

    @Override
    public List<T> getUniqueTreeChanges(ItemState firstState, QPath rootPath) throws IOException, ClassCastException, ClassNotFoundException {
        LinkedHashMap<QPath, Object> index = new LinkedHashMap<QPath, Object>();
        Iterator itemStates = this.getChanges();
        while (itemStates.hasNext()) {
            ItemState item = (ItemState)itemStates.next();
            if (!item.isSame(firstState)) continue;
            boolean checkStartState = false;
            ItemState prevState = null;
            while (itemStates.hasNext() || !checkStartState) {
                T nextState;
                ItemState instate = checkStartState ? (ItemState)itemStates.next() : item;
                checkStartState = true;
                if (prevState != null && prevState.getState() == 4 && instate.getState() == 32) {
                    prevState = null;
                    List<T> states = this.getUniqueTreeChanges(instate, instate.getData().getQPath());
                    for (int i = 0; i < states.size(); ++i) {
                        if (index.get(((ItemState)states.get(i)).getData().getQPath()) != null) continue;
                        index.put(((ItemState)states.get(i)).getData().getQPath(), states.get(i));
                    }
                }
                if (instate.getData().getQPath().isDescendantOf(rootPath) || instate.getData().getQPath().equals((Object)rootPath)) {
                    if (index.get(instate.getData().getQPath()) == null) {
                        index.put(instate.getData().getQPath(), instate);
                    }
                    prevState = instate;
                    continue;
                }
                if (instate.getState() != 4 || instate.isPersisted() || (nextState = this.findNextState(instate, instate.getData().getIdentifier())).getState() != 32 || !nextState.getData().getQPath().isDescendantOf(rootPath) && !nextState.getData().getQPath().equals((Object)rootPath) || index.get(instate.getData().getQPath()) != null) continue;
                index.put(instate.getData().getQPath(), instate);
            }
        }
        return new ArrayList(index.values());
    }

    @Override
    public boolean isParentHasCheckIn(ItemState lastState, QPath childPath) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator itemStates = this.getChanges();
        while (itemStates.hasNext()) {
            PropertyData prop;
            ItemState item = (ItemState)itemStates.next();
            if (!item.getData().isNode() && item.getData().getQPath().getName().equals((Object)Constants.JCR_ISCHECKEDOUT) && (childPath.isDescendantOf(item.getData().getQPath().makeParentPath()) || childPath.equals((Object)item.getData().getQPath().makeParentPath())) && !Boolean.parseBoolean(((ValueData)(prop = (PropertyData)item.getData()).getValues().get(0)).toString())) {
                return true;
            }
            if (!item.isSame(lastState)) continue;
            return false;
        }
        return false;
    }

    @Override
    public QPath findNodeInVS(String uuid) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator itemStates = this.getChanges();
        while (itemStates.hasNext()) {
            PropertyData prop;
            ItemState item = (ItemState)itemStates.next();
            if (!(!item.getData().isNode() & item.getData().getQPath().getName().equals((Object)Constants.JCR_VERSIONABLEUUID)) || !uuid.equals(new String(((ValueData)(prop = (PropertyData)item.getData()).getValues().get(0)).getAsByteArray()))) continue;
            return item.getData().getQPath().makeParentPath();
        }
        return null;
    }
}

