/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.registry;

import java.io.InputStream;
import java.net.URI;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.Registry;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ext.util.XlinkHref;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/registry/")
public class RESTRegistryService
implements ResourceContainer {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.RESTRegistryService");
    private static final String REGISTRY = "registry";
    private static final String EXO_REGISTRY = "exo:registry/";
    private RegistryService regService;
    private ThreadLocalSessionProviderService sessionProviderService;

    public RESTRegistryService(RegistryService regService, ThreadLocalSessionProviderService sessionProviderService) throws Exception {
        this.regService = regService;
        this.sessionProviderService = sessionProviderService;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/{repository}/")
    @Deprecated
    public Response getRegistry(@PathParam(value="repository") String repository, @Context UriInfo uriInfo) {
        try {
            this.regService.getRepositoryService().setCurrentRepositoryName(repository);
            return this.getRegistry(uriInfo);
        }
        catch (Exception e) {
            log.error((Object)"Get registry failed", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{repository}/{entryPath:.+}/")
    @Produces(value={"application/xml"})
    @Deprecated
    public Response getEntry(@PathParam(value="repository") String repository, @PathParam(value="entryPath") String entryPath) {
        try {
            this.regService.getRepositoryService().setCurrentRepositoryName(repository);
            return this.getEntry(entryPath);
        }
        catch (Exception e) {
            log.error((Object)"Get registry entry failed", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="/{repository}/{groupName:.+}/")
    @Consumes(value={"application/xml"})
    @Deprecated
    public Response createEntry(InputStream entryStream, @PathParam(value="repository") String repository, @PathParam(value="groupName") String groupName, @Context UriInfo uriInfo) {
        try {
            this.regService.getRepositoryService().setCurrentRepositoryName(repository);
            return this.createEntry(entryStream, groupName, uriInfo);
        }
        catch (Exception e) {
            log.error((Object)"Create registry entry failed", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="/{repository}/{groupName:.+}/")
    @Consumes(value={"application/xml"})
    @Deprecated
    public Response recreateEntry(InputStream entryStream, @PathParam(value="repository") String repository, @PathParam(value="groupName") String groupName, @Context UriInfo uriInfo, @QueryParam(value="createIfNotExist") boolean createIfNotExist) {
        try {
            this.regService.getRepositoryService().setCurrentRepositoryName(repository);
            return this.recreateEntry(entryStream, groupName, uriInfo, createIfNotExist);
        }
        catch (Exception e) {
            log.error((Object)"Re-create registry entry failed", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{repository}/{entryPath:.+}/")
    @Deprecated
    public Response removeEntry(@PathParam(value="repository") String repository, @PathParam(value="entryPath") String entryPath) {
        try {
            this.regService.getRepositoryService().setCurrentRepositoryName(repository);
            return this.removeEntry(entryPath);
        }
        catch (Exception e) {
            log.error((Object)"Remove registry entry failed", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/xml"})
    public Response getRegistry(@Context UriInfo uriInfo) {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        try {
            Registry.RegistryNode registryEntry = this.regService.getRegistry(sessionProvider);
            if (registryEntry != null) {
                Node registryNode = registryEntry.getNode();
                NodeIterator registryIterator = registryNode.getNodes();
                Document entry = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                String fullURI = uriInfo.getRequestUri().toString();
                XlinkHref xlinkHref = new XlinkHref(fullURI);
                Element root = entry.createElement(REGISTRY);
                xlinkHref.putToElement(root);
                while (registryIterator.hasNext()) {
                    NodeIterator entryIterator = registryIterator.nextNode().getNodes();
                    while (entryIterator.hasNext()) {
                        Node node = entryIterator.nextNode();
                        Element xmlNode = entry.createElement(node.getName());
                        xlinkHref.putToElement(xmlNode, node.getPath().substring(EXO_REGISTRY.length()));
                        root.appendChild(xmlNode);
                    }
                }
                entry.appendChild(root);
                return Response.ok((Object)new DOMSource(entry), (String)"text/xml").build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            log.error((Object)"Get registry failed", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{entryPath:.+}")
    @Produces(value={"application/xml"})
    public Response getEntry(@PathParam(value="entryPath") String entryPath) {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        try {
            RegistryEntry entry = this.regService.getEntry(sessionProvider, RESTRegistryService.normalizePath(entryPath));
            return Response.ok((Object)new DOMSource(entry.getDocument())).build();
        }
        catch (PathNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            log.error((Object)"Get registry entry failed", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="/{groupName:.+}")
    @Consumes(value={"application/xml"})
    public Response createEntry(InputStream entryStream, @PathParam(value="groupName") String groupName, @Context UriInfo uriInfo) {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        try {
            RegistryEntry entry = RegistryEntry.parse(entryStream);
            this.regService.createEntry(sessionProvider, RESTRegistryService.normalizePath(groupName), entry);
            URI location = uriInfo.getRequestUriBuilder().path(entry.getName()).build(new Object[0]);
            return Response.created((URI)location).build();
        }
        catch (Exception e) {
            log.error((Object)"Create registry entry failed", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="/{groupName:.+}")
    @Consumes(value={"application/xml"})
    public Response recreateEntry(InputStream entryStream, @PathParam(value="groupName") String groupName, @Context UriInfo uriInfo, @QueryParam(value="createIfNotExist") boolean createIfNotExist) {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        try {
            RegistryEntry entry = RegistryEntry.parse(entryStream);
            if (createIfNotExist) {
                this.regService.updateEntry(sessionProvider, RESTRegistryService.normalizePath(groupName), entry);
            } else {
                this.regService.recreateEntry(sessionProvider, RESTRegistryService.normalizePath(groupName), entry);
            }
            URI location = uriInfo.getRequestUriBuilder().path(entry.getName()).build(new Object[0]);
            return Response.created((URI)location).build();
        }
        catch (Exception e) {
            log.error((Object)"Re-create registry entry failed", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{entryPath:.+}")
    public Response removeEntry(@PathParam(value="entryPath") String entryPath) {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        try {
            this.regService.removeEntry(sessionProvider, RESTRegistryService.normalizePath(entryPath));
            return null;
        }
        catch (PathNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            log.error((Object)"Remove registry entry failed", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    private static String normalizePath(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }
}

