/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.resource.DocumentViewNodeRepresentation;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentation;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRepresentationService
implements Startable {
    private Map<String, NodeRepresentationFactory> factoriesByNodeType = new HashMap<String, NodeRepresentationFactory>();
    private Map<String, NodeRepresentationFactory> factoriesByKey = new HashMap<String, NodeRepresentationFactory>();
    ExoContainerContext containerContext;
    private static final Log log = ExoLogger.getLogger((String)"jcr.ext.resource.NodeRepresentationService");

    public NodeRepresentationService(ExoContainerContext containerContext) {
        this.containerContext = containerContext;
    }

    public void addNodeRepresentationFactory(String nodeType, NodeRepresentationFactory representationFactory) {
        this.factoriesByNodeType.put(nodeType, representationFactory);
    }

    public NodeRepresentation getNodeRepresentation(Node node, String mediaTypeHint) throws RepositoryException {
        NodeRepresentationFactory factory = this.factory(node);
        if (factory != null) {
            return factory.createNodeRepresentation(node, mediaTypeHint);
        }
        return new DocumentViewNodeRepresentation(node);
    }

    public Collection<String> getNodeTypes() {
        return this.factoriesByNodeType.keySet();
    }

    public Collection<String> getKeys() {
        return this.factoriesByKey.keySet();
    }

    public void start() {
        ExoContainer container = this.containerContext.getContainer();
        List list = container.getComponentInstancesOfType(NodeRepresentationFactory.class);
        for (NodeRepresentationFactory f : list) {
            this.addNodeRepresentationFactory(f.getNodeType(), f);
            log.info((Object)("NodeRepresentationFactory added " + f.getNodeType() + " " + f.getClass().getName()));
        }
    }

    public void stop() {
    }

    private NodeRepresentationFactory factory(Node node) throws RepositoryException {
        NodeRepresentationFactory f = this.factoriesByNodeType.get(node.getPrimaryNodeType().getName());
        if (f == null) {
            for (String nt : this.factoriesByNodeType.keySet()) {
                if (!node.isNodeType(nt)) continue;
                f = this.factoriesByNodeType.get(nt);
                break;
            }
        }
        if (f == null) {
            for (NodeType mixin : node.getMixinNodeTypes()) {
                f = this.factoriesByNodeType.get(mixin.getName());
                if (f == null) continue;
                return f;
            }
        }
        return f;
    }
}

