/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.map.HashedMap;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.config.WorkspaceInitializerEntry;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.ext.backup.BackupChain;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupJob;
import org.exoplatform.services.jcr.ext.backup.BackupJobListener;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.ExtendedBackupManager;
import org.exoplatform.services.jcr.ext.backup.JobEntryInfo;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChain;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChainLog;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupConfig;
import org.exoplatform.services.jcr.ext.backup.RepositoryRestoreExeption;
import org.exoplatform.services.jcr.ext.backup.WorkspaceRestoreException;
import org.exoplatform.services.jcr.ext.backup.impl.BackupChainImpl;
import org.exoplatform.services.jcr.ext.backup.impl.BackupLogsFilter;
import org.exoplatform.services.jcr.ext.backup.impl.BackupMessage;
import org.exoplatform.services.jcr.ext.backup.impl.BackupMessagesLog;
import org.exoplatform.services.jcr.ext.backup.impl.BackupScheduler;
import org.exoplatform.services.jcr.ext.backup.impl.BackupSchedulerException;
import org.exoplatform.services.jcr.ext.backup.impl.FileNameProducer;
import org.exoplatform.services.jcr.ext.backup.impl.JcrRestoreWiFilter;
import org.exoplatform.services.jcr.ext.backup.impl.JobExistingRepositoryRestore;
import org.exoplatform.services.jcr.ext.backup.impl.JobExistingRepositorySameConfigRestore;
import org.exoplatform.services.jcr.ext.backup.impl.JobExistingWorkspaceRestore;
import org.exoplatform.services.jcr.ext.backup.impl.JobExistingWorkspaceSameConfigRestore;
import org.exoplatform.services.jcr.ext.backup.impl.JobRepositoryRestore;
import org.exoplatform.services.jcr.ext.backup.impl.JobWorkspaceRestore;
import org.exoplatform.services.jcr.ext.backup.impl.RepositoryBackupChainImpl;
import org.exoplatform.services.jcr.ext.backup.impl.RepositoryBackupLogsFilter;
import org.exoplatform.services.jcr.ext.backup.impl.fs.FullBackupJob;
import org.exoplatform.services.jcr.ext.backup.impl.fs.IncrementalBackupJob;
import org.exoplatform.services.jcr.ext.backup.impl.rdbms.RdbmsWorkspaceInitializer;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.jcr.impl.backup.JCRRestore;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SysViewWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupManagerImpl
implements ExtendedBackupManager,
Startable {
    protected static Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.BackupManagerImpl");
    public static final String DEFAULT_INCREMENTAL_JOB_PERIOD = "default-incremental-job-period";
    public static final String BACKUP_PROPERTIES = "backup-properties";
    public static final String FULL_BACKUP_TYPE = "full-backup-type";
    public static final String INCREMENTAL_BACKUP_TYPE = "incremental-backup-type";
    public static final String DEFAULT_VALUE_INCREMENTAL_JOB_PERIOD = "3600";
    public static final String DEFAULT_VALUE_INCREMENTAL_BACKUP_TYPE = IncrementalBackupJob.class.getName();
    public static final String DEFAULT_VALUE_FULL_BACKUP_TYPE = org.exoplatform.services.jcr.ext.backup.impl.rdbms.FullBackupJob.class.getName();
    public static final String BACKUP_DIR = "backup-dir";
    private static final int MESSAGES_MAXSIZE = 5;
    private static final String SERVICE_NAME = "BackupManager";
    private static final long AUTO_STOPPER_TIMEOUT = 5000L;
    private long defaultIncrementalJobPeriod;
    private String defIncrPeriod;
    private String backupDir;
    private String fullBackupType;
    private String incrementalBackupType;
    private final Set<BackupChain> currentBackups;
    private final Set<RepositoryBackupChain> currentRepositoryBackups;
    private List<JobWorkspaceRestore> restoreJobs;
    protected List<JobRepositoryRestore> restoreRepositoryJobs;
    private InitParams initParams;
    private File logsDirectory;
    private final RepositoryService repoService;
    private final RegistryService registryService;
    private BackupScheduler scheduler;
    private final BackupMessagesLog messages;
    private final MessagesListener messagesListener = new MessagesListener();
    private final WorkspaceBackupAutoStopper workspaceBackupStopper;
    private final RepositoryBackupAutoStopper repositoryBackupStopper;
    private final File tempDir;

    public BackupManagerImpl(InitParams initParams, RepositoryService repoService) {
        this(null, initParams, repoService, null);
    }

    public BackupManagerImpl(ExoContainerContext ctx, InitParams initParams, RepositoryService repoService) {
        this(ctx, initParams, repoService, null);
    }

    public BackupManagerImpl(InitParams initParams, RepositoryService repoService, RegistryService registryService) {
        this(null, initParams, repoService, registryService);
    }

    public BackupManagerImpl(ExoContainerContext ctx, InitParams initParams, RepositoryService repoService, RegistryService registryService) {
        this.repoService = repoService;
        this.registryService = registryService;
        this.initParams = initParams;
        this.tempDir = new File(PrivilegedSystemHelper.getProperty((String)"java.io.tmpdir"));
        this.currentBackups = Collections.synchronizedSet(new HashSet());
        this.currentRepositoryBackups = Collections.synchronizedSet(new HashSet());
        this.messages = new BackupMessagesLog(5);
        this.scheduler = new BackupScheduler(this, this.messages);
        this.restoreJobs = new ArrayList<JobWorkspaceRestore>();
        this.restoreRepositoryJobs = new ArrayList<JobRepositoryRestore>();
        this.workspaceBackupStopper = new WorkspaceBackupAutoStopper(ctx);
        this.workspaceBackupStopper.start();
        this.repositoryBackupStopper = new RepositoryBackupAutoStopper(ctx);
        this.repositoryBackupStopper.start();
    }

    @Override
    public Set<BackupChain> getCurrentBackups() {
        return this.currentBackups;
    }

    @Override
    public BackupMessage[] getMessages() {
        return this.messages.getMessages();
    }

    @Override
    public BackupChainLog[] getBackupsLogs() {
        File[] cfs = PrivilegedFileHelper.listFiles((File)this.logsDirectory, (FileFilter)new BackupLogsFilter());
        ArrayList<BackupChainLog> logs = new ArrayList<BackupChainLog>();
        for (int i = 0; i < cfs.length; ++i) {
            File cf = cfs[i];
            try {
                if (this.isCurrentBackup(cf)) continue;
                logs.add(new BackupChainLog(cf));
                continue;
            }
            catch (BackupOperationException e) {
                log.warn((Object)("Log file " + PrivilegedFileHelper.getAbsolutePath((File)cf) + " is bussy or corrupted. Skipped. " + e), (Throwable)e);
            }
        }
        BackupChainLog[] ls = new BackupChainLog[logs.size()];
        logs.toArray(ls);
        return ls;
    }

    @Override
    public RepositoryBackupChainLog[] getRepositoryBackupsLogs() {
        File[] cfs = PrivilegedFileHelper.listFiles((File)this.logsDirectory, (FileFilter)new RepositoryBackupLogsFilter());
        ArrayList<RepositoryBackupChainLog> logs = new ArrayList<RepositoryBackupChainLog>();
        for (int i = 0; i < cfs.length; ++i) {
            File cf = cfs[i];
            try {
                if (this.isCurrentRepositoryBackup(cf)) continue;
                logs.add(new RepositoryBackupChainLog(cf));
                continue;
            }
            catch (BackupOperationException e) {
                log.warn((Object)("Log file " + PrivilegedFileHelper.getAbsolutePath((File)cf) + " is bussy or corrupted. Skipped. " + e), (Throwable)e);
            }
        }
        RepositoryBackupChainLog[] ls = new RepositoryBackupChainLog[logs.size()];
        logs.toArray(ls);
        return ls;
    }

    private boolean isCurrentBackup(File log) {
        for (BackupChain chain : this.currentBackups) {
            if (!log.getName().equals(new File(chain.getLogFilePath()).getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isCurrentRepositoryBackup(File log) {
        for (RepositoryBackupChain chain : this.currentRepositoryBackups) {
            if (!log.getName().equals(new File(chain.getLogFilePath()).getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void restore(BackupChainLog log, String repositoryName, WorkspaceEntry workspaceEntry) throws BackupOperationException, RepositoryException, RepositoryConfigurationException, BackupConfigurationException {
        String workspaceName;
        List<JobEntryInfo> list = log.getJobEntryInfos();
        BackupConfig config = log.getBackupConfig();
        String reposytoryName = repositoryName == null ? config.getRepository() : repositoryName;
        if (!this.workspaceAlreadyExist(reposytoryName, workspaceName = workspaceEntry.getName())) {
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    try {
                        this.fullRestore(list.get(i).getURL().getPath(), reposytoryName, workspaceName, workspaceEntry);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw new BackupOperationException("Restore of full backup file error " + e, e);
                    }
                    catch (IOException e) {
                        throw new BackupOperationException("Restore of full backup file I/O error " + e, e);
                    }
                }
                try {
                    this.incrementalRestore(list.get(i).getURL().getPath(), reposytoryName, workspaceName);
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new BackupOperationException("Restore of incremental backup file error " + e, e);
                }
                catch (IOException e) {
                    throw new BackupOperationException("Restore of incremental backup file I/O error " + e, e);
                }
                catch (ClassNotFoundException e) {
                    throw new BackupOperationException("Restore of incremental backup error " + e, e);
                }
            }
        } else {
            throw new BackupConfigurationException("Workspace should exists " + workspaceName);
        }
    }

    protected void restoreOverInitializer(BackupChainLog log, String repositoryName, WorkspaceEntry workspaceEntry) throws BackupOperationException, RepositoryException, RepositoryConfigurationException, BackupConfigurationException {
        String fullbackupType;
        String workspaceName;
        String reposytoryName;
        List<JobEntryInfo> list;
        block16: {
            list = log.getJobEntryInfos();
            BackupConfig config = log.getBackupConfig();
            reposytoryName = repositoryName == null ? config.getRepository() : repositoryName;
            workspaceName = workspaceEntry.getName();
            fullbackupType = null;
            try {
                if (Class.forName(log.getFullBackupType()).equals(FullBackupJob.class)) {
                    fullbackupType = log.getFullBackupType();
                    break block16;
                }
                if (Class.forName(log.getFullBackupType()).equals(org.exoplatform.services.jcr.ext.backup.impl.rdbms.FullBackupJob.class)) {
                    fullbackupType = log.getFullBackupType();
                    break block16;
                }
                throw new BackupOperationException("Class  \"" + log.getFullBackupType() + "\" is not support as full backup.");
            }
            catch (ClassNotFoundException e) {
                throw new BackupOperationException("Class \"" + log.getFullBackupType() + "\" is not found.", e);
            }
        }
        if (!this.workspaceAlreadyExist(reposytoryName, workspaceName)) {
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    try {
                        this.fullRestoreOverInitializer(list.get(i).getURL().getPath(), reposytoryName, workspaceEntry, fullbackupType);
                    }
                    catch (FileNotFoundException e) {
                        throw new BackupOperationException("Restore of full backup file error " + e, e);
                    }
                    catch (IOException e) {
                        throw new BackupOperationException("Restore of full backup file I/O error " + e, e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new BackupOperationException("Restore of full backup class load error " + e, e);
                    }
                    this.repoService.getConfig().retain();
                    continue;
                }
                try {
                    this.incrementalRestore(list.get(i).getURL().getPath(), reposytoryName, workspaceName);
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new BackupOperationException("Restore of incremental backup file error " + e, e);
                }
                catch (IOException e) {
                    throw new BackupOperationException("Restore of incremental backup file I/O error " + e, e);
                }
                catch (ClassNotFoundException e) {
                    throw new BackupOperationException("Restore of incremental backup error " + e, e);
                }
            }
        } else {
            throw new BackupConfigurationException("Workspace \"" + workspaceName + "\" should not exists.");
        }
    }

    private boolean workspaceAlreadyExist(String repository, String workspace) throws RepositoryException, RepositoryConfigurationException {
        String[] ws = this.repoService.getRepository(repository).getWorkspaceNames();
        for (int i = 0; i < ws.length; ++i) {
            if (!ws[i].equals(workspace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BackupChain startBackup(BackupConfig config) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException {
        return this.startBackup(config, null);
    }

    BackupChain startBackup(BackupConfig config, BackupJobListener jobListener) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException {
        this.validateBackupConfig(config);
        Calendar startTime = Calendar.getInstance();
        File dir = FileNameProducer.generateBackupSetDir(config.getRepository(), config.getWorkspace(), config.getBackupDir().getPath(), startTime);
        PrivilegedFileHelper.mkdirs((File)dir);
        config.setBackupDir(dir);
        BackupChainImpl bchain = new BackupChainImpl(config, this.logsDirectory, this.repoService, this.fullBackupType, this.incrementalBackupType, IdGenerator.generate(), this.logsDirectory, startTime);
        bchain.addListener(this.messagesListener);
        bchain.addListener(jobListener);
        this.currentBackups.add(bchain);
        bchain.startBackup();
        return bchain;
    }

    private void validateBackupConfig(RepositoryBackupConfig config) throws BackupConfigurationException {
        if (config.getIncrementalJobPeriod() < 0L) {
            throw new BackupConfigurationException("The parameter 'incremental job period' can not be negative.");
        }
        if (config.getIncrementalJobNumber() < 0) {
            throw new BackupConfigurationException("The parameter 'incremental job number' can not be negative.");
        }
        if (config.getIncrementalJobPeriod() == 0L && config.getBackupType() == 1) {
            config.setIncrementalJobPeriod(this.defaultIncrementalJobPeriod);
        }
    }

    @Override
    public void stopBackup(BackupChain backup) {
        backup.stopBackup();
        this.currentBackups.remove(backup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        File[] tasks;
        if (!PrivilegedFileHelper.exists((File)this.tempDir)) {
            throw new IllegalStateException("Directory " + this.tempDir.getAbsolutePath() + " not found. Please create it.");
        }
        File[] files = PrivilegedFileHelper.listFiles((File)this.tempDir, (FilenameFilter)new JcrRestoreWiFilter());
        for (int i = 0; i < files.length; ++i) {
            PrivilegedFileHelper.delete((File)files[i]);
        }
        if (this.registryService != null && !this.registryService.getForceXMLConfigurationValue(this.initParams)) {
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            try {
                this.readParamsFromRegistryService(sessionProvider);
            }
            catch (Exception e) {
                this.readParamsFromFile();
                try {
                    this.writeParamsToRegistryService(sessionProvider);
                }
                catch (Exception exc) {
                    log.error((Object)"Cannot write init configuration to RegistryService.", (Throwable)exc);
                }
            }
            finally {
                sessionProvider.close();
            }
        } else {
            this.readParamsFromFile();
        }
        for (File task : tasks = PrivilegedFileHelper.listFiles((File)this.logsDirectory, (FileFilter)new TaskFilter())) {
            try {
                this.scheduler.restore(task);
            }
            catch (BackupSchedulerException e) {
                log.error((Object)("Can't restore backup scheduler task from file " + PrivilegedFileHelper.getAbsolutePath((File)task)), (Throwable)e);
            }
            catch (BackupOperationException e) {
                log.error((Object)("Can't restore backup scheduler task from file " + PrivilegedFileHelper.getAbsolutePath((File)task)), (Throwable)e);
            }
            catch (BackupConfigurationException e) {
                log.error((Object)("Can't restore backup scheduler task from file " + PrivilegedFileHelper.getAbsolutePath((File)task)), (Throwable)e);
            }
            catch (RepositoryException e) {
                log.error((Object)("Can't restore backup scheduler task from file " + PrivilegedFileHelper.getAbsolutePath((File)task)), (Throwable)e);
            }
            catch (RepositoryConfigurationException e) {
                log.error((Object)("Can't restore backup scheduler task from file " + PrivilegedFileHelper.getAbsolutePath((File)task)), (Throwable)e);
            }
        }
    }

    public void stop() {
        this.workspaceBackupStopper.close();
        this.repositoryBackupStopper.close();
        this.scheduler.cancelTimer();
    }

    @Deprecated
    private void fullRestore(String pathBackupFile, String repositoryName, String workspaceName, WorkspaceEntry workspaceEntry) throws FileNotFoundException, IOException, RepositoryException, RepositoryConfigurationException {
        RepositoryImpl defRep = (RepositoryImpl)this.repoService.getRepository(repositoryName);
        defRep.importWorkspace(workspaceEntry.getName(), (InputStream)PrivilegedFileHelper.fileInputStream((String)pathBackupFile));
    }

    private void fullRestoreOverInitializer(String pathBackupFile, String repositoryName, WorkspaceEntry workspaceEntry, String fBackupType) throws FileNotFoundException, IOException, RepositoryException, RepositoryConfigurationException, ClassNotFoundException {
        ArrayList<SimpleParameterEntry> wieParams;
        WorkspaceInitializerEntry wieOriginal = workspaceEntry.getInitializer();
        RepositoryImpl defRep = (RepositoryImpl)this.repoService.getRepository(repositoryName);
        WorkspaceInitializerEntry wiEntry = new WorkspaceInitializerEntry();
        if (Class.forName(fBackupType).equals(FullBackupJob.class)) {
            wiEntry.setType(SysViewWorkspaceInitializer.class.getCanonicalName());
            wieParams = new ArrayList<SimpleParameterEntry>();
            wieParams.add(new SimpleParameterEntry("restore-path", pathBackupFile));
            wiEntry.setParameters(wieParams);
        } else if (Class.forName(fBackupType).equals(org.exoplatform.services.jcr.ext.backup.impl.rdbms.FullBackupJob.class)) {
            wiEntry.setType(RdbmsWorkspaceInitializer.class.getCanonicalName());
            wieParams = new ArrayList();
            wieParams.add(new SimpleParameterEntry("restore-path", new File(pathBackupFile).getParent()));
            wiEntry.setParameters(wieParams);
        }
        workspaceEntry.setInitializer(wiEntry);
        defRep.configWorkspace(workspaceEntry);
        defRep.createWorkspace(workspaceEntry.getName());
        WorkspaceContainerFacade wcf = defRep.getWorkspaceContainer(workspaceEntry.getName());
        WorkspaceEntry createdWorkspaceEntry = (WorkspaceEntry)wcf.getComponent(WorkspaceEntry.class);
        createdWorkspaceEntry.setInitializer(wieOriginal);
    }

    private void incrementalRestore(String pathBackupFile, String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException, BackupOperationException, FileNotFoundException, IOException, ClassNotFoundException {
        WorkspaceContainerFacade workspaceContainer = this.repoService.getRepository(repositoryName).getWorkspaceContainer(workspaceName);
        WorkspacePersistentDataManager dataManager = (WorkspacePersistentDataManager)workspaceContainer.getComponent(WorkspacePersistentDataManager.class);
        FileCleaner fileCleaner = ((FileCleanerHolder)workspaceContainer.getComponent(FileCleanerHolder.class)).getFileCleaner();
        JCRRestore restorer = new JCRRestore((DataManager)dataManager, fileCleaner);
        restorer.incrementalRestore(new File(pathBackupFile));
    }

    private void writeParamsToRegistryService(SessionProvider sessionProvider) throws IOException, SAXException, ParserConfigurationException, RepositoryException {
        Document doc = (Document)SecurityHelper.doPrivilegedParserConfigurationAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Document>(){

            @Override
            public Document run() throws Exception {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
        });
        Element root = doc.createElement(SERVICE_NAME);
        doc.appendChild(root);
        Element element = doc.createElement(BACKUP_PROPERTIES);
        this.setAttributeSmart(element, BACKUP_DIR, this.backupDir);
        this.setAttributeSmart(element, DEFAULT_INCREMENTAL_JOB_PERIOD, this.defIncrPeriod);
        this.setAttributeSmart(element, FULL_BACKUP_TYPE, this.fullBackupType);
        this.setAttributeSmart(element, INCREMENTAL_BACKUP_TYPE, this.incrementalBackupType);
        root.appendChild(element);
        RegistryEntry serviceEntry = new RegistryEntry(doc);
        this.registryService.createEntry(sessionProvider, "exo:services", serviceEntry);
    }

    private void readParamsFromRegistryService(SessionProvider sessionProvider) throws PathNotFoundException, RepositoryException {
        String entryPath = "exo:services/BackupManager/backup-properties";
        RegistryEntry registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        Document doc = registryEntry.getDocument();
        Element element = doc.getDocumentElement();
        this.backupDir = this.getAttributeSmart(element, BACKUP_DIR);
        this.defIncrPeriod = this.getAttributeSmart(element, DEFAULT_INCREMENTAL_JOB_PERIOD);
        this.fullBackupType = this.getAttributeSmart(element, FULL_BACKUP_TYPE);
        this.incrementalBackupType = this.getAttributeSmart(element, INCREMENTAL_BACKUP_TYPE);
        log.info((Object)("Backup dir from RegistryService: " + this.backupDir));
        log.info((Object)("Default incremental job period from RegistryService: " + this.defIncrPeriod));
        log.info((Object)("Full backup type from RegistryService: " + this.fullBackupType));
        log.info((Object)("Incremental backup type from RegistryService: " + this.incrementalBackupType));
        this.checkParams();
    }

    private String getAttributeSmart(Element element, String attr) {
        return element.hasAttribute(attr) ? element.getAttribute(attr) : null;
    }

    private void setAttributeSmart(Element element, String attr, String value) {
        if (value == null) {
            element.removeAttribute(attr);
        } else {
            element.setAttribute(attr, value);
        }
    }

    private void readParamsFromFile() {
        PropertiesParam pps = this.initParams.getPropertiesParam(BACKUP_PROPERTIES);
        this.backupDir = pps.getProperty(BACKUP_DIR);
        this.fullBackupType = pps.getProperty(FULL_BACKUP_TYPE) == null ? DEFAULT_VALUE_FULL_BACKUP_TYPE : pps.getProperty(FULL_BACKUP_TYPE);
        this.defIncrPeriod = pps.getProperty(DEFAULT_INCREMENTAL_JOB_PERIOD) == null ? DEFAULT_VALUE_INCREMENTAL_JOB_PERIOD : pps.getProperty(DEFAULT_INCREMENTAL_JOB_PERIOD);
        this.incrementalBackupType = pps.getProperty(INCREMENTAL_BACKUP_TYPE) == null ? DEFAULT_VALUE_INCREMENTAL_BACKUP_TYPE : pps.getProperty(INCREMENTAL_BACKUP_TYPE);
        log.info((Object)("Backup dir from configuration file: " + this.backupDir));
        log.info((Object)("Full backup type from configuration file: " + this.fullBackupType));
        log.info((Object)("(Experimental) Incremental backup type from configuration file: " + this.incrementalBackupType));
        log.info((Object)("(Experimental) Default incremental job period from configuration file: " + this.defIncrPeriod));
        this.checkParams();
    }

    private void checkParams() {
        if (this.backupDir == null) {
            throw new IllegalStateException("backup-dir not specified");
        }
        this.logsDirectory = new File(this.backupDir);
        if (!PrivilegedFileHelper.exists((File)this.logsDirectory) && !PrivilegedFileHelper.mkdirs((File)this.logsDirectory)) {
            throw new IllegalStateException("Could not create the backup directory at " + this.logsDirectory.getAbsolutePath());
        }
        if (this.defIncrPeriod == null) {
            throw new IllegalStateException("default-incremental-job-period not specified");
        }
        this.defaultIncrementalJobPeriod = Integer.valueOf(this.defIncrPeriod).intValue();
        if (this.fullBackupType == null) {
            throw new IllegalStateException("full-backup-type not specified");
        }
        if (this.incrementalBackupType == null) {
            throw new IllegalStateException("incremental-backup-type not specified");
        }
    }

    @Override
    public BackupChain findBackup(String repository, String workspace) {
        for (BackupChain chain : this.currentBackups) {
            if (!repository.equals(chain.getBackupConfig().getRepository()) || !workspace.equals(chain.getBackupConfig().getWorkspace())) continue;
            return chain;
        }
        return null;
    }

    @Override
    public BackupChain findBackup(String backupId) {
        for (BackupChain chain : this.currentBackups) {
            if (!backupId.equals(chain.getBackupId())) continue;
            return chain;
        }
        return null;
    }

    @Override
    public BackupScheduler getScheduler() {
        return this.scheduler;
    }

    File getLogsDirectory() {
        return this.logsDirectory;
    }

    @Override
    public File getBackupDirectory() {
        return this.getLogsDirectory();
    }

    @Override
    public String getFullBackupType() {
        return this.fullBackupType;
    }

    @Override
    public String getIncrementalBackupType() {
        return this.incrementalBackupType;
    }

    @Override
    public long getDefaultIncrementalJobPeriod() {
        return this.defaultIncrementalJobPeriod;
    }

    @Override
    public List<JobWorkspaceRestore> getRestores() {
        return this.restoreJobs;
    }

    @Override
    public JobWorkspaceRestore getLastRestore(String repositoryName, String workspaceName) {
        for (int i = this.restoreJobs.size() - 1; i >= 0; --i) {
            JobWorkspaceRestore job = this.restoreJobs.get(i);
            if (!repositoryName.equals(job.getRepositoryName()) || !workspaceName.equals(job.getWorkspaceName())) continue;
            return job;
        }
        return null;
    }

    @Override
    public JobRepositoryRestore getLastRepositoryRestore(String repositoryName) {
        for (int i = this.restoreRepositoryJobs.size() - 1; i >= 0; --i) {
            JobRepositoryRestore job = this.restoreRepositoryJobs.get(i);
            if (!repositoryName.equals(job.getRepositoryName())) continue;
            return job;
        }
        return null;
    }

    @Override
    public List<JobRepositoryRestore> getRepositoryRestores() {
        return this.restoreRepositoryJobs;
    }

    @Override
    public void restore(BackupChainLog log, String repositoryName, WorkspaceEntry workspaceEntry, boolean asynchronous) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException {
        if (workspaceEntry == null) {
            if (!log.getBackupConfig().getRepository().equals(repositoryName)) {
                throw new WorkspaceRestoreException("If workspaceEntry is null, so will be restored with original configuration. The repositoryName (\"" + repositoryName + "\")  should be equals original repository name (\"" + log.getBackupConfig().getRepository() + "\"). ");
            }
            if (log.getOriginalWorkspaceEntry() == null) {
                throw new RepositoryRestoreExeption("The backup log is not contains original repository log : " + log.getLogFilePath());
            }
            this.restore(log, log.getBackupConfig().getRepository(), log.getOriginalWorkspaceEntry(), asynchronous);
            return;
        }
        if (asynchronous) {
            JobWorkspaceRestore jobRestore = new JobWorkspaceRestore(this.repoService, this, repositoryName, log, workspaceEntry);
            this.restoreJobs.add(jobRestore);
            jobRestore.start();
        } else {
            this.restoreOverInitializer(log, repositoryName, workspaceEntry);
        }
    }

    @Override
    public void restore(RepositoryBackupChainLog log, RepositoryEntry repositoryEntry, boolean asynchronous) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException {
        this.restore(log, repositoryEntry, asynchronous, false);
    }

    @Override
    public void restore(RepositoryBackupChainLog log, RepositoryEntry repositoryEntry, boolean asynchronous, boolean removeJobOnceOver) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException {
        if (repositoryEntry == null) {
            if (log.getOriginalRepositoryEntry() == null) {
                throw new RepositoryRestoreExeption("The backup log is not contains original repository log : " + log.getLogFilePath());
            }
            this.restore(log, log.getOriginalRepositoryEntry(), asynchronous);
            return;
        }
        this.restoreRepository(log, repositoryEntry, null, asynchronous, removeJobOnceOver);
    }

    @Override
    public void restore(RepositoryBackupChainLog rblog, RepositoryEntry repositoryEntry, Map<String, String> workspaceNamesCorrespondMap, boolean asynchronous) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException {
        this.restoreRepository(rblog, repositoryEntry, workspaceNamesCorrespondMap, asynchronous, false);
    }

    private void restoreRepository(RepositoryBackupChainLog rblog, RepositoryEntry repositoryEntry, Map<String, String> workspaceNamesCorrespondMap, boolean asynchronous, boolean removeJobOnceOver) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException {
        try {
            this.repoService.getRepository(repositoryEntry.getName());
            throw new BackupConfigurationException("Repository \"" + repositoryEntry.getName() + "\" is already exists.");
        }
        catch (RepositoryException e) {
            HashedMap workspacesMapping = new HashedMap();
            HashedMap backups = new HashedMap();
            if (workspaceNamesCorrespondMap == null) {
                for (String path : rblog.getWorkspaceBackupsInfo()) {
                    BackupChainLog bLog = new BackupChainLog(new File(path));
                    backups.put(bLog.getBackupConfig().getWorkspace(), bLog);
                }
                if (!rblog.getSystemWorkspace().equals(repositoryEntry.getSystemWorkspaceName())) {
                    throw new BackupConfigurationException("The backup to system workspace is not system workspace in repository entry: " + rblog.getSystemWorkspace() + " is not equal " + repositoryEntry.getSystemWorkspaceName());
                }
                if (backups.size() != repositoryEntry.getWorkspaceEntries().size()) {
                    throw new BackupConfigurationException("The repository entry is contains more or less workspace entry than backups of workspace in " + rblog.getLogFilePath());
                }
                for (WorkspaceEntry wsEntry : repositoryEntry.getWorkspaceEntries()) {
                    if (!backups.containsKey(wsEntry.getName())) {
                        throw new BackupConfigurationException("The workspace '" + wsEntry.getName() + "' is not found in backup " + rblog.getLogFilePath());
                    }
                    workspacesMapping.put(wsEntry.getName(), backups.get(wsEntry.getName()));
                }
            } else {
                for (String path : rblog.getWorkspaceBackupsInfo()) {
                    BackupChainLog bLog = new BackupChainLog(new File(path));
                    if (!workspaceNamesCorrespondMap.containsKey(bLog.getBackupConfig().getWorkspace())) {
                        throw new BackupConfigurationException("Can not found coresptonding workspace name to workspace '" + bLog.getBackupConfig().getWorkspace() + "' in  " + workspaceNamesCorrespondMap.keySet());
                    }
                    backups.put(workspaceNamesCorrespondMap.get(bLog.getBackupConfig().getWorkspace()), bLog);
                }
                if (!repositoryEntry.getSystemWorkspaceName().equals(workspaceNamesCorrespondMap.get(rblog.getSystemWorkspace()))) {
                    throw new BackupConfigurationException("The backup to system workspace is not system workspace in repository entry: " + repositoryEntry.getSystemWorkspaceName() + " is not equal " + workspaceNamesCorrespondMap.get(rblog.getSystemWorkspace()));
                }
                if (workspaceNamesCorrespondMap.size() != repositoryEntry.getWorkspaceEntries().size()) {
                    throw new BackupConfigurationException("The repository entry is contains more or less workspace entry than backups of workspace in " + rblog.getLogFilePath());
                }
                for (WorkspaceEntry wsEntry : repositoryEntry.getWorkspaceEntries()) {
                    if (!workspaceNamesCorrespondMap.containsValue(wsEntry.getName())) {
                        throw new BackupConfigurationException("The workspace '" + wsEntry.getName() + "' is not found workspaceNamesCorrespondMap  : " + workspaceNamesCorrespondMap.values());
                    }
                    if (!backups.containsKey(wsEntry.getName())) {
                        throw new BackupConfigurationException("The workspace '" + wsEntry.getName() + "' is not found in backup " + rblog.getLogFilePath());
                    }
                    workspacesMapping.put(wsEntry.getName(), backups.get(wsEntry.getName()));
                }
            }
            JobRepositoryRestore jobRepositoryRestore = new JobRepositoryRestore(this.repoService, this, repositoryEntry, (Map<String, BackupChainLog>)workspacesMapping, rblog, removeJobOnceOver);
            this.restoreRepositoryJobs.add(jobRepositoryRestore);
            if (asynchronous) {
                jobRepositoryRestore.start();
            } else {
                jobRepositoryRestore.restore();
            }
            return;
        }
    }

    @Override
    public RepositoryBackupChain startBackup(RepositoryBackupConfig config) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException {
        this.validateBackupConfig(config);
        File dir = new File(config.getBackupDir() + File.separator + "repository_" + config.getRepository() + "_backup_" + System.currentTimeMillis());
        PrivilegedFileHelper.mkdirs((File)dir);
        config.setBackupDir(dir);
        RepositoryBackupChainImpl repositoryBackupChain = new RepositoryBackupChainImpl(config, this.logsDirectory, this.repoService, this.fullBackupType, this.incrementalBackupType, IdGenerator.generate());
        repositoryBackupChain.startBackup();
        this.currentRepositoryBackups.add(repositoryBackupChain);
        return repositoryBackupChain;
    }

    @Override
    public void stopBackup(RepositoryBackupChain backup) {
        backup.stopBackup();
        this.currentRepositoryBackups.remove(backup);
    }

    @Override
    public RepositoryBackupChain findRepositoryBackup(String repository) {
        for (RepositoryBackupChain chain : this.currentRepositoryBackups) {
            if (!repository.equals(chain.getBackupConfig().getRepository())) continue;
            return chain;
        }
        return null;
    }

    @Override
    public Set<RepositoryBackupChain> getCurrentRepositoryBackups() {
        return this.currentRepositoryBackups;
    }

    @Override
    public RepositoryBackupChain findRepositoryBackupId(String backupId) {
        for (RepositoryBackupChain chain : this.currentRepositoryBackups) {
            if (!backupId.equals(chain.getBackupId())) continue;
            return chain;
        }
        return null;
    }

    @Override
    public void restoreExistingRepository(RepositoryBackupChainLog rblog, RepositoryEntry repositoryEntry, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        try {
            this.repoService.getRepository(repositoryEntry.getName());
        }
        catch (RepositoryException e) {
            throw new RepositoryRestoreExeption("Repository \"" + repositoryEntry.getName() + "\" should be existed", e);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryRestoreExeption("Repository \"" + repositoryEntry.getName() + "\" should be existed", e);
        }
        HashedMap workspacesMapping = new HashedMap();
        HashedMap backups = new HashedMap();
        for (String path : rblog.getWorkspaceBackupsInfo()) {
            BackupChainLog bLog = new BackupChainLog(new File(path));
            backups.put(bLog.getBackupConfig().getWorkspace(), bLog);
        }
        if (!rblog.getSystemWorkspace().equals(repositoryEntry.getSystemWorkspaceName())) {
            throw new BackupConfigurationException("The backup to system workspace is not system workspace in repository entry: " + rblog.getSystemWorkspace() + " is not equal " + repositoryEntry.getSystemWorkspaceName());
        }
        if (backups.size() != repositoryEntry.getWorkspaceEntries().size()) {
            throw new BackupConfigurationException("The repository entry is contains more or less workspace entry than backups of workspace in " + rblog.getLogFilePath());
        }
        for (WorkspaceEntry wsEntry : repositoryEntry.getWorkspaceEntries()) {
            if (!backups.containsKey(wsEntry.getName())) {
                throw new BackupConfigurationException("The workspace '" + wsEntry.getName() + "' is not found in backup " + rblog.getLogFilePath());
            }
            workspacesMapping.put(wsEntry.getName(), backups.get(wsEntry.getName()));
        }
        boolean isSameConfigRestore = false;
        try {
            if (Class.forName(((BackupChainLog)workspacesMapping.get(((WorkspaceEntry)repositoryEntry.getWorkspaceEntries().get(0)).getName())).getFullBackupType()).equals(org.exoplatform.services.jcr.ext.backup.impl.rdbms.FullBackupJob.class)) {
                String newConf = new JsonGeneratorImpl().createJsonObject((Object)repositoryEntry).toString();
                String currnetConf = new JsonGeneratorImpl().createJsonObject((Object)this.repoService.getRepository(repositoryEntry.getName()).getConfiguration()).toString();
                isSameConfigRestore = newConf.equals(currnetConf);
            }
        }
        catch (JsonException e) {
            log.error((Object)"Can't get JSON object from wokrspace configuration", (Throwable)e);
        }
        catch (RepositoryException e) {
            log.error((Object)e);
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e);
        }
        JobRepositoryRestore jobExistedRepositoryRestore = isSameConfigRestore ? new JobExistingRepositorySameConfigRestore(this.repoService, this, repositoryEntry, (Map<String, BackupChainLog>)workspacesMapping, rblog) : new JobExistingRepositoryRestore(this.repoService, this, repositoryEntry, (Map<String, BackupChainLog>)workspacesMapping, rblog);
        this.restoreRepositoryJobs.add(jobExistedRepositoryRestore);
        if (asynchronous) {
            jobExistedRepositoryRestore.start();
        } else {
            jobExistedRepositoryRestore.restore();
        }
    }

    @Override
    public void restoreExistingRepository(String repositoryBackupIdentifier, RepositoryEntry repositoryEntry, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        RepositoryBackupChainLog backupChainLog = null;
        for (RepositoryBackupChainLog chainLog : this.getRepositoryBackupsLogs()) {
            if (!chainLog.getBackupId().equals(repositoryBackupIdentifier)) continue;
            backupChainLog = chainLog;
            break;
        }
        if (backupChainLog == null) {
            throw new BackupConfigurationException("Can not found backup of repository with id \"" + repositoryBackupIdentifier + "\"");
        }
        this.restoreExistingRepository(backupChainLog, repositoryEntry, asynchronous);
    }

    @Override
    public void restoreExistingWorkspace(BackupChainLog log, String repositoryName, WorkspaceEntry workspaceEntry, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        try {
            this.repoService.getRepository(repositoryName);
            if (!this.workspaceAlreadyExist(repositoryName, workspaceEntry.getName())) {
                throw new WorkspaceRestoreException("Workspace \"" + workspaceEntry.getName() + "\" should be existed in repository \"" + repositoryName + "\".");
            }
        }
        catch (RepositoryException e) {
            throw new WorkspaceRestoreException("Repository \"" + repositoryName + "\" should be existed", e);
        }
        catch (RepositoryConfigurationException e) {
            throw new WorkspaceRestoreException("Repository \"" + repositoryName + "\" should be existed", e);
        }
        boolean isSameConfigRestore = false;
        try {
            if (Class.forName(log.getFullBackupType()).equals(org.exoplatform.services.jcr.ext.backup.impl.rdbms.FullBackupJob.class)) {
                WorkspaceEntry currentWsEntry = null;
                for (WorkspaceEntry wsEntry : this.repoService.getRepository(repositoryName).getConfiguration().getWorkspaceEntries()) {
                    if (!wsEntry.getName().equals(workspaceEntry.getName())) continue;
                    currentWsEntry = wsEntry;
                    break;
                }
                String newConf = new JsonGeneratorImpl().createJsonObject((Object)workspaceEntry).toString();
                String currnetConf = new JsonGeneratorImpl().createJsonObject((Object)currentWsEntry).toString();
                isSameConfigRestore = newConf.equals(currnetConf);
            }
        }
        catch (JsonException e) {
            BackupManagerImpl.log.error((Object)"Can't get JSON object from wokrspace configuration", (Throwable)e);
        }
        catch (RepositoryException e) {
            BackupManagerImpl.log.error((Object)e);
        }
        catch (RepositoryConfigurationException e) {
            BackupManagerImpl.log.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            BackupManagerImpl.log.error((Object)e);
        }
        JobWorkspaceRestore jobRestore = isSameConfigRestore ? new JobExistingWorkspaceSameConfigRestore(this.repoService, this, repositoryName, log, workspaceEntry) : new JobExistingWorkspaceRestore(this.repoService, this, repositoryName, log, workspaceEntry);
        this.restoreJobs.add(jobRestore);
        if (asynchronous) {
            jobRestore.start();
        } else {
            try {
                jobRestore.restore();
            }
            catch (Throwable e) {
                throw new BackupOperationException(e);
            }
        }
    }

    @Override
    public void restoreExistingWorkspace(String workspaceBackupIdentifier, String repositoryName, WorkspaceEntry workspaceEntry, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        BackupChainLog backupChainLog = null;
        for (BackupChainLog chainLog : this.getBackupsLogs()) {
            if (!chainLog.getBackupId().equals(workspaceBackupIdentifier)) continue;
            backupChainLog = chainLog;
            break;
        }
        if (backupChainLog == null) {
            throw new BackupConfigurationException("Can not found backup of workspace with id \"" + workspaceBackupIdentifier + "\"");
        }
        this.restoreExistingWorkspace(backupChainLog, repositoryName, workspaceEntry, asynchronous);
    }

    @Override
    public void restoreExistingRepository(String repositoryBackupIdentifier, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        RepositoryBackupChainLog backupChainLog = null;
        for (RepositoryBackupChainLog chainLog : this.getRepositoryBackupsLogs()) {
            if (!chainLog.getBackupId().equals(repositoryBackupIdentifier)) continue;
            backupChainLog = chainLog;
            break;
        }
        if (backupChainLog == null) {
            throw new BackupConfigurationException("Can not found backup of repository with id \"" + repositoryBackupIdentifier + "\"");
        }
        this.restoreExistingRepository(backupChainLog, backupChainLog.getOriginalRepositoryEntry(), asynchronous);
    }

    @Override
    public void restoreExistingWorkspace(String workspaceBackupIdentifier, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        BackupChainLog backupChainLog = null;
        for (BackupChainLog chainLog : this.getBackupsLogs()) {
            if (!chainLog.getBackupId().equals(workspaceBackupIdentifier)) continue;
            backupChainLog = chainLog;
            break;
        }
        if (backupChainLog == null) {
            throw new BackupConfigurationException("Can not found backup of workspace with id \"" + workspaceBackupIdentifier + "\"");
        }
        this.restoreExistingWorkspace(backupChainLog, backupChainLog.getBackupConfig().getRepository(), backupChainLog.getOriginalWorkspaceEntry(), asynchronous);
    }

    @Override
    public void restoreRepository(String repositoryBackupIdentifier, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        RepositoryBackupChainLog backupChainLog = null;
        for (RepositoryBackupChainLog chainLog : this.getRepositoryBackupsLogs()) {
            if (!chainLog.getBackupId().equals(repositoryBackupIdentifier)) continue;
            backupChainLog = chainLog;
            break;
        }
        if (backupChainLog == null) {
            throw new BackupConfigurationException("Can not found backup of repository with id \"" + repositoryBackupIdentifier + "\"");
        }
        try {
            this.restore(backupChainLog, backupChainLog.getOriginalRepositoryEntry(), asynchronous);
        }
        catch (RepositoryException e) {
            throw new RepositoryRestoreExeption("Repository \"" + backupChainLog.getOriginalRepositoryEntry().getName() + "\" was not restored", e);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryRestoreExeption("Repository \"" + backupChainLog.getOriginalRepositoryEntry().getName() + "\" was not restored", e);
        }
    }

    @Override
    public void restoreWorkspace(String workspaceBackupIdentifier, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        BackupChainLog backupChainLog = null;
        for (BackupChainLog chainLog : this.getBackupsLogs()) {
            if (!chainLog.getBackupId().equals(workspaceBackupIdentifier)) continue;
            backupChainLog = chainLog;
            break;
        }
        if (backupChainLog == null) {
            throw new BackupConfigurationException("Can not found backup of workspace with id \"" + workspaceBackupIdentifier + "\"");
        }
        try {
            this.restore(backupChainLog, backupChainLog.getBackupConfig().getRepository(), backupChainLog.getOriginalWorkspaceEntry(), asynchronous);
        }
        catch (RepositoryException e) {
            throw new WorkspaceRestoreException("Workapce \"" + backupChainLog.getOriginalWorkspaceEntry().getName() + "\" was not restored in repository \"" + backupChainLog.getBackupConfig().getRepository() + "\"", e);
        }
        catch (RepositoryConfigurationException e) {
            throw new WorkspaceRestoreException("Workapce \"" + backupChainLog.getOriginalWorkspaceEntry().getName() + "\" was not restored in repository \"" + backupChainLog.getBackupConfig().getRepository() + "\"", e);
        }
    }

    @Override
    public void restoreExistingRepository(File repositoryBackupSetDir, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        File[] cfs = PrivilegedFileHelper.listFiles((File)repositoryBackupSetDir, (FileFilter)new RepositoryBackupLogsFilter());
        if (cfs.length == 0) {
            throw new BackupConfigurationException("Can not found repository backup log in directory : " + repositoryBackupSetDir.getPath());
        }
        if (cfs.length > 1) {
            throw new BackupConfigurationException("Backup set directory should contains only one repository backup log : " + repositoryBackupSetDir.getPath());
        }
        RepositoryBackupChainLog backupChainLog = new RepositoryBackupChainLog(cfs[0]);
        this.restoreExistingRepository(backupChainLog, backupChainLog.getOriginalRepositoryEntry(), asynchronous);
    }

    @Override
    public void restoreExistingWorkspace(File workspaceBackupSetDir, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        File[] cfs = PrivilegedFileHelper.listFiles((File)workspaceBackupSetDir, (FileFilter)new BackupLogsFilter());
        if (cfs.length == 0) {
            throw new BackupConfigurationException("Can not found workspace backup log in directory : " + workspaceBackupSetDir.getPath());
        }
        if (cfs.length > 1) {
            throw new BackupConfigurationException("Backup set directory should contains only one workspace backup log : " + workspaceBackupSetDir.getPath());
        }
        BackupChainLog backupChainLog = new BackupChainLog(cfs[0]);
        this.restoreExistingWorkspace(backupChainLog, backupChainLog.getBackupConfig().getRepository(), backupChainLog.getOriginalWorkspaceEntry(), asynchronous);
    }

    @Override
    public void restoreRepository(File repositoryBackupSetDir, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        File[] cfs = PrivilegedFileHelper.listFiles((File)repositoryBackupSetDir, (FileFilter)new RepositoryBackupLogsFilter());
        if (cfs.length == 0) {
            throw new BackupConfigurationException("Can not found repository backup log in directory : " + repositoryBackupSetDir.getPath());
        }
        if (cfs.length > 1) {
            throw new BackupConfigurationException("Backup set directory should contains only one repository backup log : " + repositoryBackupSetDir.getPath());
        }
        RepositoryBackupChainLog backupChainLog = new RepositoryBackupChainLog(cfs[0]);
        try {
            this.restore(backupChainLog, backupChainLog.getOriginalRepositoryEntry(), asynchronous);
        }
        catch (RepositoryException e) {
            throw new RepositoryRestoreExeption("Repository \"" + backupChainLog.getOriginalRepositoryEntry().getName() + "\" was not restored", e);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryRestoreExeption("Repository \"" + backupChainLog.getOriginalRepositoryEntry().getName() + "\" was not restored", e);
        }
    }

    @Override
    public void restoreWorkspace(File workspaceBackupSetDir, boolean asynchronous) throws BackupOperationException, BackupConfigurationException {
        File[] cfs = PrivilegedFileHelper.listFiles((File)workspaceBackupSetDir, (FileFilter)new BackupLogsFilter());
        if (cfs.length == 0) {
            throw new BackupConfigurationException("Can not found workspace backup log in directory : " + workspaceBackupSetDir.getPath());
        }
        if (cfs.length > 1) {
            throw new BackupConfigurationException("Backup set directory should contains only one workspace backup log : " + workspaceBackupSetDir.getPath());
        }
        BackupChainLog backupChainLog = new BackupChainLog(cfs[0]);
        try {
            this.restore(backupChainLog, backupChainLog.getBackupConfig().getRepository(), backupChainLog.getOriginalWorkspaceEntry(), asynchronous);
        }
        catch (RepositoryException e) {
            throw new WorkspaceRestoreException("Workapce \"" + backupChainLog.getOriginalWorkspaceEntry().getName() + "\" was not restored in repository \"" + backupChainLog.getBackupConfig().getRepository() + "\"", e);
        }
        catch (RepositoryConfigurationException e) {
            throw new WorkspaceRestoreException("Workapce \"" + backupChainLog.getOriginalWorkspaceEntry().getName() + "\" was not restored in repository \"" + backupChainLog.getBackupConfig().getRepository() + "\"", e);
        }
    }

    class RepositoryBackupAutoStopper
    extends Thread {
        boolean isToBeStopped;

        RepositoryBackupAutoStopper(ExoContainerContext ctx) {
            super("RepositoryBackupAutoStopper" + (ctx == null ? "" : " " + ctx.getName()));
            this.isToBeStopped = false;
        }

        public void run() {
            while (!this.isToBeStopped) {
                try {
                    Thread.sleep(5000L);
                    Iterator it = BackupManagerImpl.this.currentRepositoryBackups.iterator();
                    ArrayList<RepositoryBackupChain> stopedList = new ArrayList<RepositoryBackupChain>();
                    while (it.hasNext()) {
                        RepositoryBackupChain chain = (RepositoryBackupChain)it.next();
                        if (!chain.isFinished()) continue;
                        stopedList.add(chain);
                    }
                    for (RepositoryBackupChain chain : stopedList) {
                        BackupManagerImpl.this.stopBackup(chain);
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)"The interapted this thread.", (Throwable)e);
                }
                catch (Throwable e) {
                    log.error((Object)"The unknown error", e);
                }
            }
        }

        public void close() {
            this.isToBeStopped = true;
        }
    }

    class WorkspaceBackupAutoStopper
    extends Thread {
        private boolean isToBeStopped;

        WorkspaceBackupAutoStopper(ExoContainerContext ctx) {
            super("WorkspaceBackupAutoStopper" + (ctx == null ? "" : " " + ctx.getName()));
            this.isToBeStopped = false;
        }

        public void run() {
            while (!this.isToBeStopped) {
                try {
                    Thread.sleep(5000L);
                    Iterator it = BackupManagerImpl.this.currentBackups.iterator();
                    ArrayList<BackupChain> stopedList = new ArrayList<BackupChain>();
                    while (it.hasNext()) {
                        BackupChain chain = (BackupChain)it.next();
                        boolean isFinished = chain.getBackupJobs().get(0).getState() == 4;
                        for (int i = 1; i < chain.getBackupJobs().size(); ++i) {
                            isFinished &= chain.getBackupJobs().get(i).getState() == 4;
                        }
                        if (!isFinished) continue;
                        stopedList.add(chain);
                    }
                    for (BackupChain chain : stopedList) {
                        BackupManagerImpl.this.stopBackup(chain);
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)"The interapted this thread.", (Throwable)e);
                }
                catch (Throwable e) {
                    log.error((Object)"The unknown error", e);
                }
            }
        }

        public void close() {
            this.isToBeStopped = true;
        }
    }

    class TaskFilter
    implements FileFilter {
        TaskFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".task");
        }
    }

    class MessagesListener
    implements BackupJobListener {
        MessagesListener() {
        }

        public void onError(BackupJob job, String message, Throwable error) {
            BackupManagerImpl.this.messages.addError(this.makeJobInfo(job, error) + message, error);
            log.error((Object)(this.makeJobInfo(job, error) + message), error);
        }

        public void onStateChanged(BackupJob job) {
            BackupManagerImpl.this.messages.addMessage(this.makeJobInfo(job, null));
            if (log.isDebugEnabled()) {
                log.debug((Object)this.makeJobInfo(job, null));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String makeJobInfo(BackupJob job, Throwable error) {
            StringBuilder jobInfo = new StringBuilder();
            if (job != null) {
                switch (job.getType()) {
                    case 1: {
                        jobInfo.append("FULL BACKUP");
                        break;
                    }
                    case 2: {
                        jobInfo.append("INCREMENTAL BACKUP");
                    }
                }
                jobInfo.append(" [");
                switch (job.getState()) {
                    case 4: {
                        jobInfo.append("FINISHED");
                        break;
                    }
                    case 0: {
                        jobInfo.append("STARTING");
                        break;
                    }
                    case 1: {
                        jobInfo.append("WAITING");
                        break;
                    }
                    case 2: {
                        jobInfo.append("WORKING");
                    }
                }
                jobInfo.append("]");
                if (error != null) {
                    jobInfo.append(" Error: ").append(error.getMessage());
                }
                try {
                    jobInfo.append(" log: ").append(job.getStorageURL().getPath());
                }
                catch (BackupOperationException e) {
                }
                finally {
                    jobInfo.append(" ");
                }
            }
            return jobInfo.toString();
        }

        public String printStackTrace(Throwable error) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(out);
            error.printStackTrace(writer);
            return new String(out.toByteArray());
        }
    }
}

