/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChainLog;
import org.exoplatform.services.jcr.ext.backup.RepositoryRestoreExeption;
import org.exoplatform.services.jcr.ext.backup.impl.BackupManagerImpl;
import org.exoplatform.services.jcr.ext.backup.impl.JobRepositoryRestore;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.JCRRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanService;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleaner;
import org.exoplatform.services.jcr.impl.clean.rdbms.DummyDBCleaner;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExistingRepositorySameConfigRestore
extends JobRepositoryRestore {
    public JobExistingRepositorySameConfigRestore(RepositoryService repoService, BackupManagerImpl backupManagerImpl, RepositoryEntry repositoryEntry, Map<String, BackupChainLog> workspacesMapping, RepositoryBackupChainLog backupChainLog) {
        this(repoService, backupManagerImpl, repositoryEntry, workspacesMapping, backupChainLog, false);
    }

    public JobExistingRepositorySameConfigRestore(RepositoryService repoService, BackupManagerImpl backupManagerImpl, RepositoryEntry repositoryEntry, Map<String, BackupChainLog> workspacesMapping, RepositoryBackupChainLog backupChainLog, boolean removeJobOnceOver) {
        super(repoService, backupManagerImpl, repositoryEntry, workspacesMapping, backupChainLog, removeJobOnceOver);
    }

    @Override
    protected void restoreRepository() throws RepositoryRestoreExeption {
        ArrayList<DataRestore> dataRestorer = new ArrayList<DataRestore>();
        ArrayList<WorkspaceContainerFacade> workspacesWaits4Resume = new ArrayList<WorkspaceContainerFacade>();
        try {
            WorkspaceEntry wsEntry = (WorkspaceEntry)this.repositoryEntry.getWorkspaceEntries().get(0);
            Connection jdbcConn = null;
            DBCleaner dbCleaner = null;
            Boolean isMultiDb = Boolean.parseBoolean(wsEntry.getContainer().getParameterValue("multi-db"));
            if (!isMultiDb.booleanValue()) {
                String dsName = wsEntry.getContainer().getParameterValue("source-name");
                final DataSource ds = (DataSource)new InitialContext().lookup(dsName);
                if (ds == null) {
                    throw new NameNotFoundException("Data source " + dsName + " not found");
                }
                jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws Exception {
                        return ds.getConnection();
                    }
                });
                jdbcConn.setAutoCommit(false);
                dbCleaner = DBCleanService.getRepositoryDBCleaner((Connection)jdbcConn, (RepositoryEntry)this.repositoryEntry);
            }
            ManageableRepository repository = this.repositoryService.getRepository(this.repositoryEntry.getName());
            for (String wsName : repository.getWorkspaceNames()) {
                WorkspaceContainerFacade wsContainer = repository.getWorkspaceContainer(wsName);
                wsContainer.setState(3);
                workspacesWaits4Resume.add(wsContainer);
            }
            boolean isSharedDbCleaner = false;
            for (WorkspaceEntry wEntry : this.repositoryEntry.getWorkspaceEntries()) {
                DataRestoreContext context;
                List backupable = this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponentInstancesOfType(Backupable.class);
                File fullBackupDir = JCRRestore.getFullBackupFile((File)((BackupChainLog)this.workspacesMapping.get(wEntry.getName())).getBackupConfig().getBackupDir());
                if (jdbcConn != null) {
                    if (dbCleaner != null) {
                        if (isSharedDbCleaner) {
                            context = new DataRestoreContext(new String[]{"storage-dir", "db-connection", "db-cleaner"}, new Object[]{fullBackupDir, jdbcConn, new DummyDBCleaner()});
                        } else {
                            context = new DataRestoreContext(new String[]{"storage-dir", "db-connection", "db-cleaner"}, new Object[]{fullBackupDir, jdbcConn, dbCleaner});
                            isSharedDbCleaner = true;
                        }
                    } else {
                        context = new DataRestoreContext(new String[]{"storage-dir", "db-connection"}, new Object[]{fullBackupDir, jdbcConn});
                    }
                } else {
                    context = new DataRestoreContext(new String[]{"storage-dir"}, new Object[]{fullBackupDir});
                }
                for (Backupable component : backupable) {
                    dataRestorer.add(component.getDataRestorer(context));
                }
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.clean();
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.restore();
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.commit();
            }
            for (WorkspaceContainerFacade wsContainer : workspacesWaits4Resume) {
                wsContainer.setState(1);
            }
            for (WorkspaceEntry wEntry : this.repositoryEntry.getWorkspaceEntries()) {
                this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponentInstancesOfType(Backupable.class);
                WorkspacePersistentDataManager dataManager = (WorkspacePersistentDataManager)this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponent(WorkspacePersistentDataManager.class);
                FileCleanerHolder fileCleanHolder = (FileCleanerHolder)this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponent(FileCleanerHolder.class);
                File storageDir = JCRRestore.getFullBackupFile((File)((BackupChainLog)this.workspacesMapping.get(wEntry.getName())).getBackupConfig().getBackupDir());
                JCRRestore restorer = new JCRRestore((DataManager)dataManager, fileCleanHolder.getFileCleaner());
                for (File incrBackupFile : JCRRestore.getIncrementalFiles((File)storageDir)) {
                    restorer.incrementalRestore(incrBackupFile);
                }
            }
        }
        catch (Throwable t) {
            for (DataRestore restorer : dataRestorer) {
                try {
                    restorer.rollback();
                }
                catch (BackupException e) {
                    log.error((Object)"Can't rollback changes", (Throwable)e);
                }
            }
            throw new RepositoryRestoreExeption("Repository " + this.repositoryEntry.getName() + " was not restored", t);
        }
        finally {
            for (DataRestore restorer : dataRestorer) {
                try {
                    restorer.close();
                }
                catch (BackupException e) {
                    log.error((Object)"Can't close restorer", (Throwable)e);
                }
            }
            try {
                for (WorkspaceContainerFacade wsContainer : workspacesWaits4Resume) {
                    wsContainer.setState(1);
                }
            }
            catch (RepositoryException e) {
                log.error((Object)"Can't resume repository", (Throwable)e);
            }
        }
    }
}

