/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl.rdbms;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.core.BackupWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RdbmsWorkspaceInitializer
extends BackupWorkspaceInitializer {
    protected static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.RdbmsWorkspaceInitializer");
    protected final RepositoryService repositoryService;
    private volatile boolean isRestoreInProgress = false;

    public RdbmsWorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceRegistryImpl namespaceRegistry, LocationFactory locationFactory, NodeTypeManagerImpl nodeTypeManager, ValueFactoryImpl valueFactory, AccessManager accessManager, RepositoryService repositoryService, FileCleanerHolder cleanerHolder) throws RepositoryConfigurationException, PathNotFoundException, RepositoryException {
        super(config, repConfig, dataManager, namespaceRegistry, locationFactory, nodeTypeManager, valueFactory, accessManager, cleanerHolder);
        this.repositoryService = repositoryService;
    }

    public boolean isWorkspaceInitialized() {
        return this.isRestoreInProgress ? false : super.isWorkspaceInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeData initWorkspace() throws RepositoryException {
        if (this.isWorkspaceInitialized()) {
            return (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        }
        long start = System.currentTimeMillis();
        this.isRestoreInProgress = true;
        try {
            this.restoreAction();
        }
        finally {
            this.isRestoreInProgress = false;
        }
        NodeData root = (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        log.info((Object)("Workspace [" + this.workspaceName + "] restored from storage " + this.restorePath + " in " + (double)(System.currentTimeMillis() - start) * 1.0 / 1000.0 + "sec"));
        return root;
    }

    protected void restoreAction() throws RepositoryException {
        this.fullRdbmsRestore();
    }

    /*
     * Loose catch block
     */
    protected void fullRdbmsRestore() throws RepositoryException {
        block27: {
            ArrayList<DataRestore> dataRestorers = new ArrayList<DataRestore>();
            ManageableRepository repository = null;
            try {
                repository = this.repositoryService.getRepository(this.repositoryEntry.getName());
            }
            catch (RepositoryConfigurationException e) {
                throw new RepositoryException((Throwable)e);
            }
            List backupableComponents = repository.getWorkspaceContainer(this.workspaceName).getComponentInstancesOfType(Backupable.class);
            ArrayList<WorkspaceContainerFacade> workspacesWaits4Resume = new ArrayList<WorkspaceContainerFacade>();
            Throwable throwable = null;
            if (!this.workspaceEntry.getContainer().getParameterBoolean("multi-db").booleanValue()) {
                for (WorkspaceEntry we : this.repositoryEntry.getWorkspaceEntries()) {
                    if (we.getName().equals(this.workspaceEntry.getName())) continue;
                    WorkspaceContainerFacade wsContainer = repository.getWorkspaceContainer(we.getName());
                    wsContainer.setState(3);
                    workspacesWaits4Resume.add(wsContainer);
                }
            }
            DataRestoreContext context = new DataRestoreContext(new String[]{"storage-dir"}, new Object[]{new File(this.restorePath)});
            for (Backupable component : backupableComponents) {
                dataRestorers.add(component.getDataRestorer(context));
            }
            for (DataRestore restorer : dataRestorers) {
                restorer.clean();
            }
            for (DataRestore restorer : dataRestorers) {
                restorer.restore();
            }
            for (DataRestore restorer : dataRestorers) {
                restorer.commit();
            }
            Object var11_13 = null;
            for (DataRestore restorer : dataRestorers) {
                try {
                    restorer.close();
                }
                catch (BackupException e) {
                    log.error((Object)"Can't close restorer", (Throwable)e);
                }
            }
            try {
                for (WorkspaceContainerFacade wsContainer : workspacesWaits4Resume) {
                    wsContainer.setState(1);
                }
            }
            catch (RepositoryException e) {
                if (throwable == null) {
                    log.error((Object)("Con not set ONLYNE state for repository " + repository.getConfiguration().getName()), (Throwable)e);
                    break block27;
                }
                throw new RepositoryException("Con not set ONLYNE state for repository " + repository.getConfiguration().getName(), (Throwable)e);
            }
            break block27;
            {
                catch (Throwable e) {
                    throwable = e;
                    for (DataRestore restorer : dataRestorers) {
                        try {
                            restorer.rollback();
                        }
                        catch (BackupException e1) {
                            log.error((Object)"Can't rollback restorer", e);
                        }
                    }
                    throw new RepositoryException(e);
                }
            }
            catch (Throwable throwable2) {
                block28: {
                    Object var11_14 = null;
                    for (DataRestore restorer : dataRestorers) {
                        try {
                            restorer.close();
                        }
                        catch (BackupException e) {
                            log.error((Object)"Can't close restorer", (Throwable)e);
                        }
                    }
                    try {
                        for (WorkspaceContainerFacade wsContainer : workspacesWaits4Resume) {
                            wsContainer.setState(1);
                        }
                    }
                    catch (RepositoryException e) {
                        if (throwable == null) {
                            log.error((Object)("Con not set ONLYNE state for repository " + repository.getConfiguration().getName()), (Throwable)e);
                            break block28;
                        }
                        throw new RepositoryException("Con not set ONLYNE state for repository " + repository.getConfiguration().getName(), (Throwable)e);
                    }
                }
                throw throwable2;
            }
        }
    }
}

