/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.io.IOException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.config.ContainerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;

public class ValueStorageCleanHelper {
    public void removeWorkspaceValueStorage(WorkspaceEntry wEntry) throws RepositoryConfigurationException, IOException {
        ContainerEntry containerEntry = wEntry.getContainer();
        if (containerEntry.getValueStorages() != null) {
            for (ValueStorageEntry valueStorageEntry : containerEntry.getValueStorages()) {
                String valueStorageDirName = valueStorageEntry.getParameterValue("path");
                File valueStorageDir = new File(valueStorageDirName);
                if (!PrivilegedFileHelper.exists((File)valueStorageDir)) continue;
                this.removeFolder(valueStorageDir);
            }
        }
    }

    private void removeFolder(File dir) throws IOException {
        if (PrivilegedFileHelper.isDirectory((File)dir)) {
            for (File subFile : PrivilegedFileHelper.listFiles((File)dir)) {
                this.removeFolder(subFile);
            }
            if (!PrivilegedFileHelper.delete((File)dir)) {
                throw new IOException("Value storage folder was not deleted : " + PrivilegedFileHelper.getCanonicalPath((File)dir));
            }
        } else if (!PrivilegedFileHelper.delete((File)dir)) {
            throw new IOException("Value storage file was not deleted : " + PrivilegedFileHelper.getCanonicalPath((File)dir));
        }
    }
}

