/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileRemover
extends Thread {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.FileRemover");
    private static final double ONE_SECOND = 1000.0;
    private long period;
    private File recoveryDir;
    private FileCleaner fileCleaner;

    public FileRemover(long period, File recoveryDir, FileCleaner fileCleaner, String ownName) {
        super("FileRemover@" + ownName);
        this.period = period;
        this.recoveryDir = recoveryDir;
        this.fileCleaner = fileCleaner;
        log.info((Object)(this.getName() + " has been inited"));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) {
            try {
                block4: while (true) {
                    Thread.yield();
                    Thread.sleep(this.period);
                    recoveryDataDir = new File(PrivilegedFileHelper.getCanonicalPath((File)this.recoveryDir) + File.separator + "data");
                    fArray = PrivilegedFileHelper.listFiles((File)recoveryDataDir, (FileFilter)new RemoveFilesFilter());
                    if (fArray.length <= 0) continue;
                    needRemoveFilesName = this.getAllRemoveFileName(fArray);
                    map = this.getAllPendingBinaryFilePath();
                    for (String fPath : needRemoveFilesName) {
                        f = new File(fPath);
                        if (!PrivilegedFileHelper.exists((File)f) || map.containsKey(f.getName())) continue;
                        this.fileCleaner.addFile(f);
                        if (!FileRemover.log.isDebugEnabled()) continue;
                        FileRemover.log.debug((Object)("Remove file :" + PrivilegedFileHelper.getCanonicalPath((File)f)));
                    }
                    if (map.size() != 0) continue;
                    arr$ = fArray;
                    len$ = arr$.length;
                    i$ = 0;
                    while (true) {
                        if (i$ < len$) ** break;
                        continue block4;
                        ff = arr$[i$];
                        this.fileCleaner.addFile(ff);
                        if (FileRemover.log.isDebugEnabled()) {
                            FileRemover.log.debug((Object)("Remove file :" + PrivilegedFileHelper.getCanonicalPath((File)ff)));
                        }
                        ++i$;
                    }
                    break;
                }
            }
            catch (IOException e) {
                FileRemover.log.error((Object)"FileRemover error :", (Throwable)e);
                continue;
            }
            catch (InterruptedException e) {
                FileRemover.log.error((Object)"FileRemover error :", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private ArrayList<String> getAllRemoveFileName(File[] array) throws IOException {
        ArrayList<String> fileNameList = new ArrayList<String>();
        for (File file : array) {
            String sFileName;
            if (!file.isFile()) continue;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((sFileName = br.readLine()) != null) {
                fileNameList.add(sFileName);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Need remove file : " + sFileName));
            }
        }
        return fileNameList;
    }

    private HashMap<String, String> getAllPendingBinaryFilePath() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (File f : PrivilegedFileHelper.listFiles((File)this.recoveryDir)) {
            if (!f.isFile()) continue;
            for (String filePath : this.getFilePathList(f)) {
                map.put(new File(filePath).getName(), filePath);
            }
        }
        return map;
    }

    private List<String> getFilePathList(File f) throws IOException {
        String str;
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(f));
        while ((str = reader.readLine()) != null) {
            if (str.startsWith("---")) continue;
            list.add(str);
        }
        return list;
    }

    class RemoveFilesFilter
    implements FileFilter {
        RemoveFilesFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".remove");
        }
    }
}

