/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.File;
import java.util.HashMap;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemDataKeeper;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.ext.replication.ChangesFile;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.PendingBinaryFile;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryManager;
import org.exoplatform.services.jcr.ext.replication.transport.AbstractPacket;
import org.exoplatform.services.jcr.ext.replication.transport.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.transport.MemberAddress;
import org.exoplatform.services.jcr.ext.replication.transport.PacketListener;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractWorkspaceDataReceiver
implements PacketListener {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.AbstractWorkspaceDataReceiver");
    public static final int INIT_MODE = -1;
    public static final int NORMAL_MODE = 0;
    public static final int RECOVERY_MODE = 1;
    private static final int START_TIMEOUT = 1000;
    private int state = -1;
    private String systemId;
    private ChannelManager channelManager;
    private HashMap<String, PendingBinaryFile> mapPendingBinaryFile;
    protected ItemDataKeeper dataKeeper;
    private FileCleaner fileCleaner = new FileCleaner(30030L);
    private String ownName;
    private RecoveryManager recoveryManager;

    public AbstractWorkspaceDataReceiver() throws RepositoryConfigurationException {
        this.mapPendingBinaryFile = new HashMap();
    }

    public void init(ChannelManager channelManager, String systemId, String ownName, RecoveryManager recoveryManager) {
        this.systemId = systemId;
        this.channelManager = channelManager;
        this.channelManager.addPacketListener(this);
        this.ownName = ownName;
        this.recoveryManager = recoveryManager;
    }

    public void start() {
        try {
            Packet memberStartedPacket = new Packet(26, IdGenerator.generate(), this.ownName);
            this.channelManager.sendPacket(memberStartedPacket);
            Thread.sleep(1000L);
            Packet initedPacket = new Packet(21, IdGenerator.generate(), this.ownName);
            this.channelManager.sendPacket(initedPacket);
        }
        catch (Exception e) {
            log.error((Object)"Can't initialized AbstractWorkspaceDataReceiver", (Throwable)e);
        }
    }

    public void receive(ItemStateChangesLog itemStatechangesLog, String identifier) throws Exception {
        TransactionChangesLog changesLog = (TransactionChangesLog)itemStatechangesLog;
        if (changesLog.getSystemId() == null) {
            throw new Exception("Invalid or same systemId " + changesLog.getSystemId());
        }
        if (!changesLog.getSystemId().equals(this.systemId) && this.state != 1) {
            if (log.isDebugEnabled()) {
                ChangesLogIterator logIterator = changesLog.getLogIterator();
                while (logIterator.hasNextLog()) {
                    PlainChangesLog pcl = logIterator.nextLog();
                    log.info((Object)pcl.dump());
                }
            }
            this.dataKeeper.save((ItemStateChangesLog)changesLog);
            Packet packet = new Packet(13, identifier, this.ownName);
            this.channelManager.sendPacket(packet);
            if (log.isDebugEnabled()) {
                log.info((Object)("After save message: the owner systemId --> " + changesLog.getSystemId()));
                log.info((Object)("After save message: --> " + this.systemId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(AbstractPacket p, MemberAddress sourceAddress) {
        try {
            Packet packet = (Packet)p;
            Object bigPacket = null;
            switch (packet.getPacketType()) {
                case 32: {
                    ChangesFile chf;
                    PendingBinaryFile container = this.mapPendingBinaryFile.get(packet.getIdentifier());
                    if (container == null) {
                        container = new PendingBinaryFile();
                        this.mapPendingBinaryFile.put(packet.getIdentifier(), container);
                    }
                    PendingBinaryFile pendingBinaryFile = container;
                    synchronized (pendingBinaryFile) {
                        chf = container.getChangesFile(packet.getOwnerName(), packet.getFileName());
                        if (chf == null) {
                            chf = container.addChangesFile(packet.getOwnerName(), packet.getFileName(), packet.getSystemId(), packet.getTotalPacketCount());
                        }
                    }
                    chf.write(packet.getOffset(), packet.getByteArray());
                    if (!chf.isStored()) break;
                    this.saveChangesLog(chf, packet.getIdentifier());
                    if (!PrivilegedFileHelper.delete((File)chf.getFile())) {
                        this.fileCleaner.addFile(chf.getFile());
                    }
                    this.mapPendingBinaryFile.remove(packet.getIdentifier());
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Last packet of file has been received : " + packet.getFileName()));
                }
            }
            if (bigPacket != null) {
                this.state = this.recoveryManager.processing(bigPacket, this.state);
                bigPacket = null;
            } else {
                this.state = this.recoveryManager.processing(packet, this.state);
            }
        }
        catch (Exception e) {
            log.error((Object)"An error in processing packet : ", (Throwable)e);
        }
    }

    public void onError(MemberAddress sourceAddress) {
    }

    public ItemDataKeeper getDataKeeper() {
        return this.dataKeeper;
    }

    private void saveChangesLog(ChangesFile fileDescriptor, String identifire) throws Exception {
        TransactionChangesLog transactionChangesLog = this.recoveryManager.getRecoveryReader().getChangesLog(PrivilegedFileHelper.getAbsolutePath((File)fileDescriptor.getFile()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save to JCR : " + PrivilegedFileHelper.getAbsolutePath((File)fileDescriptor.getFile())));
            log.debug((Object)("SystemID : " + transactionChangesLog.getSystemId()));
        }
        if (log.isDebugEnabled()) {
            ChangesLogIterator logIterator = transactionChangesLog.getLogIterator();
            while (logIterator.hasNextLog()) {
                PlainChangesLog pcl = logIterator.nextLog();
                log.debug((Object)pcl.dump());
            }
        }
        this.receive((ItemStateChangesLog)transactionChangesLog, identifire);
    }
}

