/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.hierarchy.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.hierarchy.impl.AddPathPlugin;
import org.exoplatform.services.jcr.ext.hierarchy.impl.HierarchyConfig;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewUserListener
extends UserEventListener {
    private HierarchyConfig config_;
    private RepositoryService jcrService_;
    private Log log_;
    private NodeHierarchyCreator nodeHierarchyCreatorService_;
    private String userPath_;
    private static final String USERS_PATH = "usersPath";
    static final String NT_UNSTRUCTURED = "nt:unstructured".intern();

    public NewUserListener(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreatorService, LogService logService, InitParams params) throws Exception {
        this.jcrService_ = jcrService;
        this.nodeHierarchyCreatorService_ = nodeHierarchyCreatorService;
        this.log_ = logService.getLog(((Object)((Object)this)).getClass().getName());
        this.config_ = (HierarchyConfig)params.getObjectParamValues(HierarchyConfig.class).get(0);
        this.nodeHierarchyCreatorService_.addPlugin((ComponentPlugin)new AddPathPlugin(params));
        this.userPath_ = nodeHierarchyCreatorService.getJcrPath(USERS_PATH);
    }

    public void preSave(User user, boolean isNew) throws Exception {
        String userName = user.getUserName();
        List repositories = this.jcrService_.getConfig().getRepositoryConfigurations();
        for (RepositoryEntry repo : repositories) {
            this.processUserStructure(repo.getName(), userName);
        }
    }

    private void processUserStructure(String repository, String userName) throws Exception {
        ManageableRepository manageableRepository = this.jcrService_.getRepository(repository);
        String systemWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        Session session = manageableRepository.getSystemSession(systemWorkspace);
        Node usersHome = (Node)session.getItem(this.userPath_);
        Node userNode = null;
        try {
            userNode = (Node)session.getItem(this.userPath_ + "/" + userName);
        }
        catch (PathNotFoundException e) {
            userNode = usersHome.addNode(userName);
        }
        List<HierarchyConfig.JcrPath> jcrPaths = this.config_.getJcrPaths();
        for (HierarchyConfig.JcrPath jcrPath : jcrPaths) {
            this.createNode(userNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), this.getPermissions(jcrPath.getPermissions(), userName));
        }
        usersHome.save();
        session.save();
        session.logout();
    }

    public void preDelete(User user) {
        List repositories = this.jcrService_.getConfig().getRepositoryConfigurations();
        for (RepositoryEntry repo : repositories) {
            try {
                ManageableRepository manaRepo = this.jcrService_.getRepository(repo.getName());
                Session session = manaRepo.getSystemSession(manaRepo.getConfiguration().getDefaultWorkspaceName());
                Node usersHome = (Node)session.getItem(this.nodeHierarchyCreatorService_.getJcrPath(USERS_PATH));
                usersHome.getNode(user.getUserName()).remove();
                usersHome.save();
                session.save();
                session.logout();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createNode(Node rootNode, String path, String nodeType, List<String> mixinTypes, Map permissions) throws Exception {
        Node node = rootNode;
        for (String token : path.split("/")) {
            try {
                node = node.getNode(token);
            }
            catch (PathNotFoundException e) {
                if (nodeType == null || nodeType.length() == 0) {
                    nodeType = NT_UNSTRUCTURED;
                }
                if ((node = node.addNode(token, nodeType)).canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                }
                if (permissions != null && !permissions.isEmpty()) {
                    ((ExtendedNode)node).setPermissions(permissions);
                }
                if (mixinTypes.size() <= 0) continue;
                for (String mixin : mixinTypes) {
                    if (!node.canAddMixin(mixin)) continue;
                    node.addMixin(mixin);
                }
            }
        }
    }

    private Map getPermissions(List<HierarchyConfig.Permission> permissions, String userId) {
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        permissionsMap.put(userId, PermissionType.ALL);
        for (HierarchyConfig.Permission permission : permissions) {
            StringBuilder strPer = new StringBuilder();
            if ("true".equals(permission.getRead())) {
                strPer.append("read");
            }
            if ("true".equals(permission.getAddNode())) {
                strPer.append(",").append("add_node");
            }
            if ("true".equals(permission.getSetProperty())) {
                strPer.append(",").append("set_property");
            }
            if ("true".equals(permission.getRemove())) {
                strPer.append(",").append("remove");
            }
            permissionsMap.put(permission.getIdentity(), strPer.toString().split(","));
        }
        return permissionsMap;
    }
}

