/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.registry;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.Registry;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryService
extends Registry
implements Startable {
    private static Log log = ExoLogger.getLogger((String)"jcr.RegistryService");
    protected static final String EXO_REGISTRY_NT = "exo:registry";
    protected static final String EXO_REGISTRYENTRY_NT = "exo:registryEntry";
    protected static final String EXO_REGISTRYGROUP_NT = "exo:registryGroup";
    protected static final String NT_FILE = "registry-nodetypes.xml";
    protected static final String EXO_REGISTRY = "exo:registry";
    protected static final String EXO_REGISTRYENTRY = "exo:registryEntry";
    public static final String EXO_SERVICES = "exo:services";
    public static final String EXO_APPLICATIONS = "exo:applications";
    public static final String EXO_USERS = "exo:users";
    public static final String EXO_GROUPS = "exo:groups";
    protected final Map<String, String> regWorkspaces;
    protected final RepositoryService repositoryService;

    public RegistryService(InitParams params, RepositoryService repositoryService) throws RepositoryConfigurationException {
        this.repositoryService = repositoryService;
        this.regWorkspaces = new HashMap<String, String>();
        if (params == null) {
            throw new RepositoryConfigurationException("Init parameters expected");
        }
        PropertiesParam props = params.getPropertiesParam("locations");
        if (props == null) {
            throw new RepositoryConfigurationException("Property parameters 'locations' expected");
        }
        for (RepositoryEntry repConfiguration : this.repConfigurations()) {
            String repName = repConfiguration.getName();
            String wsName = null;
            if (props != null) {
                wsName = props.getProperty(repName);
                if (wsName == null) {
                    wsName = repConfiguration.getDefaultWorkspaceName();
                }
            } else {
                wsName = repConfiguration.getDefaultWorkspaceName();
            }
            this.addRegistryLocation(repName, wsName);
        }
    }

    @Override
    public RegistryEntry getEntry(SessionProvider sessionProvider, String entryPath) throws ItemNotFoundException, RepositoryException {
        String relPath = "exo:registry/" + entryPath;
        Session session = this.session(sessionProvider, this.repositoryService.getCurrentRepository());
        if (session.getRootNode().hasNode(relPath)) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                session.exportDocumentView("/" + relPath, (OutputStream)out, true, false);
                return RegistryEntry.parse(out.toByteArray());
            }
            catch (IOException e) {
                throw new RepositoryException("Can't export node to XML representation " + e);
            }
            catch (ParserConfigurationException e) {
                throw new RepositoryException("Can't export node to XML representation " + e);
            }
            catch (SAXException e) {
                throw new RepositoryException("Can't export node to XML representation " + e);
            }
        }
        throw new ItemNotFoundException("Entry not found " + relPath);
    }

    @Override
    public void createEntry(SessionProvider sessionProvider, String groupPath, RegistryEntry entry) throws RepositoryException {
        String fullPath = "/exo:registry/" + groupPath;
        try {
            this.checkGroup(sessionProvider, groupPath);
            this.session(sessionProvider, this.repositoryService.getCurrentRepository()).getWorkspace().importXML(fullPath, entry.getAsInputStream(), 0);
        }
        catch (IOException ioe) {
            throw new RepositoryException("Item " + fullPath + "can't be created " + ioe);
        }
        catch (ItemExistsException iee) {
            throw new RepositoryException("Item " + fullPath + "alredy exists " + (Object)((Object)iee));
        }
        catch (TransformerException te) {
            throw new RepositoryException("Can't get XML representation from stream " + te);
        }
    }

    @Override
    public void removeEntry(SessionProvider sessionProvider, String entryPath) throws RepositoryException {
        String relPath = "exo:registry/" + entryPath;
        Node root = this.session(sessionProvider, this.repositoryService.getCurrentRepository()).getRootNode();
        if (!root.hasNode(relPath)) {
            throw new ItemNotFoundException("Item not found " + relPath);
        }
        Node node = root.getNode(relPath);
        Node parent = node.getParent();
        node.remove();
        parent.save();
    }

    @Override
    public void recreateEntry(SessionProvider sessionProvider, String groupPath, RegistryEntry entry) throws RepositoryException {
        this.removeEntry(sessionProvider, groupPath + "/" + entry.getName());
        this.createEntry(sessionProvider, groupPath, entry);
    }

    @Override
    public Registry.RegistryNode getRegistry(SessionProvider sessionProvider) throws RepositoryException {
        return new Registry.RegistryNode(this, this.session(sessionProvider, this.repositoryService.getCurrentRepository()).getRootNode().getNode("exo:registry"));
    }

    private Session session(SessionProvider sessionProvider, ManageableRepository repo) throws RepositoryException {
        String repName = repo.getConfiguration().getName();
        return sessionProvider.getSession(this.regWorkspaces.get(repName), repo);
    }

    public void start() {
        try {
            for (RepositoryEntry repConfiguration : this.repConfigurations()) {
                InputStream xml = this.getClass().getResourceAsStream(NT_FILE);
                String repName = repConfiguration.getName();
                this.repositoryService.getRepository(repName).getNodeTypeManager().registerNodeTypes(xml, 0);
                xml.close();
            }
            this.initStorage(false);
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            log.error((Object)e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error((Object)e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    public void initStorage(boolean replace) throws RepositoryConfigurationException, RepositoryException {
        for (RepositoryEntry repConfiguration : this.repConfigurations()) {
            String repName = repConfiguration.getName();
            ManageableRepository rep = this.repositoryService.getRepository(repName);
            Session sysSession = rep.getSystemSession(this.regWorkspaces.get(repName));
            if (sysSession.getRootNode().hasNode("exo:registry") && replace) {
                sysSession.getRootNode().getNode("exo:registry").remove();
            }
            if (!sysSession.getRootNode().hasNode("exo:registry")) {
                Node rootNode = sysSession.getRootNode().addNode("exo:registry", "exo:registry");
                rootNode.addNode(EXO_SERVICES, EXO_REGISTRYGROUP_NT);
                rootNode.addNode(EXO_APPLICATIONS, EXO_REGISTRYGROUP_NT);
                rootNode.addNode(EXO_USERS, EXO_REGISTRYGROUP_NT);
                rootNode.addNode(EXO_GROUPS, EXO_REGISTRYGROUP_NT);
                sysSession.save();
            }
            sysSession.logout();
        }
    }

    public void addRegistryLocation(String repositoryName, String workspaceName) {
        this.regWorkspaces.put(repositoryName, workspaceName);
    }

    public void removeRegistryLocation(String repositoryName) {
        this.regWorkspaces.remove(repositoryName);
    }

    public void initRegistryEntry(String groupName, String entryName) throws RepositoryException, RepositoryConfigurationException {
        String relPath = "exo:registry/" + groupName + "/" + entryName;
        for (RepositoryEntry repConfiguration : this.repConfigurations()) {
            String repName = repConfiguration.getName();
            SessionProvider sysProvider = SessionProvider.createSystemProvider();
            Node root = this.session(sysProvider, this.repositoryService.getRepository(repName)).getRootNode();
            if (!root.hasNode(relPath)) {
                root.addNode(relPath, "exo:registryEntry");
                root.save();
            } else {
                log.info((Object)("The RegistryEntry " + relPath + "is already initialized on repository " + repName));
            }
            sysProvider.close();
        }
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    private List<RepositoryEntry> repConfigurations() {
        return this.repositoryService.getConfig().getRepositoryConfigurations();
    }

    private void checkGroup(SessionProvider sessionProvider, String groupPath) throws RepositoryException {
        String[] groupNames = groupPath.split("/");
        String prefix = "/exo:registry";
        Session session = this.session(sessionProvider, this.repositoryService.getCurrentRepository());
        for (String name : groupNames) {
            String path = prefix + "/" + name;
            try {
                Node group = (Node)session.getItem(path);
                if (!group.isNodeType(EXO_REGISTRYGROUP_NT)) {
                    throw new RepositoryException("Node at " + path + " should be  " + EXO_REGISTRYGROUP_NT + " type");
                }
            }
            catch (PathNotFoundException e) {
                Node parent = (Node)session.getItem(prefix);
                parent.addNode(name, EXO_REGISTRYGROUP_NT);
                parent.save();
            }
            prefix = path;
        }
    }
}

