/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.log.ExoLogger;

public abstract class BaseReplicationTestCase {
    protected static Log log = ExoLogger.getLogger((String)"ext.AbstractReplicationTestCase");
    protected final int BUFFER_SIZE = 1024;
    protected Session session;
    protected Node rootNode;
    private Credentials credentials;
    private Repository repository;

    public BaseReplicationTestCase(RepositoryService repositoryService, String reposytoryName, String workspaceName, String userName, String password) {
        try {
            this.credentials = new CredentialsImpl(userName, password.toCharArray());
            this.repository = repositoryService.getRepository(reposytoryName);
            this.session = this.repository.login(this.credentials, workspaceName);
            this.rootNode = this.session.getRootNode();
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't start BaseReplicationTestCase", (Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)"Can't start BaseReplicationTestCase", (Throwable)e);
        }
    }

    protected Node addNodePath(String repoPath) throws RepositoryException {
        String[] sArray;
        Node resultNode = this.rootNode;
        for (String nodeName : sArray = repoPath.split("[::]")) {
            resultNode = resultNode.hasNode(nodeName) ? resultNode.getNode(nodeName) : resultNode.addNode(nodeName);
        }
        return resultNode;
    }

    protected String getNormalizePath(String repoPath) {
        return repoPath.replaceAll("[:][:]", "/");
    }
}

