/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.organization.GroupHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipTypeHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.UserHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.UserProfileHandlerImpl;
import org.exoplatform.services.organization.BaseOrganizationService;

public class JCROrganizationServiceImpl
extends BaseOrganizationService {
    public static final String STORAGE_WORKSPACE = "storage-workspace";
    public static final String STORAGE_PATH = "storage-path";
    public static final String STORAGE_PATH_DEFAULT = "/exo:organization";
    protected final ManageableRepository repository;
    protected final String storageWorkspace;
    protected final String storagePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCROrganizationServiceImpl(RepositoryService repositoryService, InitParams params) throws ConfigurationException, RepositoryException, RepositoryConfigurationException {
        String storageWorkspace = params.getValueParam(STORAGE_WORKSPACE).getValue();
        String storagePath = params.getValueParam(STORAGE_PATH).getValue();
        this.repository = repositoryService.getDefaultRepository();
        this.storageWorkspace = storageWorkspace != null ? storageWorkspace : this.repository.getConfiguration().getDefaultWorkspaceName();
        if (storagePath != null) {
            if (storagePath.equals("/")) {
                throw new ConfigurationException("storage-path can not be a root node");
            }
            this.storagePath = storagePath;
        } else {
            this.storagePath = STORAGE_PATH_DEFAULT;
        }
        Session session = this.getStorageSession();
        try {
            session.getItem(this.storagePath);
        }
        catch (PathNotFoundException e) {
            Node storage = session.getRootNode().addNode(this.storagePath.substring(1), "exo:organizationStorage");
            storage.addNode("exo:users", "exo:organizationUsers");
            storage.addNode("exo:groups", "exo:organizationGroups");
            storage.addNode("exo:membershipTypes", "exo:organizationMembershipTypes");
            session.save();
        }
        finally {
            session.logout();
        }
        this.userDAO_ = new UserHandlerImpl(this);
        this.userProfileDAO_ = new UserProfileHandlerImpl(this);
        this.groupDAO_ = new GroupHandlerImpl(this);
        this.membershipDAO_ = new MembershipHandlerImpl(this);
        this.membershipTypeDAO_ = new MembershipTypeHandlerImpl(this);
    }

    Session getStorageSession() throws RepositoryException {
        return this.repository.getSystemSession(this.storageWorkspace);
    }

    String getStoragePath() {
        return this.storagePath;
    }
}

