/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipTypeImpl;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;

public class MembershipTypeHandlerImpl
implements MembershipTypeHandler {
    protected final JCROrganizationServiceImpl service;

    MembershipTypeHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Date now = Calendar.getInstance().getTime();
        mt.setCreatedDate(now);
        mt.setModifiedDate(now);
        return mt;
    }

    public MembershipType createMembershipTypeInstance() {
        return new MembershipTypeImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType findMembershipType(String name) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Node mtNode = (Node)session.getItem(this.service.getStoragePath() + "/exo:membershipTypes/" + name);
            MembershipTypeImpl mt = new MembershipTypeImpl();
            mt.setName(mtNode.getName());
            mt.setDescription(mtNode.getProperty("exo:description").getString());
            MembershipType membershipType = null;
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipTypes() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Node storageNode = (Node)session.getItem(this.service.getStoragePath());
            ArrayList<MembershipTypeImpl> types = new ArrayList<MembershipTypeImpl>();
            NodeIterator nodes = storageNode.getNodes("exo:membershipTypes");
            while (nodes.hasNext()) {
                Node mtNode = nodes.nextNode();
                MembershipTypeImpl mt = new MembershipTypeImpl();
                mt.setName(mtNode.getName());
                mt.setDescription(mtNode.getProperty("exo:description").getString());
                types.add(mt);
            }
            ArrayList<MembershipTypeImpl> arrayList = types;
            return arrayList;
        }
        finally {
            session.logout();
        }
    }

    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        return null;
    }

    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        return null;
    }
}

