/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test.concurrent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.replication.test.BaseReplicationTestCase;

public class ConcurrentModificationTestCase
extends BaseReplicationTestCase {
    public ConcurrentModificationTestCase(RepositoryService repositoryService, String reposytoryName, String workspaceName, String userName, String password) {
        super(repositoryService, reposytoryName, workspaceName, userName, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer createContent(String repoPath, String fileName, Long iterations, String simpleContent) {
        StringBuffer sb = new StringBuffer();
        log.info((Object)"ReplicationTestService.createContent run");
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempF", "_");
            FileOutputStream fos = new FileOutputStream(tempFile);
            for (long i = 0L; i < iterations; ++i) {
                fos.write(simpleContent.getBytes());
            }
            fos.close();
            long start = System.currentTimeMillis();
            Node cool = this.addNodePath(repoPath).addNode(fileName, "nt:file");
            Node contentNode = cool.addNode("jcr:content", "nt:resource");
            contentNode.setProperty("jcr:encoding", "UTF-8");
            contentNode.setProperty("jcr:data", (InputStream)new FileInputStream(tempFile));
            contentNode.setProperty("jcr:mimeType", "application/octet-stream");
            contentNode.setProperty("jcr:lastModified", this.session.getValueFactory().createValue(Calendar.getInstance()));
            this.session.save();
            long end = System.currentTimeMillis();
            log.info((Object)("The time of the adding of nt:file : " + (end - start) / 1000L + " sec"));
            sb.append("ok");
        }
        catch (Exception e) {
            log.error((Object)"Can't save nt:file : ", (Throwable)e);
            sb.append("fail");
        }
        finally {
            tempFile.delete();
        }
        return sb;
    }

    public StringBuffer compareData(String srcRepoPath, String srcFileName, String destRepoPath, String destFileName) {
        StringBuffer sb = new StringBuffer();
        try {
            Node srcNode = ((Node)this.session.getItem(this.getNormalizePath(srcRepoPath))).getNode(srcFileName);
            Node destNode = ((Node)this.session.getItem(this.getNormalizePath(destRepoPath))).getNode(destFileName);
            InputStream srcStream = srcNode.getNode("jcr:content").getProperty("jcr:data").getStream();
            InputStream destStream = destNode.getNode("jcr:content").getProperty("jcr:data").getStream();
            this.compareStream(srcStream, destStream);
            log.info((Object)"ReplicationTestService.startThread run");
            sb.append("ok");
        }
        catch (Exception e) {
            log.error((Object)"Can't compare the data : ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer startThreadUpdater(String srcRepoPath, String srcFileName, String destRepoPath, String destFileName, Long iterations) {
        StringBuffer sb = new StringBuffer();
        try {
            Node srcNode = ((Node)this.session.getItem(this.getNormalizePath(srcRepoPath))).getNode(srcFileName);
            Node destNode = ((Node)this.session.getItem(this.getNormalizePath(destRepoPath))).getNode(destFileName);
            DataUpdaterThread updaterThread = new DataUpdaterThread(srcNode, destNode, iterations);
            updaterThread.start();
            log.info((Object)"ReplicationTestService.startThread run");
            sb.append("ok");
        }
        catch (Exception e) {
            log.error((Object)"Can't start the thread : ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    class DataUpdaterThread
    extends Thread {
        private final Node srcNode;
        private final Node destNode;
        private final Long iterations;

        public DataUpdaterThread(Node srcNode, Node destNode, Long iterations) {
            this.srcNode = srcNode;
            this.destNode = destNode;
            this.iterations = iterations;
        }

        public void run() {
            String destPath = null;
            try {
                destPath = this.destNode.getPath();
                int i = 0;
                while ((long)i < this.iterations) {
                    InputStream srcStream = this.srcNode.getNode("jcr:content").getProperty("jcr:data").getStream();
                    this.destNode.getNode("jcr:content").setProperty("jcr:data", srcStream);
                    ConcurrentModificationTestCase.this.session.save();
                    log.info((Object)(Calendar.getInstance().getTime().toGMTString() + " : "));
                    log.info((Object)(this.getName() + " : " + "has been updated the 'nt:file' " + destPath + " : iterations == " + i));
                    ++i;
                }
            }
            catch (RepositoryException e) {
                log.error((Object)("Can't update the 'nt:file' " + destPath + " : "), (Throwable)e);
            }
        }
    }
}

