/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.common;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.SessionLifecycleListener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class SessionProvider
implements SessionLifecycleListener {
    public static final String SESSION_PROVIDER = "JCRsessionProvider";
    private final Map<String, ExtendedSession> cache;
    private boolean isSystem;
    private ManageableRepository currentRepository;
    private String currentWorkspace;

    public SessionProvider(ConversationState userState) {
        this(false);
        if (userState.getAttribute(SESSION_PROVIDER) == null) {
            userState.setAttribute(SESSION_PROVIDER, (Object)this);
        }
    }

    private SessionProvider(boolean isSystem) {
        this.isSystem = isSystem;
        this.cache = Collections.synchronizedMap(new HashMap());
    }

    public static SessionProvider createSystemProvider() {
        return new SessionProvider(true);
    }

    public static SessionProvider createAnonimProvider() {
        Identity id = new Identity(SystemIdentity.ANONIM, new HashSet());
        return new SessionProvider(new ConversationState(id));
    }

    public Session getSession(String workspaceName, ManageableRepository repository) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (workspaceName == null) {
            throw new NullPointerException("Workspace Name is null");
        }
        ExtendedSession session = this.cache.get(this.key(repository, workspaceName));
        if (session == null) {
            session = !this.isSystem ? (ExtendedSession)repository.login(workspaceName) : (ExtendedSession)repository.getSystemSession(workspaceName);
            session.registerLifecycleListener((SessionLifecycleListener)this);
            this.cache.put(this.key(repository, workspaceName), session);
        }
        return session;
    }

    public void close() {
        Collection<ExtendedSession> cachedSessions = this.cache.values();
        for (Session session : cachedSessions) {
            session.logout();
        }
        this.cache.clear();
    }

    public void onCloseSession(ExtendedSession session) {
        this.cache.remove(this.key((ManageableRepository)session.getRepository(), session.getWorkspace().getName()));
    }

    private String key(ManageableRepository repository, String workspaceName) {
        String repositoryName = repository.getConfiguration().getName();
        return repositoryName + workspaceName;
    }

    public ManageableRepository getCurrentRepository() {
        return this.currentRepository;
    }

    public String getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public void setCurrentRepository(ManageableRepository currentRepository) {
        this.currentRepository = currentRepository;
    }

    public void setCurrentWorkspace(String currentWorkspace) {
        this.currentWorkspace = currentWorkspace;
    }
}

