/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.hierarchy.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.hierarchy.impl.AddPathPlugin;
import org.exoplatform.services.jcr.ext.hierarchy.impl.HierarchyConfig;
import org.exoplatform.services.jcr.ext.hierarchy.impl.UserAddPathPlugin;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class NodeHierarchyCreatorImpl
implements NodeHierarchyCreator,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.NodeHierarchyCreatorImpl");
    private static final String USERS_PATH = "usersPath";
    private static final String USER_APPLICATION = "userApplicationData";
    private static final String PUBLIC_APPLICATION = "eXoApplications";
    private static final String USER_PRIVATE = "userPrivate";
    private static final String USER_PUBLIC = "userPublic";
    private final RepositoryService jcrService_;
    private final DataDistributionManager dataDistributionManager_;
    private final List<AddPathPlugin> pathPlugins_ = new ArrayList<AddPathPlugin>();
    private final List<UserAddPathPlugin> userPathPlugins_ = new ArrayList<UserAddPathPlugin>();
    private final Map<String, String> paths_ = new HashMap<String, String>();
    private final boolean oldDistribution;
    private final boolean autoMigrate;

    public NodeHierarchyCreatorImpl(RepositoryService jcrService, InitParams params) {
        this(jcrService, null, params);
    }

    public NodeHierarchyCreatorImpl(RepositoryService jcrService, DataDistributionManager dataDistributionManager, InitParams params) {
        if (dataDistributionManager == null) {
            throw new IllegalArgumentException("The DataDistributionManager is now mandatory if you use the NodeHierarchyCreator, so please define it in your configuration as described in the JCR documentation");
        }
        this.jcrService_ = jcrService;
        this.dataDistributionManager_ = dataDistributionManager;
        this.oldDistribution = params != null && params.getValueParam("old-user-distribution") != null && Boolean.valueOf(params.getValueParam("old-user-distribution").getValue()) != false;
        boolean bl = this.autoMigrate = params != null && params.getValueParam("auto-migrate") != null && Boolean.valueOf(params.getValueParam("auto-migrate").getValue()) != false;
        if (PropertyManager.isDevelopping() && !this.oldDistribution) {
            LOG.info((Object)"The NodeHierarchyCreator is configured to use the new distribution mechanism for the users directories, if you prefer to use the old mechanism set the value parameter 'old-user-distribution' to 'true'.");
        }
    }

    public void start() {
        try {
            this.processAddPathPlugin(this.pathPlugins_, "/", null);
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurs while processing the plugins", (Throwable)e);
        }
        if (this.isNeededToMigrate()) {
            try {
                this.migrate();
            }
            catch (RepositoryException e) {
                LOG.error((Object)"An error occurs while upgrading JCR structure", (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    @Override
    public void init(String repository) throws Exception {
        this.initBasePath(repository);
    }

    @Override
    public void init() throws Exception {
        this.initBasePath(null);
    }

    private Node createNode(Node rootNode, String path, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws Exception {
        return this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.NONE).getOrCreateDataNode(rootNode, path, nodeType, mixinTypes, permissions);
    }

    private void processAddPathPlugin(List<? extends AddPathPlugin> pathPlugins, String parentPath, String userName) throws Exception {
        Session session = null;
        for (AddPathPlugin addPathPlugin : pathPlugins) {
            HierarchyConfig hierarchyConfig = addPathPlugin.getPaths();
            if (hierarchyConfig == null) continue;
            List<HierarchyConfig.JcrPath> jcrPaths = hierarchyConfig.getJcrPaths();
            List<HierarchyConfig.JcrLink> jcrLinks = hierarchyConfig.getJcrLinks();
            if (jcrPaths == null && jcrLinks == null) continue;
            String repositoryName = hierarchyConfig.getRepository();
            ManageableRepository repository = repositoryName == null || repositoryName.isEmpty() ? this.jcrService_.getCurrentRepository() : this.jcrService_.getRepository(repositoryName);
            LinkedHashSet<String> workspaceNames = new LinkedHashSet<String>();
            if (hierarchyConfig.getWorkspaces() != null) {
                workspaceNames.addAll(hierarchyConfig.getWorkspaces());
            }
            for (String workspaceName : workspaceNames) {
                HierarchyConfig.JcrPath currentjcrPath = null;
                try {
                    session = repository.getSystemSession(workspaceName);
                    if (!session.itemExists(parentPath)) {
                        LOG.warn("Parent path {} doesn't exist on workspace {}.", new Object[]{parentPath, workspaceName});
                        continue;
                    }
                    Node rootNode = (Node)session.getItem(parentPath);
                    if (jcrPaths != null) {
                        Iterator<Object> iterator = jcrPaths.iterator();
                        while (iterator.hasNext()) {
                            HierarchyConfig.JcrPath jcrPath;
                            currentjcrPath = jcrPath = (HierarchyConfig.JcrPath)iterator.next();
                            if (!StringUtils.isNotBlank((String)userName) && (jcrPath.getAlias().equals(USER_APPLICATION) || jcrPath.getAlias().startsWith(USER_PRIVATE) || jcrPath.getAlias().startsWith(USER_PUBLIC))) continue;
                            LOG.info("Create node with alias '{}' '{}:{}'", new Object[]{jcrPath.getAlias(), workspaceName, jcrPath.getPath()});
                            NodeImpl addedNode = (NodeImpl)this.createNode(rootNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), jcrPath.getPermissions(userName));
                            if (addedNode.canAddMixin("exo:privilegeable")) {
                                addedNode.addMixin("exo:privilegeable");
                                Map<String, String[]> permissions = this.buildPermissions(addedNode);
                                addedNode.setPermissions(permissions);
                                addedNode.save();
                            }
                            if (StringUtils.isNotBlank((String)userName)) {
                                addedNode.removePermission(userName, "remove");
                            }
                            session.save();
                        }
                    }
                    if (jcrLinks == null) continue;
                    for (HierarchyConfig.JcrLink jcrLink : jcrLinks) {
                        if (!rootNode.hasNode(jcrLink.getSourcePath())) {
                            LOG.warn("Can't create symlink {}. path not found {} under parent path {}", new Object[]{jcrLink.getTargetPath(), jcrLink.getSourcePath(), rootNode.getPath()});
                            continue;
                        }
                        if (rootNode.hasNode(jcrLink.getTargetPath())) continue;
                        NodeImpl sourceNode = (NodeImpl)rootNode.getNode(jcrLink.getSourcePath());
                        this.createLink(rootNode, sourceNode, jcrLink.getTargetPath());
                        session.save();
                    }
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("An error occurs while processing the JCR path which alias is " + (currentjcrPath == null ? null : currentjcrPath.getAlias()) + " with the workspace " + workspaceName), (Throwable)e);
                }
            }
        }
    }

    private Map<String, String[]> buildPermissions(NodeImpl node) throws RepositoryException {
        HashMap<String, String[]> permissions = new HashMap<String, String[]>();
        List permsList = new ArrayList();
        String key = null;
        for (AccessControlEntry entry : node.getACL().getPermissionEntries()) {
            key = entry.getIdentity();
            if (permissions.containsKey(key)) continue;
            permsList = node.getACL().getPermissions(key);
            permissions.put(key, permsList.toArray(new String[permsList.size()]));
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBasePath(String repositoryName) throws Exception {
        Session session = null;
        ManageableRepository manageableRepository = repositoryName == null || repositoryName.isEmpty() ? this.jcrService_.getCurrentRepository() : this.jcrService_.getRepository(repositoryName);
        String defaultWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        String systemWorkspace = manageableRepository.getConfiguration().getSystemWorkspaceName();
        boolean isSameWorkspace = defaultWorkspace.equalsIgnoreCase(systemWorkspace);
        String[] workspaceNames = manageableRepository.getWorkspaceNames();
        for (AddPathPlugin pathPlugin : this.pathPlugins_) {
            List<HierarchyConfig.JcrPath> jcrPaths;
            HierarchyConfig hierarchyConfig = pathPlugin.getPaths();
            if (hierarchyConfig == null || (jcrPaths = hierarchyConfig.getJcrPaths()) == null) continue;
            for (String workspaceName : workspaceNames) {
                if (!isSameWorkspace && workspaceName.equalsIgnoreCase(systemWorkspace)) continue;
                HierarchyConfig.JcrPath currentjcrPath = null;
                try {
                    session = manageableRepository.getSystemSession(workspaceName);
                    Node rootNode = session.getRootNode();
                    Iterator<HierarchyConfig.JcrPath> iterator = jcrPaths.iterator();
                    while (iterator.hasNext()) {
                        HierarchyConfig.JcrPath jcrPath;
                        currentjcrPath = jcrPath = iterator.next();
                        if (jcrPath.getAlias().equals(USER_APPLICATION) || jcrPath.getAlias().startsWith(USER_PRIVATE) || jcrPath.getAlias().startsWith(USER_PUBLIC)) continue;
                        this.createNode(rootNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), jcrPath.getPermissions(null));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("An error occurs while processing the JCR path which alias is " + (currentjcrPath == null ? null : currentjcrPath.getAlias()) + " with the workspace " + workspaceName), (Throwable)e);
                }
                finally {
                    if (session != null) {
                        session.logout();
                        session = null;
                    }
                }
            }
        }
    }

    @Override
    public Node getUserApplicationNode(SessionProvider sessionProvider, String userName) throws Exception {
        Node userNode = this.getUserNode(sessionProvider, userName);
        return this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.NONE).getOrCreateDataNode(userNode, this.getJcrPath(USER_APPLICATION));
    }

    @Override
    public Node getPublicApplicationNode(SessionProvider sessionProvider) throws Exception {
        Session session = this.getSession(sessionProvider);
        Node rootNode = session.getRootNode();
        return this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.NONE).getDataNode(rootNode, this.getJcrPath(PUBLIC_APPLICATION));
    }

    @Override
    public Node getUserNode(SessionProvider sessionProvider, String userName) throws Exception {
        Node userHomeNode;
        Session session = this.getSession(sessionProvider);
        Node usersNode = this.getRootOfUsersNodes(session);
        DataDistributionType type = this.dataDistributionManager_.getDataDistributionType(this.oldDistribution ? DataDistributionMode.NONE : DataDistributionMode.READABLE);
        try {
            userHomeNode = type.getDataNode(usersNode, userName);
        }
        catch (PathNotFoundException e) {
            userHomeNode = null;
        }
        if (userHomeNode == null) {
            userHomeNode = type.getOrCreateDataNode(usersNode, userName);
            session.save();
            try {
                if (userHomeNode.canAddMixin("exo:userFolder")) {
                    userHomeNode.addMixin("exo:userFolder");
                    session.save();
                }
            }
            catch (NoSuchNodeTypeException e) {
                LOG.trace((Object)("can't add mixin 'exo:userFolder' to folder " + userHomeNode.getPath()), (Throwable)e);
            }
            this.processAddPathPlugin(this.userPathPlugins_, userHomeNode.getPath(), userName);
        }
        return userHomeNode;
    }

    @Override
    public void removeUserNode(SessionProvider sessionProvider, String userName) throws Exception {
        block2: {
            Session session = this.getSession(sessionProvider);
            try {
                Node usersNode = this.getRootOfUsersNodes(session);
                DataDistributionType type = this.dataDistributionManager_.getDataDistributionType(this.oldDistribution ? DataDistributionMode.NONE : DataDistributionMode.READABLE);
                type.removeDataNode(usersNode, userName);
            }
            catch (PathNotFoundException e) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
    }

    private Session getSession(SessionProvider sessionProvider) throws RepositoryException {
        ManageableRepository repo = this.jcrService_.getCurrentRepository();
        return sessionProvider.getSession(repo.getConfiguration().getDefaultWorkspaceName(), repo);
    }

    @Override
    public String getJcrPath(String alias) {
        return this.paths_.get(alias);
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) {
        block5: {
            block4: {
                if (!(plugin instanceof UserAddPathPlugin)) break block4;
                UserAddPathPlugin app = (UserAddPathPlugin)plugin;
                this.userPathPlugins_.add(app);
                if (app.getPaths() == null || app.getPaths().getJcrPaths() == null) break block5;
                for (HierarchyConfig.JcrPath jcrPath : app.getPaths().getJcrPaths()) {
                    if (jcrPath.getAlias() == null || jcrPath.getPath() == null) continue;
                    this.paths_.put(jcrPath.getAlias(), jcrPath.getPath());
                }
                break block5;
            }
            if (plugin instanceof AddPathPlugin) {
                AddPathPlugin app = (AddPathPlugin)plugin;
                this.pathPlugins_.add(app);
                if (app.getPaths() != null && app.getPaths().getJcrPaths() != null) {
                    for (HierarchyConfig.JcrPath jcrPath : app.getPaths().getJcrPaths()) {
                        if (jcrPath.getAlias() == null || jcrPath.getPath() == null) continue;
                        this.paths_.put(jcrPath.getAlias(), jcrPath.getPath());
                    }
                }
            }
        }
    }

    private boolean isNeededToMigrate() {
        return !this.oldDistribution && this.autoMigrate;
    }

    private void migrate() throws RepositoryException {
        Session session = this.getSession(SessionProvider.createSystemProvider());
        try {
            Node rootNode = this.getRootOfUsersNodes(session);
            this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.READABLE).migrate(rootNode);
        }
        finally {
            session.logout();
        }
    }

    private Node getRootOfUsersNodes(Session session) throws PathNotFoundException, RepositoryException {
        String usersPath = this.getJcrPath(USERS_PATH);
        return (Node)session.getItem(usersPath);
    }

    private Node createLink(Node parent, NodeImpl target, String linkName) throws RepositoryException {
        if (!target.isNodeType("exo:symlink")) {
            NodeImpl linkNode;
            block6: {
                if (target.canAddMixin("mix:referenceable")) {
                    target.addMixin("mix:referenceable");
                    target.getSession().save();
                }
                if (linkName == null || linkName.trim().length() == 0) {
                    linkName = target.getName();
                }
                if ((linkNode = (NodeImpl)parent.addNode(linkName, "exo:symlink")).canAddMixin("exo:privilegeable")) {
                    linkNode.addMixin("exo:privilegeable");
                }
                try {
                    linkNode.setPermissions(this.buildPermissions(target));
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block6;
                    LOG.error((Object)"CAN NOT UPDATE ACCESS PERMISSIONS FROM TARGET NODE TO LINK NODE", (Throwable)e);
                }
            }
            linkNode.setProperty("exo:workspace", target.getSession().getWorkspace().getName());
            linkNode.setProperty("exo:primaryType", target.getPrimaryNodeType().getName());
            linkNode.setProperty("exo:uuid", target.getUUID());
            linkNode.getSession().save();
            return linkNode;
        }
        return null;
    }
}

