/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.ext.backup.impl.BackupMessage;

public class BackupError
extends BackupMessage {
    final List<StackTraceElement[]> stackTraces = new ArrayList<StackTraceElement[]>();

    BackupError(Throwable e) {
        super(e.toString());
        this.readStackTrace(e);
    }

    BackupError(String description, Throwable e) {
        super(description);
        this.readStackTrace(e);
    }

    BackupError(String description, List<StackTraceElement[]> clone) {
        super(description);
        this.stackTraces.addAll(clone);
    }

    @Override
    public boolean isError() {
        return true;
    }

    private void readStackTrace(Throwable e) {
        Throwable cause;
        this.stackTraces.add(e.getStackTrace());
        while ((cause = e.getCause()) != null) {
            this.stackTraces.add(cause.getStackTrace());
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println("Backup error: " + this.message);
            if (this.stackTraces.size() > 0) {
                int i;
                StackTraceElement[] ourTrace = this.stackTraces.get(0);
                for (i = 0; i < ourTrace.length; ++i) {
                    s.println("\tat " + ourTrace[i]);
                }
                for (i = 1; i < this.stackTraces.size(); ++i) {
                    this.printStackTraceAsCause(s, ourTrace, this.stackTraces.get(i));
                }
            }
        }
    }

    private void printStackTraceAsCause(PrintStream s, StackTraceElement[] ourTrace, StackTraceElement[] causedTrace) {
        int m = ourTrace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && ourTrace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = ourTrace.length - 1 - m;
        s.println("Caused by: " + this);
        for (int i = 0; i <= m; ++i) {
            s.println("\tat " + ourTrace[i]);
        }
        if (framesInCommon != 0) {
            s.println("\t... " + framesInCommon + " more");
        }
    }
}

