/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.distribution.impl;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.ext.distribution.impl.AbstractDataDistributionType;

public class DataDistributionByHash
extends AbstractDataDistributionType {
    private int depth = 4;
    private String hashAlgorithm = "MD5";

    @Override
    protected List<String> getAncestors(String dataId) {
        ArrayList<String> result = new ArrayList<String>(this.depth);
        String hash = this.hash(dataId);
        int length = hash.length();
        for (int i = 0; i < this.depth - 1 && i < length; ++i) {
            result.add(hash.substring(i, i + 1));
        }
        result.add(dataId);
        return result;
    }

    private String hash(String dataId) {
        try {
            MessageDigest digest = MessageDigest.getInstance(this.hashAlgorithm);
            digest.update(dataId.getBytes("UTF-8"));
            return new BigInteger(1, digest.digest()).toString(32);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not generate the hash code of '" + dataId + "' with the algorithm '" + this.hashAlgorithm + "'", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not generate the hash code of '" + dataId + "' with the algorithm '" + this.hashAlgorithm + "'", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not generate the hash code of '" + dataId + "' with the algorithm '" + this.hashAlgorithm + "'", e);
        }
    }

    @Override
    protected boolean useParametersOnLeafOnly() {
        return true;
    }
}

