/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.WorkspaceRestoreException;
import org.exoplatform.services.jcr.ext.backup.impl.JobWorkspaceRestore;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.JCRRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JobExistingWorkspaceSameConfigRestore
extends JobWorkspaceRestore {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.JobExistingWorkspaceSameConfigRestore");

    public JobExistingWorkspaceSameConfigRestore(RepositoryService repositoryService, BackupManager backupManager, String repositoryName, File logFile, WorkspaceEntry wEntry) {
        super(repositoryService, backupManager, repositoryName, logFile, wEntry);
    }

    @Override
    protected void restoreWorkspace() throws WorkspaceRestoreException {
        ArrayList<DataRestore> dataRestorer = new ArrayList<DataRestore>();
        ArrayList<WorkspaceContainerFacade> workspacesWaits4Resume = new ArrayList<WorkspaceContainerFacade>();
        try {
            ManageableRepository repository = this.repositoryService.getRepository(this.repositoryName);
            if (!DBInitializerHelper.getDatabaseType((WorkspaceEntry)this.wEntry).isMultiDatabase()) {
                for (String wsName : repository.getWorkspaceNames()) {
                    WorkspaceContainerFacade wsContainer = repository.getWorkspaceContainer(wsName);
                    wsContainer.setState(3);
                    workspacesWaits4Resume.add(wsContainer);
                }
            } else {
                WorkspaceContainerFacade wsContainer = repository.getWorkspaceContainer(this.wEntry.getName());
                wsContainer.setState(3);
                workspacesWaits4Resume.add(wsContainer);
            }
            List backupable = repository.getWorkspaceContainer(this.wEntry.getName()).getComponentInstancesOfType(Backupable.class);
            BackupChainLog backupChainLog = new BackupChainLog(this.backupChainLogFile);
            File storageDir = backupChainLog.getBackupConfig().getBackupDir();
            File fullBackupDir = JCRRestore.getFullBackupFile((File)storageDir);
            DataRestoreContext context = new DataRestoreContext(new String[]{"storage-dir"}, new Object[]{fullBackupDir});
            for (Backupable component : backupable) {
                dataRestorer.add(component.getDataRestorer(context));
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.clean();
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.restore();
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.commit();
            }
            for (WorkspaceContainerFacade wsContainer : workspacesWaits4Resume) {
                wsContainer.setState(1);
            }
            WorkspacePersistentDataManager dataManager = (WorkspacePersistentDataManager)repository.getWorkspaceContainer(this.wEntry.getName()).getComponent(WorkspacePersistentDataManager.class);
            FileCleanerHolder cleanerHolder = (FileCleanerHolder)repository.getWorkspaceContainer(this.wEntry.getName()).getComponent(FileCleanerHolder.class);
            JCRRestore restorer = new JCRRestore((DataManager)dataManager, cleanerHolder.getFileCleaner());
            for (File incrBackupFile : JCRRestore.getIncrementalFiles((File)storageDir)) {
                restorer.incrementalRestore(incrBackupFile);
            }
        }
        catch (Throwable t) {
            for (DataRestore restorer : dataRestorer) {
                try {
                    restorer.rollback();
                }
                catch (BackupException e) {
                    LOG.error((Object)"Can't rollback changes", (Throwable)e);
                }
            }
            throw new WorkspaceRestoreException("Workspace " + this.wEntry.getName() + " was not restored", t);
        }
        finally {
            for (DataRestore restorer : dataRestorer) {
                try {
                    restorer.close();
                }
                catch (BackupException e) {
                    LOG.error((Object)"Can't close restorer", (Throwable)e);
                }
            }
            try {
                for (WorkspaceContainerFacade wsContainer : workspacesWaits4Resume) {
                    wsContainer.setState(1);
                }
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Can't resume component", (Throwable)e);
            }
        }
    }
}

