/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.hierarchy.impl;

import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class NewUserListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.NewUserListener");
    private final NodeHierarchyCreator nodeHierarchyCreatorService_;

    public NewUserListener(NodeHierarchyCreator nodeHierarchyCreatorService) throws Exception {
        this.nodeHierarchyCreatorService_ = nodeHierarchyCreatorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDelete(User user) {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            this.nodeHierarchyCreatorService_.removeUserNode(sessionProvider, user.getUserName());
        }
        catch (Exception e) {
            LOG.error((Object)("An error occurs while removing the user directory of '" + user.getUserName() + "'"), (Throwable)e);
        }
        finally {
            sessionProvider.close();
            sessionProvider = null;
        }
    }
}

