/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;

public class SIDGenerator {
    private static String hexServerIP_ = null;
    private static final SecureRandom seeder_ = new SecureRandom();

    public static String generate() {
        return SIDGenerator.generateStringID("" + System.currentTimeMillis());
    }

    public static long generateLongID(Object o) {
        String uuid = SIDGenerator.generateStringID(o);
        return uuid.hashCode();
    }

    public static int generatIntegerID(Object o) {
        String uuid = SIDGenerator.generateStringID(o);
        return uuid.hashCode();
    }

    public static String generateStringID(Object o) {
        StringBuffer tmpBuffer = new StringBuffer(16);
        String hashcode = SIDGenerator.hexFormat(System.identityHashCode(o), 8);
        tmpBuffer.append(hexServerIP_);
        tmpBuffer.append(hashcode);
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = seeder_.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(SIDGenerator.hexFormat(timeLow, 8));
        guid.append(tmpBuffer.toString());
        guid.append(SIDGenerator.hexFormat(node, 8));
        return guid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return SIDGenerator.padHex(s, j) + s;
    }

    private static String padHex(String s, int i) {
        StringBuffer tmpBuffer = new StringBuffer();
        if (s.length() < i) {
            for (int j = 0; j < i - s.length(); ++j) {
                tmpBuffer.append('0');
            }
        }
        return tmpBuffer.toString();
    }

    static {
        try {
            InetAddress localInetAddress = InetAddress.getLocalHost();
            byte[] serverIP = localInetAddress.getAddress();
            hexServerIP_ = SIDGenerator.hexFormat(SIDGenerator.getInt(serverIP), 8);
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            hexServerIP_ = null;
        }
    }
}

