/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.hierarchy;

import java.util.Arrays;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.hierarchy.impl.NewGroupListener;
import org.exoplatform.services.jcr.ext.hierarchy.impl.NewUserListener;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.security.ConversationState;

public class TestNodeHierarchyCreator
extends BaseStandaloneTest {
    private NodeHierarchyCreator creator;
    private SessionProvider sessionProvider;
    private NewUserListener userListener;
    private NewGroupListener groupListener;
    private Session session;

    @Override
    public void setUp() throws Exception {
        NodeType symlinkNodeType;
        super.setUp();
        this.creator = (NodeHierarchyCreator)this.container.getComponentInstanceOfType(NodeHierarchyCreator.class);
        this.userListener = (NewUserListener)this.container.getComponentInstanceOfType(NewUserListener.class);
        this.groupListener = (NewGroupListener)this.container.getComponentInstanceOfType(NewGroupListener.class);
        this.sessionProvider = new SessionProvider(ConversationState.getCurrent());
        this.session = this.sessionProvider.getSession("ws1", (ManageableRepository)this.repository);
        try {
            symlinkNodeType = this.repository.getNodeTypeManager().getNodeType("exo:symlink");
        }
        catch (NoSuchNodeTypeException e) {
            symlinkNodeType = null;
        }
        if (symlinkNodeType == null) {
            NodeTypeValue nodeTypeValue = new NodeTypeValue();
            nodeTypeValue.setName("exo:symlink");
            nodeTypeValue.setPrimaryItemName(null);
            nodeTypeValue.setMixin(false);
            nodeTypeValue.setDeclaredSupertypeNames(Collections.singletonList("nt:hierarchyNode"));
            PropertyDefinitionValue workspaceProperty = new PropertyDefinitionValue();
            workspaceProperty.setName("exo:workspace");
            workspaceProperty.setRequiredType(1);
            workspaceProperty.setOnVersion(1);
            PropertyDefinitionValue uuidProperty = new PropertyDefinitionValue();
            uuidProperty.setName("exo:uuid");
            uuidProperty.setRequiredType(9);
            uuidProperty.setOnVersion(1);
            PropertyDefinitionValue primaryTypeProperty = new PropertyDefinitionValue();
            primaryTypeProperty.setName("exo:primaryType");
            primaryTypeProperty.setRequiredType(7);
            primaryTypeProperty.setOnVersion(1);
            nodeTypeValue.setDeclaredPropertyDefinitionValues(Arrays.asList(workspaceProperty, uuidProperty, primaryTypeProperty));
            this.repository.getNodeTypeManager().registerNodeType(nodeTypeValue, 0);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.creator = null;
        this.userListener = null;
        this.groupListener = null;
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        if (this.sessionProvider != null) {
            this.sessionProvider.close();
            this.sessionProvider = null;
        }
        super.tearDown();
    }

    public void testGetJcrPath() throws Exception {
        TestNodeHierarchyCreator.assertEquals((String)"/exo:applications", (String)this.creator.getJcrPath("eXoApplications"));
        TestNodeHierarchyCreator.assertEquals((String)"/exo:services", (String)this.creator.getJcrPath("eXoServices"));
        TestNodeHierarchyCreator.assertEquals((String)"/Users", (String)this.creator.getJcrPath("usersPath"));
        TestNodeHierarchyCreator.assertEquals((String)"/Groups/Path/Home", (String)this.creator.getJcrPath("groupsPath"));
    }

    public void testInit() throws Exception {
        Node node = (Node)this.session.getItem("/exo:services");
        TestNodeHierarchyCreator.assertNotNull((Object)node);
        TestNodeHierarchyCreator.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestNodeHierarchyCreator.assertTrue((boolean)node.canAddMixin("mix:referenceable"));
        TestNodeHierarchyCreator.assertTrue((node.isNodeType("exo:privilegeable") || node.canAddMixin("exo:privilegeable") ? 1 : 0) != 0);
        node = (Node)this.session.getItem("/exo:applications");
        TestNodeHierarchyCreator.assertNotNull((Object)node);
        TestNodeHierarchyCreator.assertFalse((boolean)node.isNodeType("nt:folder"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestNodeHierarchyCreator.assertTrue((node.isNodeType("exo:privilegeable") || node.canAddMixin("exo:privilegeable") ? 1 : 0) != 0);
        node = (Node)this.session.getItem("/Users");
        TestNodeHierarchyCreator.assertNotNull((Object)node);
        TestNodeHierarchyCreator.assertFalse((boolean)node.isNodeType("nt:folder"));
        TestNodeHierarchyCreator.assertTrue((boolean)node.canAddMixin("mix:referenceable"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestNodeHierarchyCreator.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestNodeHierarchyCreator.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("*:/platform/administrators"));
        node = (Node)this.session.getItem("/Groups/Path/Home");
        TestNodeHierarchyCreator.assertNotNull((Object)node);
        TestNodeHierarchyCreator.assertTrue((boolean)node.isNodeType("nt:unstructured"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestNodeHierarchyCreator.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestNodeHierarchyCreator.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("*:/platform/administrators"));
        TestNodeHierarchyCreator.assertTrue((boolean)node.getParent().isNodeType("nt:unstructured"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.getParent().canAddMixin("mix:referenceable"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.getParent().canAddMixin("exo:privilegeable"));
        TestNodeHierarchyCreator.assertTrue((boolean)((ExtendedNode)node.getParent()).getACL().hasPermissions());
        TestNodeHierarchyCreator.assertNotNull((Object)((ExtendedNode)node.getParent()).getACL().getPermissions("*:/platform/administrators"));
        TestNodeHierarchyCreator.assertTrue((boolean)node.getParent().getParent().isNodeType("nt:unstructured"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.getParent().getParent().canAddMixin("mix:referenceable"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.getParent().getParent().canAddMixin("exo:privilegeable"));
        TestNodeHierarchyCreator.assertTrue((boolean)((ExtendedNode)node.getParent().getParent()).getACL().hasPermissions());
        TestNodeHierarchyCreator.assertNotNull((Object)((ExtendedNode)node.getParent().getParent()).getACL().getPermissions("*:/platform/administrators"));
    }

    public void testGetUserNode() throws Exception {
        Node node = this.creator.getUserNode(this.sessionProvider, "foo");
        TestNodeHierarchyCreator.assertNotNull((Object)node);
        TestNodeHierarchyCreator.assertTrue((boolean)node.getPath().startsWith("/Users"));
    }

    public void testGetUserNodeLink() throws Exception {
        Node node = this.creator.getUserNode(this.sessionProvider, "foo");
        TestNodeHierarchyCreator.assertNotNull((Object)node);
        TestNodeHierarchyCreator.assertTrue((boolean)node.hasNode("Private/Public"));
    }

    public void testGetUserApplicationNode() throws Exception {
        UserImpl user = new UserImpl("foo");
        this.userListener.preSave((User)user, true);
        Node node = this.creator.getUserApplicationNode(this.sessionProvider, "foo");
        TestNodeHierarchyCreator.assertNotNull((Object)node);
        TestNodeHierarchyCreator.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestNodeHierarchyCreator.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestNodeHierarchyCreator.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("*:/platform/administrators"));
        Node parentNode = this.creator.getUserNode(this.sessionProvider, "foo");
        TestNodeHierarchyCreator.assertNotNull((Object)parentNode);
        TestNodeHierarchyCreator.assertTrue((boolean)node.getPath().startsWith(parentNode.getPath()));
        TestNodeHierarchyCreator.assertNotNull((Object)this.session.getItem(node.getPath()));
        this.userListener.preDelete((User)user);
        try {
            this.session.getItem(node.getPath());
            TestNodeHierarchyCreator.fail((String)"A PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testGroupsNode() throws Exception {
        GroupImpl group1 = new GroupImpl("platform");
        GroupImpl group2 = new GroupImpl();
        group2.setId("/platform/users");
        GroupImpl group3 = new GroupImpl("my-group-name2");
        group3.setParentId("/platform");
        this.groupListener.preSave((Group)group1, true);
        Node node = (Node)this.session.getItem("/Groups/Path/Home/" + group1.getGroupName());
        TestNodeHierarchyCreator.assertNotNull((Object)node);
        node = node.getNode("ApplicationData");
        TestNodeHierarchyCreator.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestNodeHierarchyCreator.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestNodeHierarchyCreator.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("*:/platform/administrators"));
        this.groupListener.preSave((Group)group2, true);
        node = (Node)this.session.getItem("/Groups/Path/Home" + group2.getId());
        TestNodeHierarchyCreator.assertNotNull((Object)node);
        node = node.getNode("ApplicationData");
        TestNodeHierarchyCreator.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestNodeHierarchyCreator.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestNodeHierarchyCreator.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("*:/platform/administrators"));
        this.groupListener.preDelete((Group)group2);
        try {
            this.session.getItem("/Groups/Path/Home" + group2.getId());
            TestNodeHierarchyCreator.fail((String)"A PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        this.groupListener.preSave((Group)group3, true);
        node = (Node)this.session.getItem("/Groups/Path/Home" + group3.getParentId() + "/" + group3.getGroupName());
        TestNodeHierarchyCreator.assertNotNull((Object)node);
        node = node.getNode("ApplicationData");
        TestNodeHierarchyCreator.assertTrue((boolean)node.isNodeType("nt:folder"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("mix:referenceable"));
        TestNodeHierarchyCreator.assertFalse((boolean)node.canAddMixin("exo:privilegeable"));
        TestNodeHierarchyCreator.assertTrue((boolean)((ExtendedNode)node).getACL().hasPermissions());
        TestNodeHierarchyCreator.assertNotNull((Object)((ExtendedNode)node).getACL().getPermissions("*:/platform/administrators"));
        this.groupListener.preDelete((Group)group3);
        try {
            this.session.getItem("/Groups/Path/Home" + group3.getParentId() + "/" + group3.getGroupName());
            TestNodeHierarchyCreator.fail((String)"A PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        this.groupListener.preDelete((Group)group1);
        try {
            this.session.getItem("/Groups/Path/Home/" + group1.getGroupName());
            TestNodeHierarchyCreator.fail((String)"A PathNotFoundException is expected");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testIsNodeHierarchyCreatorInitialized() {
        TestNodeHierarchyCreator.assertTrue((boolean)this.creator.isNodeHierarchyCreatorInitialized());
    }
}

