/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import javax.jcr.Node;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.resource.JcrURLConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JcrURLConnectionTest
extends BaseStandaloneTest {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.JcrURLConnectionTest");
    private String fname;
    private String data;
    private Node testRoot;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        JcrURLConnectionTest.assertNotNull((Object)System.getProperty("java.protocol.handler.pkgs"));
        this.fname = "" + System.currentTimeMillis();
        this.data = "Test JCR urls " + this.fname;
        this.testRoot = this.root.addNode("testRoot", "nt:unstructured");
        Node file = this.testRoot.addNode(this.fname, "nt:file");
        Node d = file.addNode("jcr:content", "nt:resource");
        d.setProperty("jcr:mimeType", "text/plain");
        d.setProperty("jcr:lastModified", Calendar.getInstance());
        d.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(this.data.getBytes()));
        this.session.save();
    }

    public void testURL() throws Exception {
        URL url = new URL("jcr://exo:exo@db1/ws/#/jcr:system/");
        JcrURLConnectionTest.assertEquals((String)"jcr", (String)url.getProtocol());
        JcrURLConnectionTest.assertEquals((String)"exo:exo", (String)url.getUserInfo());
        JcrURLConnectionTest.assertEquals((String)"exo:exo@db1", (String)url.getAuthority());
        JcrURLConnectionTest.assertEquals((String)"db1", (String)url.getHost());
        JcrURLConnectionTest.assertEquals((String)"/ws/", (String)url.getPath());
        JcrURLConnectionTest.assertEquals((String)"/jcr:system/", (String)url.getRef());
    }

    public void testNodeRepresentation() throws Exception {
        URL url = new URL("jcr://db1/ws/#/testRoot/");
        JcrURLConnection conn = (JcrURLConnection)url.openConnection();
        conn.setDoOutput(false);
        Node content = (Node)conn.getContent();
        InputStream in = conn.getInputStream();
        JcrURLConnectionTest.assertEquals((String)"text/xml", (String)conn.getContentType());
        JcrURLConnectionTest.assertEquals((String)"testRoot", (String)content.getName());
        JcrURLConnectionTest.assertEquals((String)"/testRoot", (String)content.getPath());
        byte[] b = new byte[8192];
        in.read(b);
        in.close();
    }

    public void testNtFileNodeRepresentation() throws Exception {
        URL url = new URL("jcr://db1/ws/#/testRoot/" + this.fname + "/");
        JcrURLConnection conn = (JcrURLConnection)url.openConnection();
        conn.setDoOutput(false);
        JcrURLConnectionTest.assertEquals((String)"text/plain", (String)conn.getContentType());
        this.compareStream(conn.getInputStream(), new ByteArrayInputStream(this.data.getBytes()));
    }
}

