/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.ext.backup.BackupChain;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChain;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChainLog;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupConfig;
import org.exoplatform.services.jcr.ext.backup.impl.BackupMessage;
import org.exoplatform.services.jcr.ext.backup.impl.JobRepositoryRestore;
import org.exoplatform.services.jcr.ext.backup.impl.JobWorkspaceRestore;

public interface BackupManager {
    public static final int FULL_BACKUP_ONLY = 0;
    public static final int FULL_AND_INCREMENTAL = 1;

    public Set<BackupChain> getCurrentBackups();

    public Set<RepositoryBackupChain> getCurrentRepositoryBackups();

    public List<JobWorkspaceRestore> getRestores();

    public JobWorkspaceRestore getLastRestore(String var1, String var2);

    public List<JobRepositoryRestore> getRepositoryRestores();

    public JobRepositoryRestore getLastRepositoryRestore(String var1);

    public BackupChainLog[] getBackupsLogs();

    public RepositoryBackupChainLog[] getRepositoryBackupsLogs();

    public BackupChain startBackup(BackupConfig var1) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException;

    public void stopBackup(BackupChain var1);

    public BackupChain findBackup(String var1, String var2);

    public BackupChain findBackup(String var1);

    public void restore(BackupChainLog var1, String var2, WorkspaceEntry var3, boolean var4) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException;

    public BackupMessage[] getMessages();

    public File getBackupDirectory();

    public String getFullBackupType();

    public String getIncrementalBackupType();

    public long getDefaultIncrementalJobPeriod();

    public RepositoryBackupChain startBackup(RepositoryBackupConfig var1) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException;

    public void stopBackup(RepositoryBackupChain var1);

    public void restore(RepositoryBackupChainLog var1, RepositoryEntry var2, Map<String, String> var3, boolean var4) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException;

    public void restore(RepositoryBackupChainLog var1, RepositoryEntry var2, boolean var3) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException;

    public void restore(RepositoryBackupChainLog var1, RepositoryEntry var2, boolean var3, boolean var4) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException;

    public RepositoryBackupChain findRepositoryBackup(String var1);

    public RepositoryBackupChain findRepositoryBackupId(String var1);
}

