/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.config.WorkspaceInitializerEntry;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BaseRDBMSBackupTest;
import org.exoplatform.services.jcr.ext.backup.impl.rdbms.FullBackupJob;
import org.exoplatform.services.jcr.ext.backup.impl.rdbms.RdbmsWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.util.TesterConfigurationHelper;
import org.exoplatform.services.jcr.util.TesterRdbmsWorkspaceInitializer;

public class TestRdbmsWorkspaceInitializer
extends BaseRDBMSBackupTest {
    TesterConfigurationHelper helper = TesterConfigurationHelper.getInstance();

    public void testRDBMSInitializerRestoreTablesMultiDB() throws Exception {
        block0: {
            WorkspaceEntry workspaceEntry;
            FullBackupJob job = new FullBackupJob();
            BackupConfig config = new BackupConfig();
            config.setRepository("db1");
            config.setWorkspace("ws1");
            config.setBackupDir(new File("target/backup/testJob/testRDBMSInitializerRestoreTablesMultiDB"));
            Calendar calendar = Calendar.getInstance();
            job.init(this.repositoryService.getRepository("db1"), "ws1", config, calendar);
            job.run();
            URL url = job.getStorageURL();
            Iterator iterator = this.repositoryService.getRepository("db1").getConfiguration().getWorkspaceEntries().iterator();
            if (!iterator.hasNext() || !(workspaceEntry = (WorkspaceEntry)iterator.next()).getName().equals("ws1")) break block0;
            String dsName = this.helper.createDatasource();
            WorkspaceEntry newEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, dsName, this.helper.getValueStorageIds(workspaceEntry.getContainer().getValueStorages()));
            ArrayList<SimpleParameterEntry> wieParams = new ArrayList<SimpleParameterEntry>();
            wieParams.add(new SimpleParameterEntry("restore-path", new File(url.getFile()).getParent()));
            WorkspaceInitializerEntry wiEntry = new WorkspaceInitializerEntry();
            wiEntry.setType(RdbmsWorkspaceInitializer.class.getCanonicalName());
            wiEntry.setParameters(wieParams);
            newEntry.setInitializer(wiEntry);
            this.helper.addWorkspace(this.repositoryService.getRepository("db1"), newEntry);
            dsName = this.helper.createDatasource();
            newEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, dsName, this.helper.getValueStorageIds(workspaceEntry.getContainer().getValueStorages()));
            wieParams = new ArrayList();
            wieParams.add(new SimpleParameterEntry("restore-path", new File(url.getFile()).getParent()));
            wiEntry = new WorkspaceInitializerEntry();
            wiEntry.setType(RdbmsWorkspaceInitializer.class.getCanonicalName());
            wiEntry.setParameters(wieParams);
            newEntry.setInitializer(wiEntry);
            this.helper.addWorkspace(this.repositoryService.getRepository("db1"), newEntry);
            String newIndexPath = newEntry.getQueryHandler().getParameterValue("index-dir");
            String newValueStoragePath = ((ValueStorageEntry)newEntry.getContainer().getValueStorages().get(0)).getParameterValue("path");
            TestRdbmsWorkspaceInitializer.assertFalse((boolean)new File(newValueStoragePath).exists());
            TestRdbmsWorkspaceInitializer.assertTrue((new File(newIndexPath).list().length > 0 ? 1 : 0) != 0);
            TestRdbmsWorkspaceInitializer.assertFalse((boolean)new File(newIndexPath + "_system").exists());
        }
    }

    public void testRDBMSInitializerRestoreTablesSingleDB() throws Exception {
        block0: {
            WorkspaceEntry workspaceEntry;
            FullBackupJob job = new FullBackupJob();
            BackupConfig config = new BackupConfig();
            config.setRepository("db3");
            config.setWorkspace("ws");
            config.setBackupDir(new File("target/backup/testJob/testRDBMSInitializerRestoreTablesSingleDB"));
            Calendar calendar = Calendar.getInstance();
            job.init(this.repositoryService.getRepository("db3"), "ws1", config, calendar);
            job.run();
            URL url = job.getStorageURL();
            Iterator iterator = this.repositoryService.getRepository("db3").getConfiguration().getWorkspaceEntries().iterator();
            if (!iterator.hasNext() || !(workspaceEntry = (WorkspaceEntry)iterator.next()).getName().equals("ws1")) break block0;
            String dsName = this.helper.createDatasource();
            WorkspaceEntry newEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, dsName, this.helper.getValueStorageIds(workspaceEntry.getContainer().getValueStorages()));
            ArrayList<SimpleParameterEntry> wieParams = new ArrayList<SimpleParameterEntry>();
            wieParams.add(new SimpleParameterEntry("restore-path", new File(url.getFile()).getParent()));
            WorkspaceInitializerEntry wiEntry = new WorkspaceInitializerEntry();
            wiEntry.setType(RdbmsWorkspaceInitializer.class.getCanonicalName());
            wiEntry.setParameters(wieParams);
            newEntry.setInitializer(wiEntry);
            TesterRdbmsWorkspaceInitializer initializer = new TesterRdbmsWorkspaceInitializer(newEntry, this.repositoryService.getRepository("db3").getConfiguration(), this.cacheableDataManager, null, null, null, (ValueFactoryImpl)this.valueFactory, null, this.repositoryService);
            this.helper.addWorkspace(this.repositoryService.getRepository("db1"), newEntry);
            dsName = this.helper.createDatasource();
            newEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, dsName, this.helper.getValueStorageIds(workspaceEntry.getContainer().getValueStorages()));
            wieParams = new ArrayList();
            wieParams.add(new SimpleParameterEntry("restore-path", new File(url.getFile()).getParent()));
            wiEntry = new WorkspaceInitializerEntry();
            wiEntry.setType(RdbmsWorkspaceInitializer.class.getCanonicalName());
            wiEntry.setParameters(wieParams);
            newEntry.setInitializer(wiEntry);
            this.helper.addWorkspace(this.repositoryService.getRepository("db1"), newEntry);
            String newIndexPath = newEntry.getQueryHandler().getParameterValue("index-dir");
            String newValueStoragePath = ((ValueStorageEntry)newEntry.getContainer().getValueStorages().get(0)).getParameterValue("path");
            TestRdbmsWorkspaceInitializer.assertFalse((boolean)new File(newValueStoragePath).exists());
            TestRdbmsWorkspaceInitializer.assertTrue((new File(newIndexPath).list().length > 0 ? 1 : 0) != 0);
            TestRdbmsWorkspaceInitializer.assertFalse((boolean)new File(newIndexPath + "_system").exists());
        }
    }
}

