/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup;

import junit.framework.TestCase;
import org.exoplatform.services.jcr.ext.backup.RepositoryChainLogPathHelper;

public class TestRepositoryChainLogPathHelper
extends TestCase {
    public void testGetRelativePathOSLinux() throws Exception {
        String path = "/path/to/repository-backup-dir/workspace-backup-dir/workspace-backup-log.xml";
        String backupDirCanonicalPath = "/path/to/repository-backup-dir";
        String relativePath = RepositoryChainLogPathHelper.getRelativePath((String)path, (String)backupDirCanonicalPath);
        TestRepositoryChainLogPathHelper.assertEquals((String)"workspace-backup-dir/workspace-backup-log.xml", (String)relativePath);
    }

    public void testGetRelativePathOSWindows() throws Exception {
        String path = "c:\\\\path\\to\\repository-backup-dir\\workspace-backup-dir\\workspace-backup-log.xml";
        String backupDirCanonicalPath = "c:\\\\path\\to\\repository-backup-dir";
        String relativePath = RepositoryChainLogPathHelper.getRelativePath((String)path, (String)backupDirCanonicalPath);
        TestRepositoryChainLogPathHelper.assertEquals((String)"workspace-backup-dir/workspace-backup-log.xml", (String)relativePath);
    }

    public void testGetPathOSLinux() throws Exception {
        String relativePath = "workspace-backup-dir/workspace-backup-log.xml";
        String backupDirCanonicalPath = "/path/to/repository-backup-dir";
        String path = RepositoryChainLogPathHelper.getPath((String)relativePath, (String)backupDirCanonicalPath);
        TestRepositoryChainLogPathHelper.assertEquals((String)"/path/to/repository-backup-dir/workspace-backup-dir/workspace-backup-log.xml", (String)path);
    }

    public void testGetPathOSWindiws() throws Exception {
        String relativePath = "workspace-backup-dir/workspace-backup-log.xml";
        String backupDirCanonicalPath = "c:\\\\path\\to\\repository-backup-dir";
        String path = RepositoryChainLogPathHelper.getPath((String)relativePath, (String)backupDirCanonicalPath);
        TestRepositoryChainLogPathHelper.assertEquals((String)"/c://path/to/repository-backup-dir/workspace-backup-dir/workspace-backup-log.xml", (String)path);
    }
}

