/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.common;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.Session;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;

public class DynamicSessionProviderTest
extends BaseStandaloneTest {
    private NodeImpl testRoot;
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.DynamicTest");

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testRoot = (NodeImpl)this.root.addNode("testDynamicSession");
        this.root.save();
    }

    public void testDynamicSession() throws Exception {
        NodeImpl maryNodeDynamic2;
        NodeImpl maryNode = (NodeImpl)this.testRoot.addNode("mary_dynamic");
        maryNode.addMixin("exo:privilegeable");
        if (!this.session.getUserID().equals("mary")) {
            maryNode.setPermission("*:/platform/users", new String[]{"read"});
            maryNode.setPermission("mary", PermissionType.ALL);
            maryNode.removePermission(this.session.getUserID());
        }
        maryNode.removePermission(IdentityConstants.ANY);
        this.testRoot.save();
        Session marySession = this.repository.login((Credentials)new CredentialsImpl("mary", "exo".toCharArray()), this.session.getWorkspace().getName());
        NodeImpl myNode = (NodeImpl)marySession.getItem(maryNode.getPath());
        NodeImpl test = (NodeImpl)myNode.addNode("test");
        test.setProperty("property", "any data");
        myNode.save();
        marySession.logout();
        ArrayList<AccessControlEntry> accessControlEntries = new ArrayList<AccessControlEntry>();
        accessControlEntries.add(new AccessControlEntry("*:/platform/administrators", "READ"));
        SessionProvider dynamicProvider = SessionProvider.createProvider(accessControlEntries);
        Session dynamicSession = null;
        try {
            dynamicSession = dynamicProvider.getSession(this.session.getWorkspace().getName(), (ManageableRepository)this.repository);
            maryNodeDynamic2 = (NodeImpl)dynamicSession.getItem(maryNode.getPath());
            DynamicSessionProviderTest.fail((String)"Dynamic session with membership '*:/platform/users' should not read node with membership '*:/platform/users'");
        }
        catch (AccessDeniedException maryNodeDynamic2) {
            // empty catch block
        }
        accessControlEntries = new ArrayList();
        accessControlEntries.add(new AccessControlEntry("*:/platform/users", "READ"));
        dynamicProvider = SessionProvider.createProvider(accessControlEntries);
        try {
            dynamicSession = dynamicProvider.getSession(this.session.getWorkspace().getName(), (ManageableRepository)this.repository);
            maryNodeDynamic2 = (NodeImpl)dynamicSession.getItem(maryNode.getPath());
        }
        catch (AccessDeniedException e) {
            e.printStackTrace();
            DynamicSessionProviderTest.fail((String)("Dynamic session with membership '*:/platform/users' should read node with membership '*:/platform/users'. Exception message :" + e.getMessage()));
        }
        try {
            dynamicSession = dynamicProvider.getSession(this.session.getWorkspace().getName(), (ManageableRepository)this.repository);
            maryNodeDynamic2 = (NodeImpl)dynamicSession.getItem(maryNode.getPath());
            maryNodeDynamic2.addNode("test2");
            maryNodeDynamic2.save();
            DynamicSessionProviderTest.fail((String)"Dynamic session with membership '*:/platform/users' should be not add child node with membership '*:/platform/users READ'");
        }
        catch (AccessDeniedException maryNodeDynamic3) {
            // empty catch block
        }
        try {
            dynamicSession = dynamicProvider.getSession(this.session.getWorkspace().getName(), (ManageableRepository)this.repository);
            maryNodeDynamic2 = (NodeImpl)dynamicSession.getItem(maryNode.getPath());
            maryNodeDynamic2.getNode("test").remove();
            maryNodeDynamic2.save();
            DynamicSessionProviderTest.fail((String)"Dynamic session with membership '*:/platform/users' should be not remove child node with membership '*:/platform/users READ'");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testCreateSystemSessionProviderAfterDynamic() throws Exception {
        NodeImpl systemNode = (NodeImpl)this.testRoot.addNode("system_dynamic");
        systemNode.addMixin("exo:privilegeable");
        systemNode.setPermission("*:/platform/users", new String[]{"read"});
        systemNode.removePermission(this.session.getUserID());
        this.testRoot.save();
        ArrayList<AccessControlEntry> accessControlEntries = new ArrayList<AccessControlEntry>();
        accessControlEntries.add(new AccessControlEntry("*:/platform/users", "READ"));
        SessionProvider dynamicProvider = SessionProvider.createProvider(accessControlEntries);
        Session dynamicSession = null;
        try {
            dynamicSession = dynamicProvider.getSession(this.session.getWorkspace().getName(), (ManageableRepository)this.repository);
            NodeImpl nodeImpl = (NodeImpl)dynamicSession.getItem(systemNode.getPath());
        }
        catch (AccessDeniedException e) {
            e.printStackTrace();
            DynamicSessionProviderTest.fail((String)("Dynamic session with membership '*:/platform/users' should read node with membership '*:/platform/users'. Exception message : " + e.getMessage()));
        }
        SessionProvider systemProvider = SessionProvider.createSystemProvider();
        Session systemSession = null;
        try {
            systemSession = systemProvider.getSession(this.session.getWorkspace().getName(), (ManageableRepository)this.repository);
            NodeImpl nodeImpl = (NodeImpl)systemSession.getItem(systemNode.getPath());
        }
        catch (AccessDeniedException e) {
            e.printStackTrace();
            DynamicSessionProviderTest.fail((String)("System session should read node with membership '*:/platform/users'. Exception message : " + e.getMessage()));
        }
        try {
            systemSession = systemProvider.getSession(this.session.getWorkspace().getName(), (ManageableRepository)this.repository);
            NodeImpl systemNodeOverSystemSession = (NodeImpl)systemSession.getItem(systemNode.getPath());
            systemNodeOverSystemSession.remove();
            systemSession.save();
        }
        catch (AccessDeniedException e) {
            DynamicSessionProviderTest.fail((String)"System session should remove node with membership '*:/platform/users'.");
        }
    }
}

