/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.repository.creation.cluster;

import java.io.File;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.backup.AbstractBackupTestCase;
import org.exoplatform.services.jcr.ext.backup.ExtendedBackupManager;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChain;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupConfig;
import org.exoplatform.services.jcr.ext.repository.creation.DBCreationProperties;
import org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationException;
import org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationService;
import org.exoplatform.services.jcr.ext.repository.creation.StorageCreationProperties;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;

public class TestRepositoryCreationServiceInClusterNode1
extends AbstractBackupTestCase {
    public void testCreateRepositorySingleDBWithSpecificCreationProps() throws Exception {
        Thread.sleep(60000L);
        HashMap<String, String> connProps = new HashMap<String, String>();
        connProps.put("driverClassName", "com.mysql.jdbc.Driver");
        connProps.put("username", "root");
        connProps.put("password", "24635457");
        DBCreationProperties creationProps = new DBCreationProperties("jdbc:mysql://localhost/", connProps, "src/test/resources/test-mysql.sql", "user3", "pass3");
        String dsName = this.helper.createDatasource();
        ManageableRepository repository = this.helper.createRepository((ExoContainer)this.container, JDBCDataContainerConfig.DatabaseStructureType.SINGLE, dsName);
        WorkspaceEntry wsEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.SINGLE, dsName);
        this.helper.addWorkspace(repository, wsEntry);
        this.addConent(repository, wsEntry.getName());
        File backDir = new File("target/backup");
        backDir.mkdirs();
        RepositoryBackupConfig config = new RepositoryBackupConfig();
        config.setRepository(repository.getConfiguration().getName());
        config.setBackupType(0);
        config.setBackupDir(backDir);
        RepositoryBackupChain bch = this.backup.startBackup(config);
        this.waitEndOfBackup(bch);
        this.backup.stopBackup(bch);
        RepositoryCreationService creatorService = (RepositoryCreationService)this.container.getComponentInstanceOfType(RepositoryCreationService.class);
        TestRepositoryCreationServiceInClusterNode1.assertNotNull((Object)creatorService);
        String tenantName = "tenant_4";
        String repoToken = creatorService.reserveRepositoryName(tenantName);
        RepositoryEntry newRE = this.helper.createRepositoryEntry(JDBCDataContainerConfig.DatabaseStructureType.SINGLE, repository.getConfiguration().getSystemWorkspaceName(), tenantName);
        newRE.setName(tenantName);
        WorkspaceEntry newWSEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.SINGLE, tenantName);
        newWSEntry.setName(wsEntry.getName());
        newRE.addWorkspace(newWSEntry);
        creatorService.createRepository(bch.getBackupId(), newRE, repoToken, (StorageCreationProperties)creationProps);
        ManageableRepository restoredRepository = this.repositoryService.getRepository(tenantName);
        TestRepositoryCreationServiceInClusterNode1.assertNotNull((Object)restoredRepository);
        this.checkConent(restoredRepository, wsEntry.getName());
        RepositoryService repoService = (RepositoryService)this.container.getComponentInstance(RepositoryService.class);
        TestRepositoryCreationServiceInClusterNode1.assertNotNull((Object)repoService.getConfig().getRepositoryConfiguration(tenantName));
        Thread.sleep(60000L);
        try {
            creatorService.removeRepository(tenantName, false);
            TestRepositoryCreationServiceInClusterNode1.fail((String)"Exception should be thrown");
        }
        catch (RepositoryCreationException repositoryCreationException) {
            // empty catch block
        }
        creatorService.removeRepository(tenantName, true);
        try {
            repoService.getRepository(tenantName);
            TestRepositoryCreationServiceInClusterNode1.fail((String)"Exception should be thrown");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    protected ExtendedBackupManager getBackupManager() {
        return this.getRDBMSBackupManager();
    }
}

