/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import javax.jcr.Node;
import javax.ws.rs.core.Response;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentation;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationService;
import org.exoplatform.services.jcr.ext.resource.XMLViewNodeRepresentationRenderer;
import org.exoplatform.services.jcr.ext.resource.representation.NtFileNodeRepresentation;
import org.exoplatform.services.jcr.ext.resource.representation.NtFileNodeRepresentationFactory;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class NodeRepresentationTest
extends BaseStandaloneTest {
    private NodeRepresentationService nodeRepresentationService;
    private NtFileNodeRepresentationFactory ntFileNodeRepresentationFactory;
    private Node testRoot;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        SessionProviderService sesProv = (SessionProviderService)this.container.getComponentInstanceOfType(SessionProviderService.class);
        sesProv.setSessionProvider(null, new SessionProvider(new ConversationState(new Identity(this.session.getUserID()))));
        this.nodeRepresentationService = (NodeRepresentationService)this.container.getComponentInstanceOfType(NodeRepresentationService.class);
        NodeRepresentationTest.assertNotNull((Object)this.nodeRepresentationService);
        this.ntFileNodeRepresentationFactory = (NtFileNodeRepresentationFactory)this.container.getComponentInstanceOfType(NtFileNodeRepresentationFactory.class);
        NodeRepresentationTest.assertNotNull((Object)this.ntFileNodeRepresentationFactory);
        if (!this.root.hasNode("NodeRepresentationTest")) {
            this.testRoot = this.root.addNode("NodeRepresentationTest", "nt:unstructured");
            this.root.save();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.testRoot.remove();
        this.session.save();
        super.tearDown();
    }

    public void testServiceInitialization() throws Exception {
        Collection nts = this.nodeRepresentationService.getNodeTypes();
        NodeRepresentationTest.assertTrue((nts.size() > 0 ? 1 : 0) != 0);
        NodeRepresentationTest.assertTrue((boolean)nts.contains("nt:file"));
        NodeRepresentationTest.assertTrue((boolean)nts.contains("nt:resource"));
    }

    public void testNtFileNodeRepresentation() throws Exception {
        String data = "Test JCR";
        Node file = this.testRoot.addNode("file", "nt:file");
        Node d = file.addNode("jcr:content", "nt:resource");
        d.setProperty("jcr:mimeType", "text/plain");
        d.setProperty("jcr:lastModified", Calendar.getInstance());
        d.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(data.getBytes()));
        this.session.save();
        NodeRepresentation nodeRepresentation = this.nodeRepresentationService.getNodeRepresentation(file, "text/plain");
        NodeRepresentationTest.assertNotNull((Object)nodeRepresentation);
        NodeRepresentationTest.assertTrue((boolean)(nodeRepresentation instanceof NtFileNodeRepresentation));
        NodeRepresentationTest.assertEquals((int)3, (int)nodeRepresentation.getPropertyNames().size());
        this.compareStream(nodeRepresentation.getInputStream(), new ByteArrayInputStream(data.getBytes()));
    }

    public void testSysViewRepresentation() throws Exception {
        XMLViewNodeRepresentationRenderer sysView = (XMLViewNodeRepresentationRenderer)this.container.getComponentInstanceOfType(XMLViewNodeRepresentationRenderer.class);
        NodeRepresentationTest.assertNotNull((Object)sysView);
        Response resp = sysView.getXML(this.repositoryService.getDefaultRepository().getConfiguration().getName(), this.workspace.getName() + "/", "doc", null);
        NodeRepresentationTest.assertEquals((int)200, (int)resp.getStatus());
    }
}

