/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import groovy.lang.GroovyObject;
import groovy.lang.GroovyResourceLoader;
import java.net.URL;
import java.util.ArrayList;
import javax.jcr.Node;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.jcr.ext.script.groovy.BaseGroovyTest;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyClassLoaderProvider;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyCompiler;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyResourceLoader;
import org.exoplatform.services.rest.ext.groovy.SourceFolder;

public class GroovyCompilerTest
extends BaseGroovyTest {
    private Node groovyRepo;
    private Node otherGroovyRepo;
    private String scriptA;
    private String scriptB;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.groovyRepo = this.root.addNode("groovyRepo", "nt:folder");
        this.otherGroovyRepo = this.root.addNode("otherGroovyRepo", "nt:folder");
        this.scriptA = this.createScript(this.groovyRepo, "org.exoplatform", "A.groovy", "package org.exoplatform\nclass A { String message = 'groovy compiler test' }");
        this.scriptB = this.createScript(this.groovyRepo, "org.exoplatform.test", "B.groovy", "package org.exoplatform.test\nimport org.exoplatform.A\nclass B extends A {}");
    }

    public void testSnaredDependencies() throws Exception {
        JcrGroovyClassLoaderProvider classLoaderProvider = new JcrGroovyClassLoaderProvider();
        classLoaderProvider.getGroovyClassLoader().setResourceLoader((GroovyResourceLoader)new JcrGroovyResourceLoader(new URL[]{new URL("jcr://db1/ws#/groovyRepo")}));
        JcrGroovyCompiler compiler = new JcrGroovyCompiler(classLoaderProvider);
        Class[] classes = compiler.compile(new UnifiedNodeReference[]{new UnifiedNodeReference("db1", "ws", this.scriptB)});
        GroovyCompilerTest.assertEquals((int)1, (int)classes.length);
        GroovyObject go = (GroovyObject)classes[0].newInstance();
        GroovyCompilerTest.assertEquals((Object)"groovy compiler test", (Object)go.invokeMethod("getMessage", (Object)new Object[0]));
    }

    public void testDependenciesBetweenCompiled() throws Exception {
        JcrGroovyClassLoaderProvider classLoaderProvider = new JcrGroovyClassLoaderProvider();
        JcrGroovyCompiler compiler = new JcrGroovyCompiler(classLoaderProvider);
        Class[] classes = compiler.compile(new UnifiedNodeReference[]{new UnifiedNodeReference("db1", "ws", this.scriptB), new UnifiedNodeReference("db1", "ws", this.scriptA)});
        GroovyCompilerTest.assertEquals((int)2, (int)classes.length);
        GroovyObject go = (GroovyObject)classes[0].newInstance();
        GroovyCompilerTest.assertEquals((Object)"groovy compiler test", (Object)go.invokeMethod("getMessage", (Object)new Object[0]));
        go = (GroovyObject)classes[1].newInstance();
        GroovyCompilerTest.assertEquals((Object)"groovy compiler test", (Object)go.invokeMethod("getMessage", (Object)new Object[0]));
    }

    public void testAddDependenciesInRuntime() throws Exception {
        JcrGroovyClassLoaderProvider classLoaderProvider = new JcrGroovyClassLoaderProvider();
        JcrGroovyCompiler compiler = new JcrGroovyCompiler(classLoaderProvider);
        SourceFolder[] src = new SourceFolder[]{new SourceFolder(new UnifiedNodeReference("db1", "ws", this.groovyRepo.getPath()).getURL())};
        Class[] classes = compiler.compile(src, new UnifiedNodeReference[]{new UnifiedNodeReference("db1", "ws", this.scriptB)});
        GroovyCompilerTest.assertEquals((int)1, (int)classes.length);
        GroovyObject go = (GroovyObject)classes[0].newInstance();
        GroovyCompilerTest.assertEquals((Object)"groovy compiler test", (Object)go.invokeMethod("getMessage", (Object)new Object[0]));
    }

    public void testCombinedDependencies() throws Exception {
        String scriptC = this.createScript(this.otherGroovyRepo, "org.exoplatform", "C", "package org.exoplatform.test\nimport org.exoplatform.*\nclass C extends B {}");
        String scriptD = this.createScript(this.otherGroovyRepo, "org.exoplatform.test.other", "D.groovy", "package org.exoplatform.test.other\nimport org.exoplatform.test.C\nclass D extends C {}");
        JcrGroovyClassLoaderProvider classLoaderProvider = new JcrGroovyClassLoaderProvider();
        classLoaderProvider.getGroovyClassLoader().setResourceLoader((GroovyResourceLoader)new JcrGroovyResourceLoader(new URL[]{new URL("jcr://db1/ws#/groovyRepo")}));
        JcrGroovyCompiler compiler = new JcrGroovyCompiler(classLoaderProvider);
        Class[] classes = compiler.compile(new UnifiedNodeReference[]{new UnifiedNodeReference("db1", "ws", scriptD), new UnifiedNodeReference("db1", "ws", scriptC)});
        GroovyCompilerTest.assertEquals((int)2, (int)classes.length);
        ArrayList<String> names = new ArrayList<String>(2);
        for (Class c : classes) {
            names.add(c.getName());
        }
        GroovyCompilerTest.assertTrue((boolean)names.contains("org.exoplatform.test.C"));
        GroovyCompilerTest.assertTrue((boolean)names.contains("org.exoplatform.test.other.D"));
    }
}

