/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.registry;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.security.ConversationState;
import org.w3c.dom.Document;

public class RegistryTest
extends BaseStandaloneTest {
    private SessionProviderService sessionProviderService;
    private static final String SERVICE_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><exo_service xmlns:jcr=\"http://www.jcp.org/jcr/1.0\" jcr:primaryType=\"exo:registryEntry\"/>";
    private static final String NAV_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><node-navigation><owner-type>portal</owner-type><owner-id>portalone</owner-id><access-permissions>*:/guest</access-permissions><page-nodes><node><uri>portalone::home</uri><name>home</name><label>Home</label><page-reference>portal::portalone::content</page-reference></node><node><uri>portalone::register</uri><name>register</name><label>Register</label><page-reference>portal::portalone::register</page-reference></node></page-nodes></node-navigation>";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sessionProviderService = (SessionProviderService)this.container.getComponentInstanceOfType(SessionProviderService.class);
        this.sessionProviderService.setSessionProvider(null, new SessionProvider(ConversationState.getCurrent()));
    }

    public void testInit() throws Exception {
        RegistryService regService = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
        RegistryTest.assertNotNull((Object)regService);
        Node regNodes = regService.getRegistry(this.sessionProviderService.getSessionProvider(null)).getNode();
        RegistryTest.assertNotNull((Object)regNodes);
        RegistryTest.assertTrue((boolean)regNodes.hasNode("exo:services"));
        RegistryTest.assertTrue((boolean)regNodes.hasNode("exo:applications"));
        RegistryTest.assertTrue((boolean)regNodes.hasNode("exo:users"));
        RegistryTest.assertTrue((boolean)regNodes.isNodeType("exo:testFirstHideable"));
        RegistryTest.assertTrue((boolean)regNodes.isNodeType("exo:testSecondHideable"));
        RegistryTest.assertTrue((boolean)regNodes.getNode("exo:users").isNodeType("exo:testFirstHideable"));
        RegistryTest.assertTrue((boolean)regNodes.getNode("exo:users").isNodeType("exo:testSecondHideable"));
        RegistryTest.assertTrue((boolean)regNodes.getNode("exo:groups").isNodeType("exo:testFirstHideable"));
        RegistryTest.assertTrue((boolean)regNodes.getNode("exo:groups").isNodeType("exo:testSecondHideable"));
        RegistryTest.assertTrue((boolean)regNodes.getNode("exo:services").isNodeType("exo:testFirstHideable"));
        RegistryTest.assertTrue((boolean)regNodes.getNode("exo:services").isNodeType("exo:testSecondHideable"));
        RegistryTest.assertTrue((boolean)regNodes.getNode("exo:applications").isNodeType("exo:testFirstHideable"));
        RegistryTest.assertTrue((boolean)regNodes.getNode("exo:applications").isNodeType("exo:testSecondHideable"));
        this.session.getWorkspace().getNodeTypeManager().getNodeType("exo:registry");
        this.session.getWorkspace().getNodeTypeManager().getNodeType("exo:registryEntry");
        this.session.getWorkspace().getNodeTypeManager().getNodeType("exo:registryGroup");
    }

    public void testRegister() throws Exception {
        RegistryService regService = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
        try {
            regService.getEntry(this.sessionProviderService.getSessionProvider(null), "exo:users/exo_service");
            RegistryTest.fail((String)"ItemNotFoundException should have been thrown");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        regService.createEntry(this.sessionProviderService.getSessionProvider(null), "exo:users", RegistryEntry.parse((InputStream)new ByteArrayInputStream(SERVICE_XML.getBytes())));
        RegistryEntry entry = regService.getEntry(this.sessionProviderService.getSessionProvider(null), "exo:users/exo_service");
        regService.recreateEntry(this.sessionProviderService.getSessionProvider(null), "exo:users", RegistryEntry.parse((InputStream)new ByteArrayInputStream(SERVICE_XML.getBytes())));
        regService.removeEntry(this.sessionProviderService.getSessionProvider(null), "exo:users/exo_service");
        try {
            regService.getEntry(this.sessionProviderService.getSessionProvider(null), "exo:users/exo_service");
            RegistryTest.fail((String)"ItemNotFoundException should have been thrown");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRegisterToNonExistedGroup() throws Exception {
        RegistryService regService = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
        String groupPath = "exo:users/newGroup1/newGroup2";
        String entryName = "testEntry";
        try {
            regService.getEntry(this.sessionProviderService.getSessionProvider(null), groupPath + "/" + entryName);
            RegistryTest.fail((String)"ItemNotFoundException should have been thrown");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        regService.createEntry(this.sessionProviderService.getSessionProvider(null), groupPath, new RegistryEntry(entryName));
        RegistryEntry entry = regService.getEntry(this.sessionProviderService.getSessionProvider(null), groupPath + "/" + entryName);
        RegistryTest.assertNotNull((Object)entry);
        RegistryTest.assertEquals((String)entryName, (String)entry.getName());
    }

    public void testRegisterFromXMLStream() throws Exception {
        RegistryService regService = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
        String groupPath = "exo:users/testRegisterFromXMLStream";
        regService.createEntry(this.sessionProviderService.getSessionProvider(null), groupPath, RegistryEntry.parse((byte[])NAV_XML.getBytes()));
        RegistryEntry entry = regService.getEntry(this.sessionProviderService.getSessionProvider(null), groupPath + "/node-navigation");
        RegistryTest.assertEquals((String)"node-navigation", (String)entry.getName());
    }

    public void testRegisterFromDOM() throws Exception {
        RegistryService regService = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
        String groupPath = "exo:users/testRegisterFromDOM";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(new ByteArrayInputStream(NAV_XML.getBytes()));
        regService.createEntry(this.sessionProviderService.getSessionProvider(null), groupPath, new RegistryEntry(document));
        RegistryEntry entry = regService.getEntry(this.sessionProviderService.getSessionProvider(null), groupPath + "/node-navigation");
        RegistryTest.assertEquals((String)"node-navigation", (String)entry.getName());
    }

    public void testLocation() throws Exception {
        RegistryService regService = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
        regService.addRegistryLocation("wrong", "wrong");
    }

    public void testStoreAndReadXML() throws Exception {
        String category = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><category name1=\"the_value\" name2=\"the_xvalue\"></category>";
        RegistryService regService = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
        String groupPath = "exo:users/testStoreAndReadXML";
        regService.createEntry(this.sessionProviderService.getSessionProvider(null), groupPath, RegistryEntry.parse((byte[])category.getBytes()));
        RegistryEntry entry = regService.getEntry(this.sessionProviderService.getSessionProvider(null), groupPath + "/category");
        RegistryTest.assertEquals((String)"the_value", (String)entry.getDocument().getDocumentElement().getAttribute("name1"));
        RegistryTest.assertEquals((String)"the_xvalue", (String)entry.getDocument().getDocumentElement().getAttribute("name2"));
    }

    public void testCreateEntry() throws Exception {
        String[] groups;
        RegistryService regService = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CategoryData xmlns:exo=\"http://www.exoplatform.com/jcr/exo/1.0\" xmlns:jcr=\"http://www.jcp.org/jcr/1.0\"/>";
        for (String g : groups = new String[]{"aaa", "bbb", "aAaA", "bBbB", "AAA", "BBB", "aaaa"}) {
            String path = "exo:applications/ApplicationRegistry/" + g;
            regService.createEntry(this.sessionProviderService.getSessionProvider(null), path, RegistryEntry.parse((byte[])xml.getBytes()));
        }
    }

    public void testRecreateEntryContinuous() throws Exception {
        RegistryService regService = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
        String groupPath = "exo:users/navigations";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(new ByteArrayInputStream(NAV_XML.getBytes()));
        regService.createEntry(this.sessionProviderService.getSessionProvider(null), groupPath, new RegistryEntry(document));
    }

    public static class Recreater
    implements Runnable {
        StandaloneContainer container;
        SessionProvider sessionProvider;
        Document document;

        public Recreater(StandaloneContainer container, SessionProvider sessionProvider, Document document) {
            this.container = container;
            this.sessionProvider = sessionProvider;
            this.document = document;
        }

        @Override
        public void run() {
            RegistryService regService = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
            String groupPath = "exo:users/navigations";
            try {
                regService.recreateEntry(this.sessionProvider, groupPath, new RegistryEntry(this.document));
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
    }
}

