/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.repository.creation;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.backup.AbstractBackupTestCase;
import org.exoplatform.services.jcr.ext.backup.ExtendedBackupManager;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChain;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupConfig;
import org.exoplatform.services.jcr.ext.repository.creation.DBCreationProperties;
import org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationException;
import org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationService;
import org.exoplatform.services.jcr.ext.repository.creation.StorageCreationProperties;
import org.exoplatform.services.jcr.impl.checker.RepositoryCheckController;
import org.exoplatform.services.jcr.impl.proccess.WorkerThread;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.util.IdGenerator;

public class TestRepositoryCreationService
extends AbstractBackupTestCase {
    public void testCreateRepositoryMultiDB() throws Exception {
        ManageableRepository repository = this.helper.createRepository((ExoContainer)this.container, JDBCDataContainerConfig.DatabaseStructureType.MULTI, null);
        WorkspaceEntry wsEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, null);
        this.helper.addWorkspace(repository, wsEntry);
        this.addConent(repository, wsEntry.getName());
        File backDir = new File("target/backup");
        backDir.mkdirs();
        RepositoryBackupConfig config = new RepositoryBackupConfig();
        config.setRepository(repository.getConfiguration().getName());
        config.setBackupType(0);
        config.setBackupDir(backDir);
        RepositoryBackupChain bch = this.backup.startBackup(config);
        this.waitEndOfBackup(bch);
        this.backup.stopBackup(bch);
        RepositoryCreationService creatorService = (RepositoryCreationService)this.container.getComponentInstanceOfType(RepositoryCreationService.class);
        TestRepositoryCreationService.assertNotNull((Object)creatorService);
        String tenantName = "new_repository_mutli-db";
        String repoToken = creatorService.reserveRepositoryName(tenantName);
        RepositoryEntry newRE = this.helper.createRepositoryEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, repository.getConfiguration().getSystemWorkspaceName(), IdGenerator.generate());
        newRE.setName(tenantName);
        WorkspaceEntry newWSEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, IdGenerator.generate());
        newWSEntry.setName(wsEntry.getName());
        newRE.addWorkspace(newWSEntry);
        creatorService.createRepository(bch.getBackupId(), newRE, repoToken);
        ManageableRepository restoredRepository = this.repositoryService.getRepository(tenantName);
        TestRepositoryCreationService.assertNotNull((Object)restoredRepository);
        this.checkConent(restoredRepository, wsEntry.getName());
        RepositoryService repoService = (RepositoryService)this.container.getComponentInstance(RepositoryService.class);
        TestRepositoryCreationService.assertNotNull((Object)repoService.getConfig().getRepositoryConfiguration(tenantName));
        try {
            creatorService.removeRepository(tenantName, false);
            TestRepositoryCreationService.fail((String)"Exception should be thrown");
        }
        catch (RepositoryCreationException repositoryCreationException) {
            // empty catch block
        }
        creatorService.removeRepository(tenantName, true);
        try {
            repoService.getRepository(tenantName);
            TestRepositoryCreationService.fail((String)"Exception should be thrown");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testCreateRepositorySingleDB() throws Exception {
        String dsName = this.helper.createDatasource();
        ManageableRepository repository = this.helper.createRepository((ExoContainer)this.container, JDBCDataContainerConfig.DatabaseStructureType.SINGLE, dsName);
        WorkspaceEntry wsEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.SINGLE, dsName);
        this.helper.addWorkspace(repository, wsEntry);
        this.addConent(repository, wsEntry.getName());
        File backDir = new File("target/backup");
        backDir.mkdirs();
        RepositoryBackupConfig config = new RepositoryBackupConfig();
        config.setRepository(repository.getConfiguration().getName());
        config.setBackupType(0);
        config.setBackupDir(backDir);
        RepositoryBackupChain bch = this.backup.startBackup(config);
        this.waitEndOfBackup(bch);
        this.backup.stopBackup(bch);
        RepositoryCreationService creatorService = (RepositoryCreationService)this.container.getComponentInstanceOfType(RepositoryCreationService.class);
        TestRepositoryCreationService.assertNotNull((Object)creatorService);
        String tenantName = "new_repository_single-db";
        String repoToken = creatorService.reserveRepositoryName(tenantName);
        String newDSName = IdGenerator.generate();
        RepositoryEntry newRE = this.helper.createRepositoryEntry(JDBCDataContainerConfig.DatabaseStructureType.SINGLE, repository.getConfiguration().getSystemWorkspaceName(), newDSName);
        newRE.setName(tenantName);
        WorkspaceEntry newWSEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.SINGLE, newDSName);
        newWSEntry.setName(wsEntry.getName());
        newRE.addWorkspace(newWSEntry);
        creatorService.createRepository(bch.getBackupId(), newRE, repoToken);
        ManageableRepository restoredRepository = this.repositoryService.getRepository(tenantName);
        TestRepositoryCreationService.assertNotNull((Object)restoredRepository);
        this.checkConent(restoredRepository, wsEntry.getName());
        RepositoryService repoService = (RepositoryService)this.container.getComponentInstance(RepositoryService.class);
        TestRepositoryCreationService.assertNotNull((Object)repoService.getConfig().getRepositoryConfiguration(tenantName));
        try {
            creatorService.removeRepository(tenantName, false);
            TestRepositoryCreationService.fail((String)"Exception should be thrown");
        }
        catch (RepositoryCreationException repositoryCreationException) {
            // empty catch block
        }
        creatorService.removeRepository(tenantName, true);
        try {
            repoService.getRepository(tenantName);
            TestRepositoryCreationService.fail((String)"Exception should be thrown");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testCreateRepositorySingleDBWithSpecificCreationProps() throws Exception {
        HashMap<String, String> connProps = new HashMap<String, String>();
        connProps.put("driverClassName", "org.hsqldb.jdbcDriver");
        connProps.put("username", "sa");
        connProps.put("password", "");
        DBCreationProperties creationProps = new DBCreationProperties("jdbc:hsqldb:file:target/temp/data_2/", connProps, "src/test/resources/test.sql", "sa", "");
        String dsName = this.helper.createDatasource();
        ManageableRepository repository = this.helper.createRepository((ExoContainer)this.container, JDBCDataContainerConfig.DatabaseStructureType.SINGLE, dsName);
        WorkspaceEntry wsEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.SINGLE, dsName);
        this.helper.addWorkspace(repository, wsEntry);
        this.addConent(repository, wsEntry.getName());
        File backDir = new File("target/backup");
        backDir.mkdirs();
        RepositoryBackupConfig config = new RepositoryBackupConfig();
        config.setRepository(repository.getConfiguration().getName());
        config.setBackupType(0);
        config.setBackupDir(backDir);
        RepositoryBackupChain bch = this.backup.startBackup(config);
        this.waitEndOfBackup(bch);
        this.backup.stopBackup(bch);
        RepositoryCreationService creatorService = (RepositoryCreationService)this.container.getComponentInstanceOfType(RepositoryCreationService.class);
        TestRepositoryCreationService.assertNotNull((Object)creatorService);
        String tenantName = "new_repository_single-db-specific-props";
        String repoToken = creatorService.reserveRepositoryName(tenantName);
        String newDSName = IdGenerator.generate();
        RepositoryEntry newRE = this.helper.createRepositoryEntry(JDBCDataContainerConfig.DatabaseStructureType.SINGLE, repository.getConfiguration().getSystemWorkspaceName(), newDSName);
        newRE.setName(tenantName);
        WorkspaceEntry newWSEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.SINGLE, newDSName);
        newWSEntry.setName(wsEntry.getName());
        newRE.addWorkspace(newWSEntry);
        creatorService.createRepository(bch.getBackupId(), newRE, repoToken, (StorageCreationProperties)creationProps);
        ManageableRepository restoredRepository = this.repositoryService.getRepository(tenantName);
        TestRepositoryCreationService.assertNotNull((Object)restoredRepository);
        this.checkConent(restoredRepository, wsEntry.getName());
        RepositoryService repoService = (RepositoryService)this.container.getComponentInstance(RepositoryService.class);
        TestRepositoryCreationService.assertNotNull((Object)repoService.getConfig().getRepositoryConfiguration(tenantName));
        try {
            creatorService.removeRepository(tenantName, false);
            TestRepositoryCreationService.fail((String)"Exception should be thrown");
        }
        catch (RepositoryCreationException repositoryCreationException) {
            // empty catch block
        }
        creatorService.removeRepository(tenantName, true);
        try {
            repoService.getRepository(tenantName);
            TestRepositoryCreationService.fail((String)"Exception should be thrown");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testReserveRepositoryNameException() throws Exception {
        RepositoryCreationService creatorService = (RepositoryCreationService)this.container.getComponentInstanceOfType(RepositoryCreationService.class);
        String tenantName = "new_repository_2";
        String repoToken = creatorService.reserveRepositoryName(tenantName);
        TestRepositoryCreationService.assertNotNull((Object)repoToken);
        try {
            creatorService.reserveRepositoryName(tenantName);
            TestRepositoryCreationService.fail((String)"There must be RepositoryCreationException.");
        }
        catch (RepositoryCreationException repositoryCreationException) {
            // empty catch block
        }
        try {
            creatorService.reserveRepositoryName(this.repository.getName());
            TestRepositoryCreationService.fail((String)"There must be RepositoryCreationException.");
        }
        catch (RepositoryCreationException repositoryCreationException) {
            // empty catch block
        }
    }

    public void testCreateRepositoryException() throws Exception {
        String tenantName = "new_repository_3";
        ManageableRepository repository = this.helper.createRepository((ExoContainer)this.container, JDBCDataContainerConfig.DatabaseStructureType.MULTI, null);
        WorkspaceEntry wsEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, null);
        this.helper.addWorkspace(repository, wsEntry);
        this.addConent(repository, wsEntry.getName());
        RepositoryCreationService creatorService = (RepositoryCreationService)this.container.getComponentInstanceOfType(RepositoryCreationService.class);
        try {
            creatorService.createRepository("nomatter", repository.getConfiguration(), "any_name");
            TestRepositoryCreationService.fail((String)"There must be RepositoryCreationException.");
        }
        catch (RepositoryCreationException repositoryCreationException) {
            // empty catch block
        }
    }

    public void testCreateRepositoryMultiDBExistingDS() throws Exception {
        ManageableRepository repository = this.helper.createRepository((ExoContainer)this.container, JDBCDataContainerConfig.DatabaseStructureType.MULTI, null);
        WorkspaceEntry wsEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, null);
        this.helper.addWorkspace(repository, wsEntry);
        this.addConent(repository, wsEntry.getName());
        File backDir = new File("target/backup");
        backDir.mkdirs();
        RepositoryBackupConfig config = new RepositoryBackupConfig();
        config.setRepository(repository.getConfiguration().getName());
        config.setBackupType(0);
        config.setBackupDir(backDir);
        RepositoryBackupChain bch = this.backup.startBackup(config);
        this.waitEndOfBackup(bch);
        this.backup.stopBackup(bch);
        RepositoryCreationService creatorService = (RepositoryCreationService)this.container.getComponentInstanceOfType(RepositoryCreationService.class);
        TestRepositoryCreationService.assertNotNull((Object)creatorService);
        String tenantName = "new_repository_mutli-db_existing_ds";
        String repoToken = creatorService.reserveRepositoryName(tenantName);
        RepositoryEntry newRE = this.helper.createRepositoryEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, repository.getConfiguration().getSystemWorkspaceName(), null);
        newRE.setName(tenantName);
        WorkspaceEntry newWSEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, null);
        newWSEntry.setName(wsEntry.getName());
        newRE.addWorkspace(newWSEntry);
        try {
            creatorService.createRepository(bch.getBackupId(), newRE, repoToken);
            TestRepositoryCreationService.fail((String)"Exception should be thrown");
        }
        catch (RepositoryConfigurationException repositoryConfigurationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRepositoryConsistencyAfterForceRemove() throws Exception {
        String dsName = this.helper.createDatasource();
        ManageableRepository repository = this.helper.createRepository((ExoContainer)this.container, JDBCDataContainerConfig.DatabaseStructureType.SINGLE, dsName);
        WorkspaceEntry wsEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.SINGLE, dsName);
        this.helper.addWorkspace(repository, wsEntry);
        this.addConent(repository, wsEntry.getName());
        RepositoryEntry repoEntry = repository.getConfiguration();
        WorkspaceEntry sysWsEntry = (WorkspaceEntry)repository.getConfiguration().getWorkspaceEntries().get(0);
        ContentReader reader = new ContentReader(this, repository);
        ContentWriter writer = new ContentWriter(repository);
        try {
            writer.start();
            reader.start();
            Thread.sleep(15000L);
            this.repositoryService.removeRepository(repository.getConfiguration().getName(), true);
            try {
                this.repositoryService.getConfig().getRepositoryConfiguration(repository.getConfiguration().getName());
                TestRepositoryCreationService.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            reader.halt();
            writer.halt();
        }
        repoEntry.addWorkspace(sysWsEntry);
        repoEntry.addWorkspace(wsEntry);
        this.repositoryService.createRepository(repoEntry);
        TestRepositoryCreationService.assertNotNull((Object)this.repositoryService.getConfig().getRepositoryConfiguration(repoEntry.getName()));
        RepositoryCheckController controller = null;
        try {
            controller = new RepositoryCheckController(repository);
            String report = controller.checkAll();
            TestRepositoryCreationService.assertFalse((boolean)report.contains("NOT consistent"));
        }
        finally {
            File lastReport;
            if (controller != null && controller.getLastReportPath() != null && !(lastReport = new File(controller.getLastReportPath())).delete()) {
                lastReport.deleteOnExit();
            }
        }
    }

    @Override
    protected ExtendedBackupManager getBackupManager() {
        return this.getRDBMSBackupManager();
    }

    class ContentReader
    extends WorkerThread {
        ManageableRepository repository;
        String workspaceName;
        long iterator = 0L;

        public ContentReader(TestRepositoryCreationService this$0, ManageableRepository repository) {
            super(1L);
            this.repository = repository;
            this.workspaceName = ((WorkspaceEntry)repository.getConfiguration().getWorkspaceEntries().get(1)).getName();
        }

        public void callPeriodically() {
            try {
                Session session = this.repository.getSystemSession(this.workspaceName);
                Node file = session.getRootNode().getNode("testNode-" + this.iterator);
                ++this.iterator;
                file.getVersionHistory();
                file.getNode("jcr:content").getProperty("jcr:data");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ContentWriter
    extends WorkerThread {
        ManageableRepository repository;
        String workspaceName;
        long iterator;

        public ContentWriter(ManageableRepository repository) {
            super(1L);
            this.iterator = 0L;
            this.repository = repository;
            this.workspaceName = ((WorkspaceEntry)repository.getConfiguration().getWorkspaceEntries().get(1)).getName();
        }

        public void callPeriodically() {
            try {
                Session session = this.repository.getSystemSession(this.workspaceName);
                Node file = session.getRootNode().addNode("testNode-" + this.iterator++, "nt:file");
                Node content = file.addNode("jcr:content", "nt:resource");
                content.setProperty("jcr:data", (InputStream)new FileInputStream(TestRepositoryCreationService.this.createBLOBTempFile(10)));
                content.setProperty("jcr:mimeType", "text/plain");
                content.setProperty("jcr:lastModified", Calendar.getInstance());
                session.save();
                file.checkin();
                file.checkout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

