/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.ws.rs.core.SecurityContext;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RESTRegistryTest;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.jcr.ext.script.groovy.BaseGroovyTest;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestLoader;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.ext.method.filter.MethodAccessFilter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;
import org.exoplatform.services.rest.tools.DummySecurityContext;
import org.exoplatform.services.rest.tools.ResourceLauncher;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class GroovyScript2RestLoaderTest
extends BaseGroovyTest {
    private Node testRoot;
    private ResourceBinder binder;
    private SessionProviderService sesProv;
    private Node scriptFile;
    private Node script;
    private Node groovyRepo;
    private int resourceNumber = 0;
    private ResourceLauncher launcher;
    private SecurityContext adminSecurityContext;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sesProv = (SessionProviderService)this.container.getComponentInstanceOfType(SessionProviderService.class);
        this.sesProv.setSessionProvider(null, new SessionProvider(new ConversationState(new Identity("root"))));
        this.binder = (ResourceBinder)this.container.getComponentInstanceOfType(ResourceBinder.class);
        this.resourceNumber = this.binder.getSize();
        RequestHandler handler = (RequestHandler)this.container.getComponentInstanceOfType(RequestHandler.class);
        this.testRoot = this.root.addNode("testRoot", "nt:unstructured");
        this.scriptFile = this.testRoot.addNode("script", "nt:file");
        this.script = this.scriptFile.addNode("jcr:content", "exo:groovyResourceContainer");
        this.script.setProperty("exo:autoload", true);
        this.script.setProperty("jcr:mimeType", "script/groovy");
        this.script.setProperty("jcr:lastModified", Calendar.getInstance());
        this.script.setProperty("jcr:data", Thread.currentThread().getContextClassLoader().getResourceAsStream("test1.groovy"));
        this.groovyRepo = this.root.addNode("repo", "nt:folder");
        this.launcher = new ResourceLauncher(handler);
        ProviderBinder.setInstance((ProviderBinder)new ProviderBinder());
        ProviderBinder providers = ProviderBinder.getInstance();
        providers.addMethodInvokerFilter((MethodInvokerFilter)new MethodAccessFilter());
        this.session.save();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        this.adminSecurityContext = new DummySecurityContext(new Principal(this){

            @Override
            public String getName() {
                return "root";
            }
        }, adminRoles);
    }

    public void testStartQuery() throws Exception {
        String xpath = "//element(*, exo:groovyResourceContainer)[@exo:autoload='true']";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
        QueryResult result = query.execute();
        GroovyScript2RestLoaderTest.assertEquals((long)1L, (long)result.getNodes().getSize());
        this.script.setProperty("exo:autoload", false);
        this.session.save();
        result = query.execute();
        GroovyScript2RestLoaderTest.assertEquals((long)0L, (long)result.getNodes().getSize());
    }

    public void testBindScripts() throws Exception {
        GroovyScript2RestLoaderTest.assertEquals((int)(this.resourceNumber + 1), (int)this.binder.getSize());
        this.script.getParent().remove();
        this.session.save();
        GroovyScript2RestLoaderTest.assertEquals((int)this.resourceNumber, (int)this.binder.getSize());
    }

    public void testGetMetatData() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Accept", (Object)"application/json");
        ContainerResponse response = this.launcher.service("POST", "/script/groovy/meta/db1/ws/testRoot/script", "", (Map)headers, null, null);
        GroovyScript2RestLoaderTest.assertEquals((int)200, (int)response.getStatus());
        GroovyScript2RestLoader.ScriptMetadata data = (GroovyScript2RestLoader.ScriptMetadata)response.getEntity();
        GroovyScript2RestLoaderTest.assertEquals((String)"script/groovy", (String)data.getMediaType());
        GroovyScript2RestLoaderTest.assertTrue((boolean)data.getLoad());
    }

    public void testAutoload() throws Exception {
        ContainerResponse cres = this.launcher.service("POST", "/script/groovy/autoload/db1/ws/testRoot/script?state=false", "", null, null, null);
        GroovyScript2RestLoaderTest.assertEquals((int)204, (int)cres.getStatus());
        GroovyScript2RestLoaderTest.assertFalse((boolean)this.script.getProperty("exo:autoload").getBoolean());
        cres = this.launcher.service("POST", "/script/groovy/autoload/db1/ws/testRoot/script", "", null, null, null);
        GroovyScript2RestLoaderTest.assertEquals((int)204, (int)cres.getStatus());
        GroovyScript2RestLoaderTest.assertTrue((boolean)this.script.getProperty("exo:autoload").getBoolean());
    }

    public void testLoad() throws Exception {
        EnvironmentContext ctx = new EnvironmentContext();
        ctx.put(SecurityContext.class, (Object)this.adminSecurityContext);
        ContainerResponse cres = this.launcher.service("POST", "/script/groovy/load/db1/ws/testRoot/script?state=false", "", null, null, ctx);
        GroovyScript2RestLoaderTest.assertEquals((int)204, (int)cres.getStatus());
        GroovyScript2RestLoaderTest.assertEquals((int)this.resourceNumber, (int)this.binder.getSize());
        this.launcher.service("POST", "/script/groovy/load/db1/ws/testRoot/script", "", null, null, ctx);
        GroovyScript2RestLoaderTest.assertEquals((int)204, (int)cres.getStatus());
        GroovyScript2RestLoaderTest.assertEquals((int)(this.resourceNumber + 1), (int)this.binder.getSize());
    }

    public void testLoadNoExtClassPath() throws Exception {
        String path = this.createScript(this.testRoot, "test.load", "Test000.groovy", "import test.load.User000\n@javax.ws.rs.Path('test/load') class Test000 {\ndef user = new User000(name:'test')\n@javax.ws.rs.GET def m() {user}}\n");
        EnvironmentContext ctx = new EnvironmentContext();
        ctx.put(SecurityContext.class, (Object)this.adminSecurityContext);
        int before = this.binder.getSize();
        ContainerResponse cres = this.launcher.service("POST", "/script/groovy/load/db1/ws" + path, "", null, null, ctx);
        GroovyScript2RestLoaderTest.assertEquals((int)400, (int)cres.getStatus());
        int after = this.binder.getSize();
        GroovyScript2RestLoaderTest.assertEquals((int)before, (int)after);
    }

    public void testLoadExtClassPath_File() throws Exception {
        String scriptPath = this.createScript(this.testRoot, "test.load", "Test001.groovy", "import test.load.User001\n@javax.ws.rs.Path('test/load_001') class Test001 {\ndef user = new User001(name:'test')\n@javax.ws.rs.GET def m() {user}}\n");
        String user = this.createScript(this.testRoot, "test.load", "User001.groovy", "package test.load\nclass User001 {def name}");
        EnvironmentContext ctx = new EnvironmentContext();
        ctx.put(SecurityContext.class, (Object)this.adminSecurityContext);
        String path = "/script/groovy/load/db1/ws" + scriptPath + "?file=" + URLEncoder.encode(new UnifiedNodeReference(this.repository.getName(), this.workspace.getName(), user).getURL().toString(), "UTF-8");
        int before = this.binder.getSize();
        ContainerResponse cres = this.launcher.service("POST", path, "", null, null, ctx);
        GroovyScript2RestLoaderTest.assertEquals((int)204, (int)cres.getStatus());
        int after = this.binder.getSize();
        GroovyScript2RestLoaderTest.assertEquals((int)(before + 1), (int)after);
    }

    public void testLoadExtClassPath_SourceFolder() throws Exception {
        String scriptPath = this.createScript(this.testRoot, "test.load", "Test002.groovy", "import test.load.User002\n@javax.ws.rs.Path('test/load_002') class Test002 {\ndef user = new User002(name:'test')\n@javax.ws.rs.GET def m() {user}}\n");
        this.createScript(this.testRoot, "test.load", "User002.groovy", "package test.load\nclass User002 {def name}");
        EnvironmentContext ctx = new EnvironmentContext();
        ctx.put(SecurityContext.class, (Object)this.adminSecurityContext);
        String path = "/script/groovy/load/db1/ws" + scriptPath + "?sources=" + URLEncoder.encode(new UnifiedNodeReference(this.repository.getName(), this.workspace.getName(), this.testRoot.getPath()).getURL().toString(), "UTF-8");
        int before = this.binder.getSize();
        ContainerResponse cres = this.launcher.service("POST", path, "", null, null, ctx);
        GroovyScript2RestLoaderTest.assertEquals((int)204, (int)cres.getStatus());
        int after = this.binder.getSize();
        GroovyScript2RestLoaderTest.assertEquals((int)(before + 1), (int)after);
    }

    public void testDelete() throws Exception {
        ContainerResponse cres = this.launcher.service("POST", "/script/groovy/delete/db1/ws/testRoot/script", "", null, null, null);
        GroovyScript2RestLoaderTest.assertEquals((int)204, (int)cres.getStatus());
        GroovyScript2RestLoaderTest.assertEquals((int)this.resourceNumber, (int)this.binder.getSize());
    }

    public void testGetScript() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Accept", (Object)"script/groovy");
        ByteArrayContainerResponseWriter wr = new ByteArrayContainerResponseWriter();
        ContainerResponse cres = this.launcher.service("POST", "/script/groovy/src/db1/ws/testRoot/script", "", (Map)headers, null, (ContainerResponseWriter)wr, null);
        GroovyScript2RestLoaderTest.assertEquals((int)200, (int)cres.getStatus());
        this.compareStream(this.script.getProperty("jcr:data").getStream(), new ByteArrayInputStream(wr.getBody()));
    }

    public void testAddScript() throws Exception {
        this.script.getParent().remove();
        this.session.save();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-type", (Object)"script/groovy");
        ContainerResponse cres = this.launcher.service("POST", "/script/groovy/add/db1/ws/testRoot/script", "", (Map)headers, this.getResourceAsBytes("test1.groovy"), null, null);
        GroovyScript2RestLoaderTest.assertEquals((int)201, (int)cres.getStatus());
    }

    public void testDispatchScript() throws Exception {
        ContainerResponse cres = this.launcher.service("GET", "/groovy-test/groovy1/test", "", null, null, null);
        GroovyScript2RestLoaderTest.assertEquals((int)200, (int)cres.getStatus());
        GroovyScript2RestLoaderTest.assertEquals((Object)"Hello from groovy to test", (Object)cres.getEntity());
        this.script.setProperty("jcr:data", Thread.currentThread().getContextClassLoader().getResourceAsStream("test2.groovy"));
        this.session.save();
        GroovyScript2RestLoaderTest.assertEquals((int)(this.resourceNumber + 1), (int)this.binder.getSize());
        cres = new ContainerResponse((ContainerResponseWriter)new RESTRegistryTest.DummyContainerResponseWriter());
        cres = this.launcher.service("GET", "/groovy-test/groovy2/test", "", null, null, null);
        GroovyScript2RestLoaderTest.assertEquals((int)200, (int)cres.getStatus());
        GroovyScript2RestLoaderTest.assertEquals((Object)"Hello from groovy to >>>>> test", (Object)cres.getEntity());
    }

    public void testValidate() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"script/groovy");
        String script = "public class Test { def a = 0\ndef =\n}\n";
        ContainerResponse cres = this.launcher.service("POST", "/script/groovy/validate/%5Bno-name%5D", "", (Map)headers, script.getBytes(), null);
        GroovyScript2RestLoaderTest.assertEquals((int)400, (int)cres.getStatus());
        script = "public class Test { def a = 0\ndef b = 1\n }\n";
        cres = this.launcher.service("POST", "/script/groovy/validate/%5Bno-name%5D", "", (Map)headers, script.getBytes(), null);
        GroovyScript2RestLoaderTest.assertEquals((int)200, (int)cres.getStatus());
    }

    public void testValidateNoname() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"script/groovy");
        String script = "public class Test { def a = 0\ndef =\n}\n";
        ContainerResponse cres = this.launcher.service("POST", "/script/groovy/validate/", "", (Map)headers, script.getBytes(), null);
        GroovyScript2RestLoaderTest.assertEquals((int)400, (int)cres.getStatus());
        script = "public class Test { def a = 0\ndef b = 1\n }\n";
        cres = this.launcher.service("POST", "/script/groovy/validate/", "", (Map)headers, script.getBytes(), null);
        GroovyScript2RestLoaderTest.assertEquals((int)200, (int)cres.getStatus());
    }

    public void testValidateNoExtClassPath() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"script/groovy");
        String script = "import test.validate.User000\n@javax.ws.rs.Path('test/validate') class Test {\ndef user = new User000(name:'test')\n@javax.ws.rs.GET def m() {user} }\n";
        ContainerResponse cres = this.launcher.service("POST", "/script/groovy/validate/Test", "", (Map)headers, script.getBytes(), null);
        GroovyScript2RestLoaderTest.assertEquals((int)400, (int)cres.getStatus());
    }

    public void testValidateExtClassPath_File() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"script/groovy");
        String script = "import test.validate.User001\n@javax.ws.rs.Path('test/validate') class Test {\ndef user = new User001(name:'test')\n@javax.ws.rs.GET def m() {user} }\n";
        String user = this.createScript(this.testRoot, "test.validate", "User001.groovy", "package test.validate\nclass User001 {def name}");
        String path = "/script/groovy/validate/Test?file=" + URLEncoder.encode(new UnifiedNodeReference(this.repository.getName(), this.workspace.getName(), user).getURL().toString(), "UTF-8");
        ContainerResponse cres = this.launcher.service("POST", path, "", (Map)headers, script.getBytes(), null);
        GroovyScript2RestLoaderTest.assertEquals((int)200, (int)cres.getStatus());
    }

    public void testValidateExtClassPath_SourceFolder() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"script/groovy");
        String script = "import test.validate.User002\n@javax.ws.rs.Path('test/validate') class Test {\ndef user = new User002(name:'test')\n@javax.ws.rs.GET def m() {user} }\n";
        this.createScript(this.testRoot, "test.validate", "User002.groovy", "package test.validate\nclass User002 {def name}");
        String path = "/script/groovy/validate/Test?sources=" + URLEncoder.encode(new UnifiedNodeReference(this.repository.getName(), this.workspace.getName(), this.testRoot.getPath()).getURL().toString(), "UTF-8");
        ContainerResponse cres = this.launcher.service("POST", path, "", (Map)headers, script.getBytes(), null);
        GroovyScript2RestLoaderTest.assertEquals((int)200, (int)cres.getStatus());
    }

    public void testGroovyDependency() throws Exception {
        this.createScript(this.groovyRepo, "dependencies", "Dep1.groovy", "package dependencies\nclass Dep1 { String name = getClass().getName() }");
        this.script.setProperty("jcr:data", Thread.currentThread().getContextClassLoader().getResourceAsStream("TestDependency.groovy"));
        this.session.save();
        GroovyScript2RestLoaderTest.assertEquals((int)(this.resourceNumber + 1), (int)this.binder.getSize());
        ContainerResponse cres = this.launcher.service("GET", "/groovy-test-dependency", "", null, null, null);
        GroovyScript2RestLoaderTest.assertEquals((int)200, (int)cres.getStatus());
        GroovyScript2RestLoaderTest.assertEquals((Object)"dependencies.Dep1", (Object)cres.getEntity());
    }

    private byte[] getResourceAsBytes(String resource) throws IOException {
        byte[] data = null;
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (stream != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int r = -1;
            while ((r = stream.read(buf)) != -1) {
                bout.write(buf, 0, r);
            }
            data = bout.toByteArray();
        }
        return data;
    }
}

