/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.config;

import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.ftp.config.FtpConfig;
import org.exoplatform.services.log.ExoLogger;

public class FtpConfigImpl
implements FtpConfig {
    private static Log log = ExoLogger.getLogger((String)"jcr.ftpservice.FtpConfigImpl");
    public static final String INIT_PARAM_COMMAND_PORT = "command-port";
    public static final String INIT_PARAM_DATA_MIN_PORT = "data-min-port";
    public static final String INIT_PARAM_DATA_MAX_PORT = "data-max-port";
    public static final String INIT_PARAM_SYSTEM = "system";
    public static final String INIT_PARAM_CLIENT_SIDE_ENCODING = "client-side-encoding";
    public static final String INIT_PARAM_DEF_FOLDER_NODE_TYPE = "def-folder-node-type";
    public static final String INIT_PARAM_DEF_FILE_NODE_TYPE = "def-file-node-type";
    public static final String INIT_PARAM_DEF_FILE_MIME_TYPE = "def-file-mime-type";
    public static final String INIT_PARAM_CACHE_FOLDER_NAME = "cache-folder-name";
    public static final String INIT_PARAM_UPLOAD_SPEED_LIMIT = "upload-speed-limit";
    public static final String INIT_PARAM_DOWNLOAD_SPEED_LIMIT = "download-speed-limit";
    public static final String INIT_PARAM_TIME_OUT = "timeout";
    private int _commandPort = 21;
    private int _dataMinPort = 7000;
    private int _dataMaxPort = 7100;
    private String _system = "Windows_NT";
    private String _clientSideEncoding = "";
    private String _defFolderNodeType = "nt:folder";
    private String _defFileNodeType = "nt:file";
    private String _defFileMimeType = "application/zip";
    private String _cacheFolderName = "";
    private boolean _needSlowUpLoad = false;
    private int _upLoadSpeed = 0;
    private boolean _needSlowDownLoad = false;
    private int _downLoadSpeed = 0;
    private boolean _needTimeOut = false;
    private int _timeOutValue = 0;
    protected boolean ENABLE_TRACE = true;

    public FtpConfigImpl(InitParams params) {
        ValueParam pTimeOut;
        ValueParam pSlowDownLoad;
        ValueParam pSlowUpLoad;
        ValueParam pCacheFolderName;
        ValueParam pFileMimeType;
        ValueParam pFileNodeType;
        ValueParam pFolderNodeType;
        ValueParam pClientSideEncoding;
        ValueParam pSystem;
        ValueParam pDataMaxPort;
        ValueParam pDataMinPort;
        ValueParam pCommandPort = params.getValueParam(INIT_PARAM_COMMAND_PORT);
        if (pCommandPort != null) {
            this._commandPort = new Integer(pCommandPort.getValue());
        }
        if ((pDataMinPort = params.getValueParam(INIT_PARAM_DATA_MIN_PORT)) != null) {
            this._dataMinPort = new Integer(pDataMinPort.getValue());
        }
        if ((pDataMaxPort = params.getValueParam(INIT_PARAM_DATA_MAX_PORT)) != null) {
            this._dataMaxPort = new Integer(pDataMaxPort.getValue());
        }
        if ((pSystem = params.getValueParam(INIT_PARAM_SYSTEM)) != null) {
            this._system = pSystem.getValue();
        }
        if ((pClientSideEncoding = params.getValueParam(INIT_PARAM_CLIENT_SIDE_ENCODING)) != null) {
            this._clientSideEncoding = pClientSideEncoding.getValue();
        }
        if ((pFolderNodeType = params.getValueParam(INIT_PARAM_DEF_FOLDER_NODE_TYPE)) != null) {
            this._defFolderNodeType = pFolderNodeType.getValue();
        }
        if ((pFileNodeType = params.getValueParam(INIT_PARAM_DEF_FILE_NODE_TYPE)) != null) {
            this._defFileNodeType = pFileNodeType.getValue();
        }
        if ((pFileMimeType = params.getValueParam(INIT_PARAM_DEF_FILE_MIME_TYPE)) != null) {
            this._defFileMimeType = pFileMimeType.getValue();
        }
        if ((pCacheFolderName = params.getValueParam(INIT_PARAM_CACHE_FOLDER_NAME)) != null) {
            this._cacheFolderName = pCacheFolderName.getValue();
        }
        if ((pSlowUpLoad = params.getValueParam(INIT_PARAM_UPLOAD_SPEED_LIMIT)) != null) {
            this._needSlowUpLoad = true;
            this._upLoadSpeed = new Integer(pSlowUpLoad.getValue());
        }
        if ((pSlowDownLoad = params.getValueParam(INIT_PARAM_DOWNLOAD_SPEED_LIMIT)) != null) {
            this._needSlowDownLoad = true;
            this._downLoadSpeed = new Integer(pSlowDownLoad.getValue());
        }
        if ((pTimeOut = params.getValueParam(INIT_PARAM_TIME_OUT)) != null) {
            this._needTimeOut = true;
            this._timeOutValue = new Integer(pTimeOut.getValue());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("command-port = " + this._commandPort));
            log.debug((Object)("data-min-port = " + this._dataMinPort));
            log.debug((Object)("data-max-port = " + this._dataMaxPort));
            log.debug((Object)("system = " + this._system));
            log.debug((Object)("client-side-encoding = " + this._clientSideEncoding));
            log.debug((Object)("def-folder-node-type = " + this._defFolderNodeType));
            log.debug((Object)("def-file-node-type = " + this._defFileNodeType));
            log.debug((Object)("def-file-mime-type = " + this._defFileMimeType));
            log.debug((Object)("cache-folder-name = " + this._cacheFolderName));
            log.debug((Object)("upload-speed-limit = " + this._needSlowUpLoad));
            if (this._needSlowUpLoad) {
                log.debug((Object)("upload-speed-limit.value = " + this._upLoadSpeed));
            }
            log.debug((Object)("download-speed-limit = " + this._needSlowDownLoad));
            if (this._needSlowDownLoad) {
                log.debug((Object)("download-speed-limit.value = " + this._downLoadSpeed));
            }
            log.info((Object)("timeout = " + this._needTimeOut));
            if (this._needTimeOut) {
                log.debug((Object)("timeout.value = " + this._timeOutValue));
            }
        }
    }

    public int getCommandPort() {
        return this._commandPort;
    }

    public int getDataMinPort() {
        return this._dataMinPort;
    }

    public int getDataMaxPort() {
        return this._dataMaxPort;
    }

    public String getSystemType() {
        return this._system;
    }

    public String getClientSideEncoding() {
        return this._clientSideEncoding;
    }

    public String getDefFolderNodeType() {
        return this._defFolderNodeType;
    }

    public String getDefFileNodeType() {
        return this._defFileNodeType;
    }

    public String getDefFileMimeType() {
        return this._defFileMimeType;
    }

    public String getCacheFolderName() {
        return this._cacheFolderName;
    }

    public boolean isNeedSlowUpLoad() {
        return this._needSlowUpLoad;
    }

    public int getUpLoadSpeed() {
        return this._upLoadSpeed;
    }

    public boolean isNeedSlowDownLoad() {
        return this._needSlowDownLoad;
    }

    public int getDownLoadSpeed() {
        return this._downLoadSpeed;
    }

    public boolean isNeedTimeOut() {
        return this._needTimeOut;
    }

    public int getTimeOut() {
        return this._timeOutValue;
    }
}

