/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.command;

import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.services.ftp.command.FtpCommandImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CmdRnTo
extends FtpCommandImpl {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ftp.CmdRnTo");

    public CmdRnTo() {
        this.commandName = "RNTO";
    }

    public void run(String[] params) throws IOException {
        if (!"RNFR".equals(this.clientSession().getPrevCommand()) || this.clientSession().getPrevParamsEx() == null) {
            this.reply("503 Bad sequence of commands");
            return;
        }
        if (params.length < 2) {
            this.reply(String.format("500 %s: command requires a parameter", "RNTO"));
            return;
        }
        String pathName = params[1];
        try {
            ArrayList<String> newPath = this.clientSession().getFullPath(pathName);
            Session curSession = this.clientSession().getSession(newPath.get(0));
            String repoPath = this.clientSession().getRepoPath(newPath);
            if (curSession.itemExists(repoPath)) {
                this.reply(String.format("553 %s: Unable to rename file or directory", this.clientSession().getPrevParamsEx()));
                return;
            }
            ArrayList<String> prevParamPath = this.clientSession().getFullPath(this.clientSession().getPrevParamsEx());
            String prevRepoPath = this.clientSession().getRepoPath(prevParamPath);
            if (prevParamPath.get(0).equals(newPath.get(0))) {
                curSession.move(prevRepoPath, repoPath);
                curSession.save();
            } else {
                curSession.getWorkspace().copy(prevParamPath.get(0), prevRepoPath, repoPath);
                Session srcSession = this.clientSession().getSession(prevParamPath.get(0));
                Item item = srcSession.getItem(prevRepoPath);
                item.remove();
                srcSession.save();
            }
            this.reply(String.format("250 %s command successful", "RNTO"));
            return;
        }
        catch (PathNotFoundException pexc) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + pexc.getMessage()));
            }
        }
        catch (NoSuchWorkspaceException wexc) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + wexc.getMessage()));
            }
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exceprion. " + exc.getMessage()), (Throwable)exc);
        }
        this.reply(String.format("550 %s: Permission denied", pathName));
    }
}

