/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.listcode;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.Property;
import org.exoplatform.services.ftp.listcode.FtpFileInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FtpFileInfoImpl
implements FtpFileInfo {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ftp.FtpFileInfoImpl");
    protected String _name = "";
    protected boolean _isCollection = true;
    protected long _size = 0L;
    protected String dateTime = "";
    protected String _month = "Jan";
    protected int _day = 1;
    protected String _time = "00:00";
    public static final String[] MONTHES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String TIME_MASK = "HH:mm";

    @Override
    public void initFromNode(Node node) throws Exception {
        Calendar calendar;
        this._name = node.getName();
        if (!node.isNodeType("nt:folder") && !node.isNodeType("nt:file")) {
            return;
        }
        if (node.isNodeType("nt:file")) {
            this._isCollection = false;
            Node contentNode = node.getNode("jcr:content");
            Property dataProp = contentNode.getProperty("jcr:data");
            this._size = dataProp.getLength();
            calendar = contentNode.getProperty("jcr:lastModified").getDate();
        } else {
            calendar = node.getProperty("jcr:created").getDate();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_MASK, Locale.ENGLISH);
        this._time = dateFormat.format(calendar.getTime());
        this._month = MONTHES[calendar.getTime().getMonth()];
        this._day = calendar.getTime().getDate();
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setType(boolean collection) {
        this._isCollection = collection;
    }

    @Override
    public boolean isCollection() {
        return this._isCollection;
    }

    @Override
    public void setSize(long size) {
        this._size = size;
    }

    @Override
    public long getSize() {
        return this._size;
    }

    @Override
    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    @Override
    public String getDateTime() {
        return this.dateTime;
    }

    @Override
    public String getMonth() {
        return this._month;
    }

    @Override
    public int getDay() {
        return this._day;
    }

    @Override
    public String getTime() {
        return this._time;
    }
}

