/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import junit.framework.TestCase;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class BaseStandaloneTest
extends TestCase {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.ftp.BaseStandaloneTest");
    protected SessionImpl session;
    protected RepositoryImpl repository;
    protected CredentialsImpl credentials;
    protected Workspace workspace;
    protected RepositoryService repositoryService;
    protected Node root;
    protected ValueFactory valueFactory;
    protected StandaloneContainer container;

    public void setUp() throws Exception {
        String containerConf = ((Object)((Object)this)).getClass().getResource("/conf/standalone/test-configuration.xml").toString();
        String loginConf = Thread.currentThread().getContextClassLoader().getResource("login.conf").toString();
        StandaloneContainer.addConfigurationURL((String)containerConf);
        this.container = StandaloneContainer.getInstance();
        if (System.getProperty("java.security.auth.login.config") == null) {
            System.setProperty("java.security.auth.login.config", loginConf);
        }
        this.credentials = new CredentialsImpl("root", "exo".toCharArray());
        this.repositoryService = (RepositoryService)this.container.getComponentInstanceOfType(RepositoryService.class);
        this.repository = (RepositoryImpl)this.repositoryService.getDefaultRepository();
        this.session = (SessionImpl)this.repository.login((Credentials)this.credentials, "ws");
        this.workspace = this.session.getWorkspace();
        this.root = this.session.getRootNode();
        this.valueFactory = this.session.getValueFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        if (this.session != null) {
            try {
                this.session.refresh(false);
                Node rootNode = this.session.getRootNode();
                if (rootNode.hasNodes()) {
                    NodeIterator children = rootNode.getNodes();
                    while (children.hasNext()) {
                        Node node = children.nextNode();
                        if (node.getPath().startsWith("/jcr:system") || node.getPath().startsWith("/exo:audit") || node.getPath().startsWith("/exo:organization")) continue;
                        node.remove();
                    }
                    this.session.save();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)("===== Exception in tearDown() " + e.toString()));
            }
            finally {
                this.session.logout();
            }
        }
        super.tearDown();
    }

    protected void checkItemsExisted(String[] exists, String[] notExists) throws RepositoryException {
        String path = null;
        if (exists != null) {
            try {
                String[] stringArray = exists;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String nodePath;
                    path = nodePath = stringArray[i];
                    this.session.getItem(path);
                }
            }
            catch (PathNotFoundException e) {
                BaseStandaloneTest.fail((String)("Item must exists " + path + ". " + e.getMessage()));
            }
        }
        if (notExists != null) {
            try {
                for (String nodePath : notExists) {
                    this.session.getItem(nodePath);
                    BaseStandaloneTest.fail((String)("Item must not exists " + nodePath));
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
    }

    protected void checkNodesExistedByUUID(String[] exists, String[] notExists) throws RepositoryException {
        String uuid = null;
        if (exists != null) {
            try {
                String[] stringArray = exists;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String nodePath;
                    uuid = nodePath = stringArray[i];
                    this.session.getNodeByUUID(uuid);
                }
            }
            catch (PathNotFoundException e) {
                BaseStandaloneTest.fail((String)("Node must exists, UUID " + uuid + ". " + e.getMessage()));
            }
        }
        if (notExists != null) {
            try {
                for (String nodeUUID : notExists) {
                    this.session.getNodeByUUID(nodeUUID);
                    BaseStandaloneTest.fail((String)("Node must not exists, UUID " + nodeUUID));
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
    }

    protected void compareStream(InputStream etalon, InputStream data) throws IOException {
        try {
            this.compareStream(etalon, data, 0L, 0L, -1L);
        }
        catch (CompareStreamException e) {
            BaseStandaloneTest.fail((String)e.getMessage());
        }
    }

    protected void compareStream(InputStream etalon, InputStream data, long etalonPos, long dataPos, long length) throws IOException, CompareStreamException {
        int dindex = 0;
        this.skipStream(etalon, etalonPos);
        this.skipStream(data, dataPos);
        byte[] ebuff = new byte[1024];
        int eread = 0;
        while ((eread = etalon.read(ebuff)) > 0) {
            byte[] dbuff = new byte[eread];
            int erindex = 0;
            while (erindex < eread) {
                int dread = -1;
                try {
                    dread = data.read(dbuff);
                }
                catch (IOException e) {
                    throw new CompareStreamException("Streams is not equals by length or data stream is unreadable. Cause: " + e.getMessage());
                }
                if (dread == -1) {
                    throw new CompareStreamException("Streams is not equals by length. Data end-of-stream reached at position " + dindex);
                }
                for (int i = 0; i < dread; ++i) {
                    byte eb = ebuff[i];
                    byte db = dbuff[i];
                    if (eb != db) {
                        throw new CompareStreamException("Streams is not equals. Wrong byte stored at position " + dindex + " of data stream. Expected 0x" + Integer.toHexString(eb) + " '" + new String(new byte[]{eb}) + "' but found 0x" + Integer.toHexString(db) + " '" + new String(new byte[]{db}) + "'");
                    }
                    ++erindex;
                    if (length <= 0L || (long)(++dindex) < length) continue;
                    return;
                }
                if (dread >= eread) continue;
                dbuff = new byte[eread - dread];
            }
        }
        if (data.available() > 0) {
            throw new CompareStreamException("Streams is not equals by length. Data stream contains more data. Were read " + dindex);
        }
    }

    protected void skipStream(InputStream stream, long pos) throws IOException {
        long curPos = pos;
        long sk = 0L;
        while ((sk = stream.skip(curPos)) > 0L) {
            curPos -= sk;
        }
        if (sk < 0L) {
            BaseStandaloneTest.fail((String)"Can not read the stream (skip bytes)");
        }
        if (curPos != 0L) {
            BaseStandaloneTest.fail((String)("Can not skip bytes from the stream (" + pos + " bytes)"));
        }
    }

    protected File createBLOBTempFile(int sizeInKb) throws IOException {
        return this.createBLOBTempFile("exo_jcr_test_temp_file_", sizeInKb);
    }

    protected File createBLOBTempFile(String prefix, int sizeInKb) throws IOException {
        byte[] data = new byte[1024];
        File testFile = File.createTempFile(prefix, ".tmp");
        FileOutputStream tempOut = new FileOutputStream(testFile);
        Random random = new Random();
        for (int i = 0; i < sizeInKb; ++i) {
            random.nextBytes(data);
            tempOut.write(data);
        }
        tempOut.close();
        testFile.deleteOnExit();
        return testFile;
    }

    protected void checkMixins(String[] mixins, NodeImpl node) throws RepositoryException {
        try {
            String[] nodeMixins = node.getMixinTypeNames();
            BaseStandaloneTest.assertEquals((String)"Mixins count is different", (int)mixins.length, (int)nodeMixins.length);
            this.compareMixins(mixins, nodeMixins);
        }
        catch (RepositoryException e) {
            BaseStandaloneTest.fail((String)("Mixins isn't accessible on the node " + node.getPath()));
        }
    }

    protected void compareMixins(String[] mixins, String[] nodeMixins) {
        block0: for (String mixin : mixins) {
            for (String nodeMixin : nodeMixins) {
                if (mixin.equals(nodeMixin)) continue block0;
            }
            BaseStandaloneTest.fail((String)("Mixin '" + mixin + "' isn't accessible"));
        }
    }

    protected String memoryInfo() {
        Object info = "";
        info = "free: " + this.mb(Runtime.getRuntime().freeMemory()) + "M of " + this.mb(Runtime.getRuntime().totalMemory()) + "M (max: " + this.mb(Runtime.getRuntime().maxMemory()) + "M)";
        return info;
    }

    protected String mb(long mem) {
        return String.valueOf((double)Math.round((double)mem * 100.0 / 1048576.0) / 100.0);
    }

    protected String execTime(long from) {
        return (double)Math.round((double)(System.currentTimeMillis() - from) * 100.0 / 60000.0) / 100.0 + "min";
    }

    protected class CompareStreamException
    extends Exception {
        private static final long serialVersionUID = -5150674060200906643L;

        CompareStreamException(String message) {
            super(message);
        }

        CompareStreamException(String message, Throwable e) {
            super(message, e);
        }
    }
}

