/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.client;

import java.rmi.RemoteException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.rmi.api.client.ClientObject;
import org.exoplatform.services.jcr.rmi.api.client.LocalAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRepositoryException;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRuntimeException;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteRepository;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteSession;

public class ClientRepository
extends ClientObject
implements Repository {
    private RemoteRepository remote;

    public ClientRepository(RemoteRepository remote, LocalAdapterFactory factory) {
        super(factory);
        this.remote = remote;
    }

    public String getDescriptor(String name) {
        try {
            return this.remote.getDescriptor(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public String[] getDescriptorKeys() {
        try {
            return this.remote.getDescriptorKeys();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public Session login() throws RepositoryException {
        try {
            RemoteSession session = this.remote.login();
            return this.getFactory().getSession(this, session);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Session login(String workspace) throws RepositoryException {
        try {
            RemoteSession session = this.remote.login(workspace);
            return this.getFactory().getSession(this, session);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Session login(Credentials credentials) throws RepositoryException {
        try {
            RemoteSession session = this.remote.login(credentials);
            return this.getFactory().getSession(this, session);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Session login(Credentials credentials, String workspace) throws RepositoryException {
        try {
            RemoteSession session = this.remote.login(credentials, workspace);
            return this.getFactory().getSession(this, session);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }
}

