/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.impl.server;

import java.rmi.RemoteException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteRepository;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteSession;
import org.exoplatform.services.jcr.rmi.impl.server.ServerObject;

public class ServerRepository
extends ServerObject
implements RemoteRepository {
    private static final long serialVersionUID = 3573913076543928313L;
    private Repository repository;

    public ServerRepository(Repository repository, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.repository = repository;
    }

    public String getDescriptor(String name) throws RemoteException {
        return this.repository.getDescriptor(name);
    }

    public String[] getDescriptorKeys() throws RemoteException {
        return this.repository.getDescriptorKeys();
    }

    public RemoteSession login() throws RepositoryException, RemoteException {
        try {
            Session session = this.repository.login();
            return this.getFactory().getRemoteSession(session);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteSession login(String workspace) throws RepositoryException, RemoteException {
        try {
            Session session = this.repository.login(workspace);
            return this.getFactory().getRemoteSession(session);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteSession login(Credentials credentials) throws RepositoryException, RemoteException {
        try {
            Session session = this.repository.login(credentials);
            return this.getFactory().getRemoteSession(session);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteSession login(Credentials credentials, String workspace) throws RemoteException, RepositoryException {
        try {
            Session session = this.repository.login(credentials, workspace);
            return this.getFactory().getRemoteSession(session);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

