/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.impl.server;

import java.rmi.RemoteException;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteVersion;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteVersionHistory;
import org.exoplatform.services.jcr.rmi.impl.server.ServerNode;

public class ServerVersion
extends ServerNode
implements RemoteVersion {
    private static final long serialVersionUID = -7400170340122244982L;
    private Version version;

    public ServerVersion(Version version, RemoteAdapterFactory factory) throws RemoteException {
        super((Node)version, factory);
        this.version = version;
    }

    private RemoteVersion[] getRemoteVersionArray(Version[] versions) throws RemoteException {
        if (versions != null) {
            RemoteVersion[] remotes = new RemoteVersion[versions.length];
            for (int i = 0; i < remotes.length; ++i) {
                remotes[i] = this.getFactory().getRemoteVersion(versions[i]);
            }
            return remotes;
        }
        return new RemoteVersion[0];
    }

    public Calendar getCreated() throws RepositoryException {
        try {
            return this.version.getCreated();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersion[] getSuccessors() throws RepositoryException, RemoteException {
        try {
            return this.getRemoteVersionArray(this.version.getSuccessors());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersion[] getPredecessors() throws RepositoryException, RemoteException {
        try {
            return this.getRemoteVersionArray(this.version.getPredecessors());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersionHistory getContainingHistory() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersionHistory(this.version.getContainingHistory());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

