/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.client;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import org.exoplatform.services.jcr.rmi.api.client.ClientObject;
import org.exoplatform.services.jcr.rmi.api.client.LocalAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRepositoryException;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRuntimeException;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteLock;

public class ClientLock
extends ClientObject
implements Lock {
    private Node node;
    private RemoteLock remote;

    public ClientLock(Node node, RemoteLock remote, LocalAdapterFactory factory) {
        super(factory);
        this.node = node;
        this.remote = remote;
    }

    public Node getNode() {
        try {
            return this.getNode(this.node.getSession(), this.remote.getNode());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getLockOwner() {
        try {
            return this.remote.getLockOwner();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isDeep() {
        try {
            return this.remote.isDeep();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public String getLockToken() {
        try {
            return this.remote.getLockToken();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isLive() throws RepositoryException {
        try {
            return this.remote.isLive();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public void refresh() throws RepositoryException {
        try {
            this.remote.refresh();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public boolean isSessionScoped() {
        try {
            return this.remote.isSessionScoped();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }
}

