/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.value;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.core.value.ExtendedValue;
import org.exoplatform.services.jcr.rmi.api.value.InitialValue;
import org.exoplatform.services.jcr.rmi.api.value.StatefulValue;

final class SerialValue
implements ExtendedValue,
Serializable {
    static final long serialVersionUID = 6970955308427991717L;
    private int type;
    private StatefulValue value;

    public boolean equals(Object obj) {
        boolean retval = false;
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof SerialValue) {
            SerialValue anItem = (SerialValue)obj;
            if (this.value.getType() != anItem.getType()) {
                return false;
            }
            try {
                switch (this.value.getType()) {
                    case 2: {
                        retval = this.getString().equals(anItem.getString());
                        break;
                    }
                    case 6: {
                        retval = this.getBoolean() == anItem.getBoolean();
                        break;
                    }
                    case 5: {
                        retval = this.getDate().equals(anItem.getDate());
                        break;
                    }
                    case 4: {
                        retval = this.getDouble() == anItem.getDouble();
                        break;
                    }
                    case 3: {
                        retval = this.getLong() == anItem.getLong();
                        break;
                    }
                    case 9: {
                        retval = this.getReference().equals(anItem.getReference());
                        break;
                    }
                    case 1: {
                        retval = this.getString().equals(anItem.getString());
                        break;
                    }
                }
            }
            catch (ValueFormatException e) {
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return retval;
    }

    SerialValue(StatefulValue value) {
        this.type = value.getType();
        this.value = new InitialValue(this, value);
    }

    void setValue(StatefulValue value) {
        this.value = value;
    }

    public InputStream getStream() throws IllegalStateException, RepositoryException {
        return this.value.getStream();
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.getString();
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.getLong();
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.getDouble();
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.getDate();
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.getBoolean();
    }

    public int getType() {
        return this.type;
    }

    public long getLength() {
        return this.value.getLength();
    }

    public int getOrderNumber() {
        return this.value.getOrderNumber();
    }

    public void setOrderNumber(int order) {
        this.value.setOrderNumber(order);
    }

    public String getReference() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.getReference();
    }
}

