/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.value;

import java.io.Serializable;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.rmi.api.value.BaseNonStreamValue;
import org.exoplatform.services.jcr.rmi.api.value.BooleanValue;
import org.exoplatform.services.jcr.rmi.api.value.DateValue;
import org.exoplatform.services.jcr.rmi.api.value.DoubleValue;
import org.exoplatform.services.jcr.rmi.api.value.LongValue;
import org.exoplatform.services.jcr.rmi.api.value.StatefulValue;

public class StringValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = -6456025645604163205L;
    private final String value;

    protected StringValue(String value) {
        this.value = value;
    }

    public int getType() {
        return 1;
    }

    public String getString() {
        return this.value;
    }

    public long getLong() throws ValueFormatException {
        return LongValue.toLong(this.value);
    }

    public double getDouble() throws ValueFormatException {
        return DoubleValue.toDouble(this.value);
    }

    public Calendar getDate() throws ValueFormatException {
        return DateValue.toCalendar(this.value);
    }

    public boolean getBoolean() {
        return BooleanValue.toBoolean(this.value);
    }

    public long getLength() {
        return 0L;
    }

    public int getOrderNumber() {
        return 0;
    }
}

