/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.client;

import java.rmi.RemoteException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.rmi.api.client.ClientObject;
import org.exoplatform.services.jcr.rmi.api.client.LocalAdapterFactoryImpl;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRepositoryException;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteNamespaceRegistry;

public class ClientNamespaceRegistry
extends ClientObject
implements NamespaceRegistry {
    private RemoteNamespaceRegistry remote;

    public ClientNamespaceRegistry(RemoteNamespaceRegistry remote, LocalAdapterFactoryImpl factory) {
        super(factory);
        this.remote = remote;
    }

    public void registerNamespace(String prefix, String uri) throws RepositoryException {
        try {
            this.remote.registerNamespace(prefix, uri);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void unregisterNamespace(String prefix) throws RepositoryException {
        try {
            this.remote.unregisterNamespace(prefix);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public String[] getPrefixes() throws RepositoryException {
        try {
            return this.remote.getPrefixes();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public String[] getURIs() throws RepositoryException {
        try {
            return this.remote.getURIs();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public String getURI(String prefix) throws RepositoryException {
        try {
            return this.remote.getURI(prefix);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public String getPrefix(String uri) throws RepositoryException {
        try {
            return this.remote.getPrefix(uri);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }
}

