/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.value;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.exoplatform.services.jcr.rmi.api.value.BaseNonStreamValue;
import org.exoplatform.services.jcr.rmi.api.value.StatefulValue;

public class PermissionValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = 1475495561074957852L;
    private String identity;
    private String permission;

    public PermissionValue(String identity, String permission) {
        if (identity != null && identity.indexOf(" ") != -1) {
            throw new RuntimeException("Identity should not contain ' '");
        }
        if (!(permission == null || permission.equals("read") || permission.equals("add_node") || permission.equals("remove") || permission.equals("set_property"))) {
            throw new RuntimeException("Permission should be one of defined in PermissionType. Have " + permission);
        }
        this.identity = identity;
        this.permission = permission;
    }

    public static PermissionValue parseValue(String pstring) {
        String[] persArray = PermissionValue.parse(pstring);
        return new PermissionValue(persArray[0], persArray[1]);
    }

    public static String[] parse(String pstring) {
        StringTokenizer parser = new StringTokenizer(pstring, ";");
        String identityString = parser.nextToken();
        String permissionString = parser.nextToken();
        String[] persArray = new String[]{identityString != null ? identityString : "any", permissionString != null ? permissionString : "read"};
        return persArray;
    }

    public long getLength() {
        return this.getString().length();
    }

    public String getString() {
        return PermissionValue.asString(this.identity, this.permission);
    }

    public int getType() {
        return 100;
    }

    protected static String asString(String identity, String permission) {
        if (identity != null || permission != null) {
            return (identity != null ? identity : "any") + ";" + (permission != null ? permission : "read");
        }
        return "";
    }
}

