/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.value;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.rmi.api.value.SerialValue;
import org.exoplatform.services.jcr.rmi.api.value.SerialValueFactory;
import org.exoplatform.services.jcr.rmi.api.value.StatefulValue;
import org.exoplatform.services.jcr.rmi.api.value.StringValue;

final class InitialValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = -3277781963593015976L;
    private final SerialValue general;
    private final StatefulValue value;

    InitialValue(SerialValue general, StatefulValue value) {
        this.general = general;
        this.value = value;
    }

    private static String toString(InputStream input) throws ValueFormatException, RepositoryException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
            return new String(output.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            throw new ValueFormatException("Failed to convert from binary to string value", (Throwable)e);
        }
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() != 2 ? SerialValueFactory.getInstance().createBinaryValue(this.value.getString()) : this.value;
        this.general.setValue(realValue);
        return realValue.getStream();
    }

    public String getString() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() == 2 ? new StringValue(InitialValue.toString(this.value.getStream())) : this.value;
        this.general.setValue(realValue);
        return realValue.getString();
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() == 2 ? SerialValueFactory.getInstance().createLongValue(InitialValue.toString(this.value.getStream())) : this.value;
        this.general.setValue(realValue);
        return realValue.getLong();
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() == 2 ? SerialValueFactory.getInstance().createDoubleValue(InitialValue.toString(this.value.getStream())) : this.value;
        this.general.setValue(realValue);
        return realValue.getDouble();
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() == 2 ? SerialValueFactory.getInstance().createDateValue(InitialValue.toString(this.value.getStream())) : this.value;
        this.general.setValue(realValue);
        return realValue.getDate();
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() == 2 ? SerialValueFactory.getInstance().createBooleanValue(InitialValue.toString(this.value.getStream())) : this.value;
        this.general.setValue(realValue);
        return realValue.getBoolean();
    }

    public String getReference() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.general.setValue(this.value);
        return this.value.getReference();
    }

    public int getType() {
        return this.value.getType();
    }

    public long getLength() {
        return this.toString().length();
    }

    public int getOrderNumber() {
        return this.value.getOrderNumber();
    }

    public void setOrderNumber(int arg0) {
        this.value.setOrderNumber(arg0);
    }
}

