/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.impl.server;

import java.net.InetAddress;
import java.rmi.Naming;
import java.util.List;
import javax.jcr.Repository;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteRepository;
import org.exoplatform.services.jcr.rmi.impl.server.JCRSerever;
import org.exoplatform.services.jcr.rmi.impl.server.RemoteAdapterFactoryImpl;
import org.picocontainer.Startable;

public class JCRServerImpl
implements JCRSerever,
Startable {
    private final int rmiPort;
    private final boolean autoBind;
    private boolean bound = false;
    private final RemoteAdapterFactory factory;
    private final RepositoryService service;

    public JCRServerImpl(InitParams params, RepositoryService service) {
        this.rmiPort = Integer.valueOf(params.getValueParam("rmiPort").getValue());
        this.autoBind = Boolean.valueOf(params.getValueParam("autoBind").getValue());
        this.factory = new RemoteAdapterFactoryImpl();
        this.service = service;
    }

    public void bind() {
        if (this.bound) {
            return;
        }
        String bindName = "";
        try {
            List config = this.service.getConfig().getRepositoryConfigurations();
            for (int i = 1; i <= config.size(); ++i) {
                RepositoryEntry conf = (RepositoryEntry)config.get(i - 1);
                RemoteRepository remote = this.factory.getRemoteRepository((Repository)this.service.getRepository(conf.getName()));
                InetAddress addr = InetAddress.getLocalHost();
                String hostname = addr.getHostName();
                bindName = "//" + hostname;
                if (this.rmiPort > 0) {
                    bindName = bindName + ":" + String.valueOf(this.rmiPort);
                }
                bindName = bindName + "/" + conf.getName();
                System.out.println(bindName);
                Naming.bind(bindName, remote);
            }
            this.bound = true;
        }
        catch (Exception e) {
            throw new RuntimeException(bindName + ": " + e.toString(), e);
        }
    }

    public void start() {
        if (this.autoBind) {
            this.bind();
        }
    }

    public void stop() {
        if (this.autoBind) {
            this.unbind();
        }
    }

    public void unbind() {
        String bindName = "";
        try {
            List config = this.service.getConfig().getRepositoryConfigurations();
            for (int i = 1; i <= config.size(); ++i) {
                RepositoryEntry conf = (RepositoryEntry)config.get(i - 1);
                InetAddress addr = InetAddress.getLocalHost();
                String hostname = addr.getHostName();
                bindName = "//" + hostname;
                if (this.rmiPort > 0) {
                    bindName = bindName + ":" + String.valueOf(this.rmiPort);
                }
                bindName = bindName + "/" + conf.getName();
                Naming.unbind(bindName);
            }
            this.bound = false;
        }
        catch (Exception e) {
            throw new RuntimeException(bindName + ": " + e.toString(), e);
        }
    }
}

